/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.repository.IRepository;

public class AvailableIUElement
extends QueriedElement
implements IIUElement {
    IInstallableUnit iu;
    boolean shouldShowChildren;
    boolean isInstalled = false;
    boolean isUpdate = false;
    boolean isPatch = false;
    boolean beingAdded = false;
    boolean beingDowngraded = false;
    boolean beingUpgraded = false;
    boolean beingRemoved = false;
    private String imageId;
    private String imageOverlayId;
    private static boolean shouldShowSize = false;
    long size = -1L;
    String profileID;

    public AvailableIUElement(Object parent, IInstallableUnit iu, String profileID, boolean showChildren) {
        super(parent);
        this.iu = iu;
        this.profileID = profileID;
        this.shouldShowChildren = showChildren;
        this.isPatch = iu == null ? false : Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.patch"));
    }

    @Override
    protected String getImageId(Object obj) {
        if (this.imageId != null) {
            return this.imageId;
        }
        if (this.isUpdate) {
            return "obj/iu_update_obj.png";
        }
        if (this.isPatch) {
            return this.isInstalled ? "obj/iu_disabled_patch_obj.png" : "obj/iu_patch_obj.png";
        }
        if (this.isInstalled) {
            return "obj/iu_disabled_obj.png";
        }
        if (this.beingDowngraded) {
            return "obj/iu_downgraded.png";
        }
        if (this.beingUpgraded) {
            return "obj/iu_upgraded.png";
        }
        return "obj/iu_obj.png";
    }

    @Override
    public String getImageOverlayId(Object obj) {
        if (this.imageOverlayId != null) {
            return this.imageOverlayId;
        }
        if (this.beingRemoved) {
            return "ovr/removed_overlay.png";
        }
        if (this.beingAdded) {
            return "ovr/added_overlay.png";
        }
        return null;
    }

    @Override
    public String getLabel(Object o) {
        return this.iu.getId();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IInstallableUnit.class) {
            return (T)this.iu;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void computeSize(IProgressMonitor monitor) {
        if (this.profileID == null) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProvisioningPlan plan = this.getSizingPlan((IProgressMonitor)mon.newChild(50));
        this.size = ProvUI.getSize(this.getEngine(), plan, this.getProvisioningContext(), (IProgressMonitor)mon.newChild(50));
    }

    protected IProfile getProfile() {
        return this.getProfileRegistry().getProfile(this.profileID);
    }

    protected IProvisioningPlan getSizingPlan(IProgressMonitor monitor) {
        IPlanner planner = this.getPlanner();
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.getProvisioningUI().getSession().getProvisioningAgent(), (String)this.profileID);
        request.add(this.getIU());
        return planner.getProvisioningPlan((IProfileChangeRequest)request, this.getProvisioningContext(), monitor);
    }

    IEngine getEngine() {
        return ProvUI.getEngine(this.getProvisioningUI().getSession());
    }

    IPlanner getPlanner() {
        return (IPlanner)this.getProvisioningUI().getSession().getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
    }

    IProfileRegistry getProfileRegistry() {
        return ProvUI.getProfileRegistry(this.getProvisioningUI().getSession());
    }

    @Override
    public IInstallableUnit getIU() {
        return this.iu;
    }

    @Override
    public boolean shouldShowSize() {
        return shouldShowSize;
    }

    @Override
    public boolean shouldShowVersion() {
        return true;
    }

    @Override
    protected int getDefaultQueryType() {
        return 4;
    }

    @Override
    public Collection<IRequirement> getRequirements() {
        return this.iu.getRequirements();
    }

    @Override
    public boolean shouldShowChildren() {
        return this.shouldShowChildren;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableIUElement)) {
            return false;
        }
        if (this.iu == null) {
            return false;
        }
        if (!this.iu.equals((Object)((AvailableIUElement)obj).getIU())) {
            return false;
        }
        Object parent = this.getParent(this);
        Object objParent = ((AvailableIUElement)obj).getParent(obj);
        if (parent != null && objParent != null) {
            return parent.equals(objParent);
        }
        return parent == null && objParent == null;
    }

    public int hashCode() {
        if (this.iu == null) {
            return 0;
        }
        return this.iu.hashCode();
    }

    public String toString() {
        if (this.iu == null) {
            return "NULL";
        }
        return this.iu.toString();
    }

    public void setIsInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setIsPatch(boolean isPatch) {
        this.isPatch = isPatch;
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    private ProvisioningContext getProvisioningContext() {
        ProvisioningContext context = new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        if (this.hasQueryable() && this.getQueryable() instanceof IRepository) {
            context.setMetadataRepositories(new URI[]{((IRepository)this.getQueryable()).getLocation()});
        }
        return context;
    }

    public boolean isBeingAdded() {
        return this.beingAdded;
    }

    public void setBeingAdded(boolean beingAdded) {
        this.beingAdded = beingAdded;
    }

    public boolean isBeingDowngraded() {
        return this.beingDowngraded;
    }

    public void setBeingDowngraded(boolean beingDowngraded) {
        this.beingDowngraded = beingDowngraded;
    }

    public boolean isBeingUpgraded() {
        return this.beingUpgraded;
    }

    public void setBeingUpgraded(boolean beingUpgraded) {
        this.beingUpgraded = beingUpgraded;
    }

    public boolean isBeingRemoved() {
        return this.beingRemoved;
    }

    public void setBeingRemoved(boolean beingRemoved) {
        this.beingRemoved = beingRemoved;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public void setImageOverlayId(String imageOverlayId) {
        this.imageOverlayId = imageOverlayId;
    }
}

