/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=NexusIndexer.class)
public class DefaultNexusIndexer
extends AbstractLogEnabled
implements NexusIndexer {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();
    @Requirement
    private Scanner scanner;
    @Requirement
    private SearchEngine searcher;
    @Requirement
    private IndexerEngine indexerEngine;
    @Requirement
    private QueryCreator queryCreator;
    private Map<String, IndexingContext> indexingContexts = new ConcurrentHashMap<String, IndexingContext>();

    @Override
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException, UnsupportedExistingLuceneIndexException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, indexers, false);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addIndexingContextForced(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException {
        DefaultIndexingContext context = null;
        try {
            context = new DefaultIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, indexers, true);
            this.indexingContexts.put(context.getId(), context);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            // empty catch block
        }
        return context;
    }

    @Override
    @Deprecated
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers, boolean reclaimIndexOwnership) throws IOException, UnsupportedExistingLuceneIndexException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, indexers, reclaimIndexOwnership);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, Directory directory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException, UnsupportedExistingLuceneIndexException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, directory, repositoryUrl, indexUpdateUrl, indexers, false);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public IndexingContext addIndexingContextForced(String id, String repositoryId, File repository, Directory directory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException {
        DefaultIndexingContext context = null;
        try {
            context = new DefaultIndexingContext(id, repositoryId, repository, directory, repositoryUrl, indexUpdateUrl, indexers, true);
            this.indexingContexts.put(context.getId(), context);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            // empty catch block
        }
        return context;
    }

    @Override
    @Deprecated
    public IndexingContext addIndexingContext(String id, String repositoryId, File repository, Directory directory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers, boolean reclaimIndexOwnership) throws IOException, UnsupportedExistingLuceneIndexException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, directory, repositoryUrl, indexUpdateUrl, indexers, reclaimIndexOwnership);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    @Override
    public void removeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        if (this.indexingContexts.containsKey(context.getId())) {
            this.indexingContexts.remove(context.getId());
            context.close(deleteFiles);
        }
    }

    @Override
    public Map<String, IndexingContext> getIndexingContexts() {
        return Collections.unmodifiableMap(this.indexingContexts);
    }

    @Override
    public void scan(IndexingContext context) throws IOException {
        this.scan(context, null);
    }

    @Override
    public void scan(IndexingContext context, boolean update) throws IOException {
        this.scan(context, null, update);
    }

    @Override
    public void scan(IndexingContext context, ArtifactScanningListener listener) throws IOException {
        this.scan(context, listener, false);
    }

    @Override
    public void scan(IndexingContext context, ArtifactScanningListener listener, boolean update) throws IOException {
        this.scan(context, null, listener, update);
    }

    @Override
    public void scan(IndexingContext context, String fromPath, ArtifactScanningListener listener, boolean update) throws IOException {
        File tmpFile;
        File tmpDir;
        File repositoryDirectory = context.getRepository();
        if (!repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        File indexDir = context.getIndexDirectoryFile();
        File dir = null;
        if (indexDir != null) {
            dir = indexDir.getParentFile();
        }
        if (!(tmpDir = new File((tmpFile = File.createTempFile(context.getId() + "-tmp", "", dir)).getParentFile(), tmpFile.getName() + ".dir")).mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + tmpDir);
        }
        IndexingContext tmpContext = null;
        try {
            FSDirectory directory = FSDirectory.getDirectory((File)tmpDir);
            if (update) {
                Directory.copy((Directory)context.getIndexDirectory(), (Directory)directory, (boolean)false);
            }
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), (Directory)directory, context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            this.scanner.scan(new ScanningRequest(tmpContext, new DefaultScannerListener(tmpContext, this.indexerEngine, update, listener), fromPath));
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
            this.removeIndexingContext(tmpContext, true);
        }
        catch (Exception ex) {
            throw (IOException)new IOException("Error scanning context " + context.getId() + ": " + ex).initCause(ex);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    @Override
    public void artifactDiscovered(ArtifactContext ac, IndexingContext context) throws IOException {
        if (ac != null) {
            this.indexerEngine.index(context, ac);
        }
    }

    @Override
    public void addArtifactToIndex(ArtifactContext ac, IndexingContext context) throws IOException {
        if (ac != null) {
            this.indexerEngine.update(context, ac);
        }
    }

    @Override
    public void deleteArtifactFromIndex(ArtifactContext ac, IndexingContext context) throws IOException {
        if (ac != null) {
            this.indexerEngine.remove(context, ac);
        }
    }

    @Override
    @Deprecated
    public Collection<ArtifactInfo> searchFlat(Query query) throws IOException {
        return this.searchFlat(ArtifactInfo.VERSION_COMPARATOR, query);
    }

    @Override
    @Deprecated
    public Collection<ArtifactInfo> searchFlat(Query query, IndexingContext context) throws IOException {
        return this.searchFlat(ArtifactInfo.VERSION_COMPARATOR, query, context);
    }

    @Override
    @Deprecated
    public Collection<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, Query query) throws IOException {
        return this.searcher.searchFlat(artifactInfoComparator, this.indexingContexts.values(), query);
    }

    @Override
    @Deprecated
    public Collection<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, Query query, IndexingContext context) throws IOException {
        return this.searcher.searchFlat(artifactInfoComparator, context, query);
    }

    @Override
    public FlatSearchResponse searchFlat(FlatSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return this.searcher.searchFlatPaged(request, this.indexingContexts.values());
        }
        return this.searcher.forceSearchFlatPaged(request, request.getContexts());
    }

    @Override
    public IteratorSearchResponse searchIterator(IteratorSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return this.searcher.searchIteratorPaged(request, this.indexingContexts.values());
        }
        return this.searcher.forceSearchIteratorPaged(request, request.getContexts());
    }

    @Override
    @Deprecated
    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping grouping, Query query) throws IOException {
        return this.searchGrouped(grouping, String.CASE_INSENSITIVE_ORDER, query);
    }

    @Override
    @Deprecated
    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping grouping, Query query, IndexingContext context) throws IOException {
        return this.searchGrouped(grouping, String.CASE_INSENSITIVE_ORDER, query, context);
    }

    @Override
    @Deprecated
    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping grouping, Comparator<String> groupKeyComparator, Query query) throws IOException {
        return this.searcher.searchGrouped(new GroupedSearchRequest(query, grouping, groupKeyComparator), this.indexingContexts.values()).getResults();
    }

    @Override
    @Deprecated
    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping grouping, Comparator<String> groupKeyComparator, Query query, IndexingContext context) throws IOException {
        return this.searcher.searchGrouped(new GroupedSearchRequest(query, grouping, groupKeyComparator), Arrays.asList(context)).getResults();
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return this.searcher.searchGrouped(request, this.indexingContexts.values());
        }
        return this.searcher.forceSearchGrouped(request, request.getContexts());
    }

    @Override
    public Query constructQuery(String field, String query) {
        return this.queryCreator.constructQuery(field, query);
    }

    @Override
    public Query constructQuery(Field field, String query, SearchType type) {
        return this.queryCreator.constructQuery(field, query, type);
    }

    @Override
    public ArtifactInfo identify(File artifact) throws IOException {
        ArtifactInfo artifactInfo;
        FileInputStream is = null;
        try {
            int n;
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            is = new FileInputStream(artifact);
            byte[] buff = new byte[4096];
            while ((n = is.read(buff)) > -1) {
                sha1.update(buff, 0, n);
            }
            byte[] digest = sha1.digest();
            artifactInfo = this.identify(MAVEN.SHA1, DefaultNexusIndexer.encode(digest));
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                throw new IOException("Unable to calculate digest");
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
        return artifactInfo;
    }

    private static String encode(byte[] digest) {
        char[] buff = new char[digest.length * 2];
        int n = 0;
        for (byte b : digest) {
            buff[n++] = DIGITS[(0xF0 & b) >> 4];
            buff[n++] = DIGITS[0xF & b];
        }
        return new String(buff);
    }

    @Override
    @Deprecated
    public ArtifactInfo identify(String field, String query) throws IOException {
        return this.identify((Query)new TermQuery(new Term(field, query)));
    }

    @Override
    public ArtifactInfo identify(Field field, String query) throws IOException {
        return this.identify(this.queryCreator.constructQuery(field, query, SearchType.EXACT));
    }

    @Override
    public ArtifactInfo identify(Query query) throws IOException {
        return this.identify(query, this.indexingContexts.values());
    }

    @Override
    public ArtifactInfo identify(Query query, Collection<IndexingContext> contexts) throws IOException {
        IteratorSearchResponse result = this.searcher.searchIteratorPaged(new IteratorSearchRequest(query), contexts);
        if (result.getTotalHits() > 0) {
            return (ArtifactInfo)result.getResults().next();
        }
        return null;
    }
}

