/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCertification;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.FeatureFilter;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.mylyn.internal.discovery.core.util.WebUtil;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ConnectorDiscovery {
    private List<DiscoveryConnector> connectors = Collections.emptyList();
    private List<DiscoveryCategory> categories = Collections.emptyList();
    private List<DiscoveryCertification> certifications = Collections.emptyList();
    private List<DiscoveryConnector> filteredConnectors = Collections.emptyList();
    private final List<AbstractDiscoveryStrategy> discoveryStrategies = new ArrayList<AbstractDiscoveryStrategy>();
    private Dictionary<Object, Object> environment = System.getProperties();
    private boolean verifyUpdateSiteAvailability = false;
    private Map<String, Version> featureToVersion = null;

    public List<AbstractDiscoveryStrategy> getDiscoveryStrategies() {
        return this.discoveryStrategies;
    }

    public IStatus performDiscovery(IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.discovery.core", 0, Messages.ConnectorDiscovery_Failed_to_discovery_all_Error, null);
        if (this.discoveryStrategies.isEmpty()) {
            throw new IllegalStateException();
        }
        this.connectors = new ArrayList<DiscoveryConnector>();
        this.filteredConnectors = new ArrayList<DiscoveryConnector>();
        this.categories = new ArrayList<DiscoveryCategory>();
        this.certifications = new ArrayList<DiscoveryCertification>();
        int totalTicks = 100000;
        int discoveryTicks = 90000;
        int filterTicks = 10000;
        monitor.beginTask(Messages.ConnectorDiscovery_task_discovering_connectors, 100000);
        try {
            for (AbstractDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
                discoveryStrategy.setCategories(this.categories);
                discoveryStrategy.setConnectors(this.connectors);
                discoveryStrategy.setCertifications(this.certifications);
                try {
                    discoveryStrategy.performDiscovery((IProgressMonitor)new SubProgressMonitor(monitor, 90000 / this.discoveryStrategies.size()));
                }
                catch (CoreException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.ConnectorDiscovery_Strategy_failed_Error, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e));
                }
            }
            this.filterDescriptors();
            if (this.verifyUpdateSiteAvailability) {
                this.verifySiteAvailability((IProgressMonitor)new SubProgressMonitor(monitor, 10000));
            }
            this.connectCategoriesToDescriptors();
            this.connectCertificationsToDescriptors();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public List<DiscoveryCategory> getCategories() {
        return this.categories;
    }

    public List<DiscoveryConnector> getConnectors() {
        return this.connectors;
    }

    public List<DiscoveryConnector> getFilteredConnectors() {
        return this.filteredConnectors;
    }

    public Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }

    public boolean isVerifyUpdateSiteAvailability() {
        return this.verifyUpdateSiteAvailability;
    }

    public void setVerifyUpdateSiteAvailability(boolean verifyUpdateSiteAvailability) {
        this.verifyUpdateSiteAvailability = verifyUpdateSiteAvailability;
    }

    public Map<String, Version> getFeatureToVersion() {
        return this.featureToVersion;
    }

    public void setFeatureToVersion(Map<String, Version> featureToVersion) {
        this.featureToVersion = featureToVersion;
    }

    private void connectCertificationsToDescriptors() {
        HashMap<String, DiscoveryCertification> idToCertification = new HashMap<String, DiscoveryCertification>();
        for (DiscoveryCertification certification : this.certifications) {
            DiscoveryCertification previous = idToCertification.put(certification.getId(), certification);
            if (previous == null) continue;
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Duplicate certification id ''{0}'': declaring sources: {1}, {2}", (Object[])new Object[]{certification.getId(), certification.getSource().getId(), previous.getSource().getId()})));
        }
        for (DiscoveryConnector connector : this.connectors) {
            if (connector.getCertificationId() == null) continue;
            DiscoveryCertification certification = (DiscoveryCertification)idToCertification.get(connector.getCertificationId());
            if (certification != null) {
                connector.setCertification(certification);
                continue;
            }
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Unknown category ''{0}'' referenced by connector ''{1}'' declared in {2}", (Object[])new Object[]{connector.getCertificationId(), connector.getId(), connector.getSource().getId()})));
        }
    }

    private void connectCategoriesToDescriptors() {
        HashMap<String, DiscoveryCategory> idToCategory = new HashMap<String, DiscoveryCategory>();
        for (DiscoveryCategory category : this.categories) {
            DiscoveryCategory previous = idToCategory.put(category.getId(), category);
            if (previous == null) continue;
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.ConnectorDiscovery_duplicate_category_id, (Object[])new Object[]{category.getId(), category.getSource().getId(), previous.getSource().getId()})));
        }
        for (DiscoveryConnector connector : this.connectors) {
            DiscoveryCategory category = (DiscoveryCategory)idToCategory.get(connector.getCategoryId());
            if (category != null) {
                category.getConnectors().add(connector);
                connector.setCategory(category);
                continue;
            }
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.ConnectorDiscovery_bundle_references_unknown_category, (Object[])new Object[]{connector.getCategoryId(), connector.getId(), connector.getSource().getId()})));
        }
    }

    private void filterDescriptors() {
        block2: for (DiscoveryConnector connector : new ArrayList<DiscoveryConnector>(this.connectors)) {
            if (connector.getPlatformFilter() != null && connector.getPlatformFilter().trim().length() > 0) {
                boolean match = false;
                try {
                    Filter filter = FrameworkUtil.createFilter((String)connector.getPlatformFilter());
                    match = filter.match(this.environment);
                }
                catch (InvalidSyntaxException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.ConnectorDiscovery_illegal_filter_syntax, (Object[])new Object[]{connector.getPlatformFilter(), connector.getId(), connector.getSource().getId()})));
                }
                if (!match) {
                    this.connectors.remove(connector);
                    this.filteredConnectors.add(connector);
                }
            }
            for (FeatureFilter featureFilter : connector.getFeatureFilter()) {
                VersionRange versionRange;
                if (this.featureToVersion == null) {
                    this.featureToVersion = this.computeFeatureToVersion();
                }
                boolean match = false;
                Version version = this.featureToVersion.get(featureFilter.getFeatureId());
                if (version != null && (versionRange = new VersionRange(featureFilter.getVersion())).isIncluded(version)) {
                    match = true;
                }
                if (match) continue;
                this.connectors.remove(connector);
                this.filteredConnectors.add(connector);
                continue block2;
            }
        }
    }

    private Map<String, Version> computeFeatureToVersion() {
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup bundleGroup = iBundleGroupArray[n4];
                Bundle[] bundleArray = bundleGroup.getBundles();
                int n5 = bundleArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Bundle bundle = bundleArray[n6];
                    featureToVersion.put(bundle.getSymbolicName(), bundle.getVersion());
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return featureToVersion;
    }

    /*
     * Exception decompiling
     */
    public void verifySiteAvailability(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dispose() {
        for (final AbstractDiscoveryStrategy strategy : this.discoveryStrategies) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    strategy.dispose();
                }

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", String.valueOf(Messages.ConnectorDiscovery_exception_disposing) + strategy.getClass().getName(), exception));
                }
            });
        }
    }

    private static class VerifyUpdateSiteJob
    implements Callable<VerifyUpdateSiteJob> {
        private final String url;
        private boolean ok = false;

        public VerifyUpdateSiteJob(String url) {
            this.url = url;
        }

        @Override
        public VerifyUpdateSiteJob call() throws MalformedURLException, URISyntaxException {
            URL baseUrl = new URL(this.url);
            ArrayList<URI> locations = new ArrayList<URI>();
            String[] stringArray = new String[]{"content.jar", "content.xml", "compositeContent.jar", "compositeContent.xml", "site.xml"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                locations.add(new URL(baseUrl, location).toURI());
                ++n2;
            }
            this.ok = WebUtil.verifyAvailability(locations, true, (IProgressMonitor)new NullProgressMonitor());
            return this;
        }

        static /* synthetic */ String access$1(VerifyUpdateSiteJob verifyUpdateSiteJob) {
            return verifyUpdateSiteJob.url;
        }

        static /* synthetic */ boolean access$2(VerifyUpdateSiteJob verifyUpdateSiteJob) {
            return verifyUpdateSiteJob.ok;
        }
    }
}

