/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class StructConverterMetadata
extends AbstractConverterMetadata {
    private String m_converter;

    public StructConverterMetadata() {
        super("<struct-converter>");
    }

    public StructConverterMetadata(MetadataAnnotation structConverter, MetadataAccessor accessor) {
        super(structConverter, accessor);
        this.setConverter(structConverter.getAttributeString("converter"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof StructConverterMetadata) {
            StructConverterMetadata structConverter = (StructConverterMetadata)objectToCompare;
            return this.valuesMatch(this.m_converter, structConverter.getConverter());
        }
        return false;
    }

    public String getConverter() {
        return this.m_converter;
    }

    public String getConverterClassName() {
        if (this.getConverter().equals("JGEOMETRY")) {
            return "org.eclipse.persistence.platform.database.oracle.converters.JGeometryConverter";
        }
        return this.getConverter();
    }

    @Override
    public boolean isStructConverter() {
        return true;
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (mapping.isAbstractDirectMapping()) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)mapping;
            directMapping.setFieldType(2002);
            directMapping.setConverter(null);
            directMapping.setConverterClassName(null);
        } else if (!mapping.isDirectCollectionMapping() && !mapping.isDirectMapMapping()) {
            throw ValidationException.invalidMappingForStructConverter((String)this.getName(), (DatabaseMapping)mapping);
        }
    }

    public void setConverter(String converter) {
        this.m_converter = converter;
    }
}

