/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.CorruptedResourceExceptionInterceptorImpl;
import org.eclipse.sapphire.ui.ISapphireEditorActionContributor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.forms.FormEditorPageDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.swt.EditorPagePresentation;
import org.eclipse.sapphire.ui.forms.swt.FormEditorPage;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.forms.swt.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.internal.SapphirePropertySheetPage;
import org.eclipse.sapphire.ui.forms.swt.internal.text.SapphireFormText;
import org.eclipse.sapphire.ui.internal.PartServiceContext;
import org.eclipse.sapphire.ui.internal.SapphireActionManager;
import org.eclipse.sapphire.ui.internal.SapphireEditorContentOutline;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class SapphireEditor
extends FormEditor
implements ISapphirePart {
    @Text(value="Associated resources are not accessible")
    private static LocalizableText resourceNotAccessible;
    @Text(value="Editor {0} failed to instantiate its model")
    private static LocalizableText failedToCreateModel;
    @Text(value="Error")
    private static LocalizableText errorPageTitle;
    @Text(value="Failed to find a definition '{0}'")
    private static LocalizableText failedToFindDefinition;
    private static final String PREFS_LAST_ACTIVE_PAGE = "LastActivePage";
    private static final String PREFS_GLOBAL = "Global";
    private static final String PREFS_INSTANCE_BY_URI = "InstanceByUri";
    private static final String PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE = "InstanceByEditorInputType";
    private final String pluginId = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
    private Element model;
    private IResourceChangeListener fileChangeListener;
    private SwtResourceCache imageCache = new SwtResourceCache();
    private SapphireEditorContentOutline outline = null;
    private SapphireActionManager actionsManager = new SapphireActionManager(this, this.getActionContexts());
    private SapphirePropertySheetPage propertiesViewPage;
    private Listener propertiesViewContributionChangeListener;
    private PartServiceContext serviceContext;
    private boolean ignorePageChange;

    static {
        LocalizableText.init(SapphireEditor.class);
    }

    public Composite getContainer() {
        return super.getContainer();
    }

    @Override
    public PartDef definition() {
        return null;
    }

    @Override
    public final Element getModelElement() {
        if (this.model == null) {
            this.model = this.createModel();
            this.adaptModel(this.model);
        }
        return this.model;
    }

    @Override
    public final Element getLocalModelElement() {
        return this.getModelElement();
    }

    protected abstract Element createModel();

    protected void adaptModel(Element model) {
        CorruptedResourceExceptionInterceptorImpl interceptor = new CorruptedResourceExceptionInterceptorImpl(this.getEditorSite().getShell());
        this.model.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
    }

    public final Preferences getGlobalPreferences(boolean createIfNecessary) throws BackingStoreException {
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(PREFS_GLOBAL) || createIfNecessary)) {
            return prefs.node(PREFS_GLOBAL);
        }
        return null;
    }

    public final Preferences getInstancePreferences(boolean createIfNecessary) throws BackingStoreException {
        String level2;
        String level1;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IURIEditorInput) {
            level1 = PREFS_INSTANCE_BY_URI;
            URI uri = ((IURIEditorInput)editorInput).getURI();
            level2 = uri != null ? ((IURIEditorInput)editorInput).getURI().toString() : "$#%**invalid**%#$";
        } else {
            level1 = PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE;
            level2 = editorInput.getClass().getName();
        }
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(level1) || createIfNecessary) && ((prefs = prefs.node(level1)).nodeExists(level2) || createIfNecessary)) {
            return prefs.node(level2);
        }
        return null;
    }

    private final Preferences getPreferencesRoot(boolean createIfNecessary) throws BackingStoreException {
        String editorId;
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences prefs = scope.getNode(this.pluginId);
        if (prefs.nodeExists(editorId = this.getClass().getName()) || createIfNecessary) {
            return prefs.node(editorId);
        }
        return null;
    }

    private final int getLastActivePage() {
        int lastActivePage = 0;
        try {
            Preferences prefs = this.getInstancePreferences(false);
            if (prefs != null) {
                lastActivePage = prefs.getInt(PREFS_LAST_ACTIVE_PAGE, lastActivePage);
            }
        }
        catch (BackingStoreException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return lastActivePage;
    }

    private final void setLastActivePage(int index) {
        try {
            Preferences prefs = this.getInstancePreferences(true);
            if (prefs != null) {
                prefs.putInt(PREFS_LAST_ACTIVE_PAGE, index);
                prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public final IProject getProject() {
        IFile ifile = this.getFile();
        return ifile == null ? null : ifile.getProject();
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.doSetInput(input);
    }

    protected final void setInput(IEditorInput input) {
        this.doSetInput(input);
        super.setInput(input);
    }

    protected final void setInputWithNotify(IEditorInput input) {
        this.doSetInput(input);
        super.setInputWithNotify(input);
    }

    private void doSetInput(IEditorInput input) {
        this.setPartName(input.getName());
    }

    public int addEditorPage(IEditorPart page) throws PartInitException {
        return this.addPage(page, this.getEditorInput());
    }

    public void addEditorPage(int index, IEditorPart page) throws PartInitException {
        this.addPage(index, page, this.getEditorInput());
    }

    public int addPage(IEditorPart page, IEditorInput input) throws PartInitException {
        int index = super.addPage(page, input);
        this.setPageText(index, page.getTitle());
        return index;
    }

    public void addPage(int index, IEditorPart page, IEditorInput input) throws PartInitException {
        super.addPage(index, page, input);
        this.setPageText(index, page.getTitle());
    }

    protected final void addDeferredPage(int index, String pageName, String pageDefinitionId) {
        if (index < -1) {
            throw new IllegalArgumentException();
        }
        if (pageName == null) {
            throw new IllegalArgumentException();
        }
        DeferredPage page = new DeferredPage(this.getContainer(), pageDefinitionId);
        if (index == -1) {
            this.addPage((Control)page);
            this.setPageText(this.pages.size() - 1, pageName);
        } else {
            this.addPage(index, (Control)page);
            this.setPageText(index, pageName);
        }
    }

    protected final void addDeferredPage(String pageName, String pageDefinitionId) {
        this.addDeferredPage(-1, pageName, pageDefinitionId);
    }

    protected void createEditorPages() throws PartInitException {
        this.createSourcePages();
        this.createFormPages();
        this.createDiagramPages();
    }

    protected void createSourcePages() throws PartInitException {
    }

    protected void createFormPages() throws PartInitException {
    }

    protected void createDiagramPages() throws PartInitException {
    }

    protected final void addPages() {
        if (this.getEditorSite().getActionBarContributor() == null) {
            IActionBars actionBars = this.getEditorSite().getActionBars();
            EditorActionBars editorActionBars = (EditorActionBars)actionBars;
            SapphireEditorActionBarContributor actionBarContributor = new SapphireEditorActionBarContributor();
            actionBarContributor.init(actionBars, this.getSite().getPage());
            editorActionBars.setEditorContributor((IEditorActionBarContributor)actionBarContributor);
        }
        String error = null;
        IFile file = this.getFile();
        if (file != null && !file.isAccessible()) {
            error = resourceNotAccessible.text();
        }
        if (error == null) {
            try {
                this.createEditorPages();
            }
            catch (PartInitException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            this.createFileChangeListener();
            this.setActivePage(this.getLastActivePage());
        } else {
            Composite page = new Composite(this.getContainer(), 0);
            page.setLayout((Layout)GridLayoutUtil.glayout(1));
            page.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            SapphireFormText message = new SapphireFormText(page, 0);
            message.setLayoutData(GridLayoutUtil.gd());
            message.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            message.setText(error, false, false);
            this.addPage((Control)page);
            this.setPageText(0, errorPageTitle.text());
        }
    }

    protected DefinitionLoader getDefinitionLoader() {
        return DefinitionLoader.sdef(this.getClass());
    }

    protected DefinitionLoader.Reference<EditorPageDef> getDefinition(String pageDefinitionId) {
        return this.getDefinitionLoader().page(pageDefinitionId);
    }

    protected IEditorPart createPage(String pageDefinitionId) {
        IEditorPart page = null;
        DefinitionLoader.Reference<EditorPageDef> definition = this.getDefinition(pageDefinitionId);
        if (definition == null) {
            throw new IllegalArgumentException(failedToFindDefinition.format(new Object[]{pageDefinitionId}));
        }
        page = this.createPage(definition);
        return page;
    }

    protected IEditorPart createPage(DefinitionLoader.Reference<EditorPageDef> definition) {
        SapphireEditorFormPage page = null;
        EditorPageDef def = definition.resolve();
        if (def instanceof MasterDetailsEditorPageDef) {
            page = new MasterDetailsEditorPage(this, this.getModelElement(), definition);
        } else if (def instanceof FormEditorPageDef) {
            page = new FormEditorPage(this, this.getModelElement(), definition);
        } else if (def instanceof DiagramEditorPageDef) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.ui.swt.gef");
            if (bundle != null) {
                try {
                    Class cl = bundle.loadClass("org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor");
                    Constructor<?> constructor = cl.getConstructors()[0];
                    page = (IEditorPart)constructor.newInstance(this, this.getModelElement(), definition);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
        } else {
            throw new IllegalStateException();
        }
        return page;
    }

    public final Object getPage() {
        int pageIndex = this.getActivePage();
        if (pageIndex == -1) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    public final void showPage(Object page) {
        int index = this.pages.indexOf(page);
        this.setActivePage(index);
    }

    public final void showPage(SapphireEditorPagePart editorPagePart) {
        int i = 0;
        int n = this.getPageCount();
        while (i < n) {
            Object page = this.pages.get(i);
            if (page instanceof EditorPagePresentation && ((EditorPagePresentation)page).getPart() == editorPagePart) {
                this.setActivePage(i);
                return;
            }
            ++i;
        }
    }

    protected void pageChange(final int pageIndex) {
        if (this.ignorePageChange) {
            return;
        }
        final Object newPage = this.pages.get(pageIndex);
        if (newPage instanceof DeferredPage) {
            BusyIndicator.showWhile((Display)this.getContainer().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorPart page = SapphireEditor.this.createPage(((DeferredPage)((Object)newPage)).getDefinitionId());
                    if (page != null) {
                        try {
                            if (page instanceof IFormPage) {
                                SapphireEditor.this.addPage(pageIndex, (IFormPage)page);
                            } else {
                                SapphireEditor.this.addPage(pageIndex, page, SapphireEditor.this.getEditorInput());
                            }
                            int i = 0;
                            while (i < SapphireEditor.this.pages.size()) {
                                Object p = SapphireEditor.this.pages.get(i);
                                if (p == newPage) {
                                    SapphireEditor.this.ignorePageChange = true;
                                    SapphireEditor.this.removePage(i);
                                    SapphireEditor.this.ignorePageChange = false;
                                    break;
                                }
                                ++i;
                            }
                            SapphireEditor.this.setActivePage(pageIndex);
                        }
                        catch (PartInitException e) {
                            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                        }
                    }
                }
            });
        }
        super.pageChange(pageIndex);
        this.setLastActivePage(pageIndex);
        if (this.outline != null && !this.outline.isDisposed()) {
            this.outline.refresh();
        }
        this.refreshPropertiesViewContribution();
        Object page = this.pages.get(pageIndex);
        if (page instanceof SapphireEditorFormPage) {
            ((SapphireEditorFormPage)page).setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.model != null) {
            try {
                this.model.resource().save();
            }
            catch (ResourceStoreException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        for (Object page : this.pages) {
            if (!(page instanceof IEditorPart)) continue;
            ((IEditorPart)page).doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected final void createFileChangeListener() {
        this.fileChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                SapphireEditor.this.handleFileChangedEvent(event);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fileChangeListener, 1);
    }

    protected final void handleFileChangedEvent(IResourceChangeEvent event) {
        IResourceDelta localDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && this.getFile() != null && (localDelta = delta.findMember(this.getFile().getFullPath())) != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (localDelta.getKind() == 2) {
                        SapphireEditor.this.getSite().getPage().closeEditor((IEditorPart)SapphireEditor.this, false);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fileChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fileChangeListener);
            this.fileChangeListener = null;
        }
        this.imageCache.dispose();
        this.imageCache = null;
        this.actionsManager.dispose();
        this.actionsManager = null;
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
        if (this.serviceContext != null) {
            this.serviceContext.dispose();
            this.serviceContext = null;
        }
        this.outline = null;
        this.propertiesViewPage = null;
        this.propertiesViewContributionChangeListener = null;
    }

    @Override
    public final void close() {
        this.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outline == null || this.outline.isDisposed()) {
                this.outline = new SapphireEditorContentOutline(this);
            }
            return this.outline;
        }
        if (type == IPropertySheetPage.class) {
            if (this.propertiesViewPage == null) {
                this.propertiesViewPage = new SapphirePropertySheetPage();
                this.propertiesViewContributionChangeListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireEditorPagePart.PropertiesViewContributionChangedEvent) {
                            SapphireEditorPagePart.PropertiesViewContributionChangedEvent evt = (SapphireEditorPagePart.PropertiesViewContributionChangedEvent)event;
                            SapphireEditor.this.propertiesViewPage.setPart(evt.contribution());
                        }
                    }
                };
                this.refreshPropertiesViewContribution();
            }
            return this.propertiesViewPage;
        }
        return super.getAdapter(type);
    }

    public final List<SapphireEditorPagePart> getEditorPageParts() {
        ListFactory parts = ListFactory.start();
        for (Object page : this.pages) {
            if (!(page instanceof EditorPagePresentation)) continue;
            parts.add((Object)((EditorPagePresentation)page).getPart());
        }
        return parts.result();
    }

    public final SapphireEditorPagePart getEditorPagePart(String name) {
        for (Object page : this.pages) {
            if (!(page instanceof EditorPagePresentation) || !((String)((EditorPagePresentation)page).getPart().definition().getPageName().content()).equalsIgnoreCase(name)) continue;
            return ((EditorPagePresentation)page).getPart();
        }
        return null;
    }

    private void refreshPropertiesViewContribution() {
        if (this.propertiesViewPage != null) {
            for (SapphireEditorPagePart editorPagePart : this.getEditorPageParts()) {
                editorPagePart.detach(this.propertiesViewContributionChangeListener);
            }
            PropertiesViewContributionPart contribution = null;
            Object page = this.getPage();
            if (page instanceof EditorPagePresentation) {
                SapphireEditorPagePart editorPagePart = ((EditorPagePresentation)page).getPart();
                editorPagePart.attach(this.propertiesViewContributionChangeListener);
                contribution = editorPagePart.getPropertiesViewContribution();
            }
            this.propertiesViewPage.setPart(contribution);
        }
    }

    public final IContentOutlinePage getContentOutlineForActivePage() {
        int activePageIndex = this.getActivePage();
        Object page = this.pages.get(activePageIndex);
        return this.getContentOutline(page);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page instanceof MasterDetailsEditorPage) {
            MasterDetailsEditorPage mdpage = (MasterDetailsEditorPage)page;
            return mdpage.getContentOutlinePage();
        }
        if (page instanceof IEditorPart && ((IEditorPart)page).getAdapter(IContentOutlinePage.class) != null) {
            return (IContentOutlinePage)((IEditorPart)page).getAdapter(IContentOutlinePage.class);
        }
        return null;
    }

    @Override
    public ISapphirePart parent() {
        return null;
    }

    @Override
    public <T> T nearest(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.emptySet();
    }

    @Override
    public final String getMainActionContext() {
        return this.actionsManager.getMainActionContext();
    }

    @Override
    public final SapphireActionGroup getActions() {
        return this.actionsManager.getActions();
    }

    @Override
    public final SapphireActionGroup getActions(String context) {
        return this.actionsManager.getActions(context);
    }

    @Override
    public final SapphireAction getAction(String id) {
        return this.actionsManager.getAction(id);
    }

    @Override
    public Status validation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContext getDocumentationContext() {
        return null;
    }

    @Override
    public SwtResourceCache getSwtResourceCache() {
        return this.imageCache;
    }

    public void collectAllReferencedProperties(Set<PropertyDef> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A result = null;
        if (adapterType == IEditorPart.class) {
            result = adapterType.cast(this.getActiveEditor());
        }
        if (result == null && adapterType == IEditorSite.class) {
            result = adapterType.cast(this.getEditorSite());
        }
        if (result == null) {
            result = adapterType.cast(this.getAdapter(adapterType));
        }
        if (result == null && this.parent() != null) {
            result = this.parent().adapt(adapterType);
        }
        return result;
    }

    @Override
    public final <S extends Service> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    @Override
    public final <S extends Service> List<S> services(Class<S> serviceType) {
        if (this.serviceContext == null) {
            this.serviceContext = new PartServiceContext(this);
        }
        return this.serviceContext.services(serviceType);
    }

    private static final class DeferredPage
    extends Composite {
        private final String definitionId;

        public DeferredPage(Composite parent, String definitionId) {
            super(parent, 0);
            this.definitionId = definitionId;
        }

        public String getDefinitionId() {
            return this.definitionId;
        }
    }

    private static class SapphireEditorActionBarContributor
    extends MultiPageEditorActionBarContributor {
        private MultiPageEditorPart multiPageEditor = null;

        private SapphireEditorActionBarContributor() {
        }

        public void setActiveEditor(IEditorPart targetEditor) {
            if (targetEditor instanceof MultiPageEditorPart) {
                this.multiPageEditor = (MultiPageEditorPart)targetEditor;
            }
            super.setActiveEditor(targetEditor);
        }

        public void setActivePage(IEditorPart activeEditor) {
            IActionBars actionBars;
            ISapphireEditorActionContributor actionContributor = null;
            ITextEditor textEditor = null;
            if (this.multiPageEditor != null) {
                Object obj;
                if (activeEditor instanceof ISapphireEditorActionContributor) {
                    actionContributor = (ISapphireEditorActionContributor)activeEditor;
                } else if (activeEditor instanceof ITextEditor) {
                    textEditor = (ITextEditor)activeEditor;
                } else if (activeEditor == null && (obj = this.multiPageEditor.getSelectedPage()) instanceof ISapphireEditorActionContributor) {
                    actionContributor = (ISapphireEditorActionContributor)obj;
                }
            }
            if ((actionBars = this.getActionBars()) != null && (actionContributor != null || textEditor != null)) {
                if (actionContributor != null) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), actionContributor.getAction(ActionFactory.DELETE.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), actionContributor.getAction(ActionFactory.SELECT_ALL.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), actionContributor.getAction(ActionFactory.PRINT.getId()));
                } else if (textEditor != null) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), textEditor.getAction(ActionFactory.DELETE.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), textEditor.getAction(ActionFactory.SELECT_ALL.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), textEditor.getAction(ActionFactory.PRINT.getId()));
                }
                actionBars.updateActionBars();
            }
        }
    }
}

