/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceEvent;
import org.eclipse.sapphire.util.EqualsFactory;
import org.eclipse.sapphire.util.HashCodeFactory;

public final class TextSelectionService
extends Service {
    private Range selection = new Range(0, 0);

    public Range selection() {
        return this.selection;
    }

    public void select(int position) {
        this.select(position, position);
    }

    public void select(int start, int end) {
        this.select(new Range(start, end));
    }

    public void select(Range range) {
        if (range == null) {
            throw new IllegalArgumentException();
        }
        if (!this.selection.equals(range)) {
            Range before = this.selection;
            this.selection = range;
            this.broadcast((Event)new TextSelectionEvent(this, before, this.selection));
        }
    }

    public static final class Range {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            if (start < 0) {
                throw new IllegalArgumentException();
            }
            if (end < start) {
                throw new IllegalArgumentException();
            }
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Range) {
                Range range = (Range)obj;
                return EqualsFactory.start().add(this.start, range.start).add(this.end, range.end).result();
            }
            return false;
        }

        public int hashCode() {
            return HashCodeFactory.start().add(this.start).add(this.end).result();
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int length() {
            return this.end - this.start;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + ")";
        }
    }

    public static final class TextSelectionEvent
    extends ServiceEvent {
        private Range before;
        private Range after;

        TextSelectionEvent(TextSelectionService service, Range before, Range after) {
            super((Service)service);
            this.before = before;
            this.after = after;
        }

        public Range before() {
            return this.before;
        }

        public Range after() {
            return this.after;
        }
    }
}

