/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class HighlightNodeCommand
extends RecordingCommand {
    private final CamelDesignEditor designEditor;
    private AbstractCamelModelElement node;
    private boolean highlight;

    public HighlightNodeCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, AbstractCamelModelElement node, boolean highlight) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.node = node;
        this.highlight = highlight;
    }

    protected void doExecute() {
        PictogramElement pe;
        if (this.node == null) {
            return;
        }
        if (this.designEditor.getParent().getActivePage() == 1) {
            this.designEditor.getParent().switchToDesignEditor();
        }
        if (this.highlight && this.isDifferentRouteCurrentlySelected()) {
            this.designEditor.setSelectedContainer((AbstractCamelModelElement)this.node.getRoute());
        }
        if ((pe = this.designEditor.getFeatureProvider().getPictogramElementForBusinessObject((Object)this.node)) == null) {
            CamelEditorUIActivator.pluginLog().logWarning("Warning could not find PictogramElement for highlight node: " + this.node);
            return;
        }
        IGaService gaService = Graphiti.getGaService();
        try {
            if (pe instanceof ContainerShape) {
                this.updateShapeStyle(gaService, (ContainerShape)pe);
                this.updateTextStyle(pe, gaService);
            }
        }
        catch (Exception e) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)e);
        }
    }

    protected void updateTextStyle(PictogramElement pe, IGaService gaService) {
        for (GraphicsAlgorithm ga : pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
            if (!(ga instanceof Text)) continue;
            Text text = (Text)ga;
            if (this.highlight) {
                text.setForeground(gaService.manageColor(this.designEditor.getDiagramTypeProvider().getDiagram(), StyleUtil.HIGHLIGHT_COLOR));
                continue;
            }
            text.setForeground(gaService.manageColor(this.designEditor.getDiagramTypeProvider().getDiagram(), StyleUtil.E_CLASS_TEXT_FOREGROUND));
        }
    }

    protected void updateShapeStyle(IGaService gaService, ContainerShape cs) {
        if (this.highlight) {
            if (this.node.getUnderlyingMetaModelObject().canHaveChildren()) {
                cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(3));
                cs.getGraphicsAlgorithm().setForeground(gaService.manageColor(this.designEditor.getDiagramTypeProvider().getDiagram(), StyleUtil.HIGHLIGHT_COLOR));
            } else {
                cs.getGraphicsAlgorithm().setForeground(gaService.manageColor(this.designEditor.getDiagramTypeProvider().getDiagram(), StyleUtil.HIGHLIGHT_COLOR));
                cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(3));
                cs.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(true));
            }
        } else if (this.node.getUnderlyingMetaModelObject().canHaveChildren()) {
            cs.getGraphicsAlgorithm().setForeground(gaService.manageColor(this.designEditor.getDiagramTypeProvider().getDiagram(), StyleUtil.CONTAINER_FIGURE_BORDER_COLOR));
            cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(1));
        } else {
            cs.getGraphicsAlgorithm().setForeground(cs.getGraphicsAlgorithm().getBackground());
            cs.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(false));
            cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(1));
        }
    }

    protected boolean isDifferentRouteCurrentlySelected() {
        return this.node.getRoute() != null && this.designEditor.getSelectedContainer() != this.node.getRouteContainer() && this.node.getRoute() != this.designEditor.getSelectedContainer();
    }
}

