/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.features.custom.CollapseFeature;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;

public class UpdateCommand
extends RecordingCommand {
    private final CamelDesignEditor designEditor;
    private AbstractCamelModelElement node;

    public UpdateCommand(CamelDesignEditor designEditor, TransactionalEditingDomain editingDomain, AbstractCamelModelElement node) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.node = node;
    }

    protected void doExecute() {
        AbstractCamelModelElement selectedNode;
        AbstractCamelModelElement abstractCamelModelElement = selectedNode = this.node == null ? this.designEditor.getSelectedNode() : this.node;
        if (selectedNode == null) {
            selectedNode = this.designEditor.getModel().getRouteContainer();
        }
        this.updateFigure(selectedNode);
    }

    private void updateFigure(AbstractCamelModelElement node) {
        PictogramElement pe;
        if (node == null) {
            return;
        }
        IFeatureProvider featureProvider = this.designEditor.getFeatureProvider();
        Object object = pe = node instanceof CamelContextElement ? this.designEditor.getDiagramTypeProvider().getDiagram() : featureProvider.getPictogramElementForBusinessObject((Object)node);
        if (pe == null) {
            return;
        }
        AbstractCamelModelElement bo2 = this.designEditor.getModel().findNode(node.getId());
        if (bo2 != null && !bo2.getXmlNode().isEqualNode(node.getXmlNode())) {
            featureProvider.link(pe, (Object)bo2);
        }
        if (CollapseFeature.isCollapsed(pe)) {
            return;
        }
        UpdateContext ctx = new UpdateContext(pe);
        IUpdateFeature updateFeature = featureProvider.getUpdateFeature((IUpdateContext)ctx);
        if (updateFeature != null) {
            updateFeature.update((IUpdateContext)ctx);
        }
        for (AbstractCamelModelElement elem : node.getChildElements()) {
            this.updateFigure(elem);
        }
    }
}

