/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.delete;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;

public class DeleteFigureFeature
extends DefaultDeleteFeature {
    public static final String SKIP_ASKING_DELETE_CONFIRMATION = "SKIP_ASKING_DELETE_CONFIRMATION";
    private AbstractCamelModelElement inputOfDeletedElement = null;
    private AbstractCamelModelElement outputOfDeletedElement = null;

    public DeleteFigureFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected void deleteBusinessObject(Object bo) {
        super.deleteBusinessObject(bo);
        if (bo != null) {
            if (bo instanceof CamelElementConnection) {
                NodeUtils.deleteFlowFromModel((CamelElementConnection)bo);
            } else if (bo instanceof AbstractCamelModelElement) {
                NodeUtils.deleteBOFromModel(this.getFeatureProvider(), (AbstractCamelModelElement)bo);
            } else {
                CamelEditorUIActivator.pluginLog().logWarning("Cannot figure out Node or Flow from BO: " + bo);
            }
        }
    }

    public void preDelete(IDeleteContext context) {
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof AbstractCamelModelElement) {
            this.inputOfDeletedElement = ((AbstractCamelModelElement)bo).getInputElement();
            this.outputOfDeletedElement = ((AbstractCamelModelElement)bo).getOutputElement();
        }
        super.preDelete(context);
    }

    public void postDelete(IDeleteContext context) {
        if (this.inputOfDeletedElement != null && this.outputOfDeletedElement != null) {
            NodeUtils.reconnectNodes(this.getFeatureProvider(), this.inputOfDeletedElement, this.outputOfDeletedElement);
        }
        super.postDelete(context);
        DiagramOperations.layoutDiagram(CamelUtils.getDiagramEditor(), true);
    }

    protected boolean getUserDecision(IDeleteContext context) {
        Object shouldSkipAskingDeleteConfirmation = context.getProperty((Object)SKIP_ASKING_DELETE_CONFIRMATION);
        if ("true".equals(shouldSkipAskingDeleteConfirmation)) {
            return true;
        }
        return super.getUserDecision(context);
    }
}

