/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.PropertyInputDialog;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.PropertyStyleBaseTableControl;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyStyleChildTableControl
extends PropertyStyleBaseTableControl {
    private AbstractCamelModelElement inputElement;
    private List<AbstractCamelModelElement> propertyList = new ArrayList<AbstractCamelModelElement>();

    public PropertyStyleChildTableControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public PropertyStyleChildTableControl(Composite parent, int style, boolean isReadOnly) {
        super(parent, style, isReadOnly);
        this.propertyTreeTable.setInput(this.propertyList);
        this.updatePropertyTypeButtons();
    }

    @Override
    protected void removePropertyFromList() {
        if (!this.getStructuredSelection().isEmpty()) {
            AbstractCamelModelElement selectedProperty = (AbstractCamelModelElement)this.getStructuredSelection().getFirstElement();
            this.propertyList.remove(selectedProperty);
        }
    }

    @Override
    protected void addPropertyTypeToList() {
        PropertyInputDialog dialog = new PropertyInputDialog(Display.getCurrent().getActiveShell());
        dialog.setPropertyList(this.propertyList);
        int rtnValue = dialog.open();
        if (rtnValue == 0) {
            String name = dialog.getPropertyName();
            String value = dialog.getPropertyValue();
            this.addBeanProperty(name, value);
        }
    }

    @Override
    protected void editPropertyType() {
        if (!this.getStructuredSelection().isEmpty()) {
            AbstractCamelModelElement selectedProperty = (AbstractCamelModelElement)this.getStructuredSelection().getFirstElement();
            PropertyInputDialog dialog = new PropertyInputDialog(Display.getCurrent().getActiveShell());
            dialog.setIsEditDialog(true);
            Element xmlElement = (Element)selectedProperty.getXmlNode();
            if (xmlElement.getAttribute("name") != null) {
                dialog.setPropertyName(xmlElement.getAttribute("name"));
            }
            if (xmlElement.getAttribute("value") != null) {
                dialog.setPropertyValue(xmlElement.getAttribute("value"));
            }
            dialog.setPropertyList(this.propertyList);
            int rtnValue = dialog.open();
            if (rtnValue == 0) {
                String name = dialog.getPropertyName();
                String value = dialog.getPropertyValue();
                this.beanConfigUtil.editBeanProperty(xmlElement, name, value);
            }
        }
    }

    public void setInput(AbstractCamelModelElement input) {
        this.inputElement = input;
    }

    @Override
    protected void addBeanProperty(String name, String value) {
        Element propertyNode = this.beanConfigUtil.createBeanProperty(this.inputElement.getCamelFile(), name, value);
        CamelBasicModelElement newProperty = new CamelBasicModelElement(null, (Node)propertyNode);
        this.propertyList.add((AbstractCamelModelElement)newProperty);
    }

    public List<AbstractCamelModelElement> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<AbstractCamelModelElement> list) {
        this.propertyList = list;
    }

    @Override
    protected ITableLabelProvider getTableLabelProvider() {
        return new PropertyTypeTreeLabelProvider();
    }

    @Override
    protected ITreeContentProvider getTableContentProvider() {
        return new PropertyTypeTreeContentProvider();
    }

    private class PropertyTypeTreeContentProvider
    implements ITreeContentProvider {
        private List<AbstractCamelModelElement> properties;

        private PropertyTypeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.properties = (List)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return this.properties.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractCamelModelElement) {
                AbstractCamelModelElement parent = (AbstractCamelModelElement)parentElement;
                return new Object[]{parent.getChildElements()};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractCamelModelElement) {
                return ((AbstractCamelModelElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return !((List)element).isEmpty();
            }
            return false;
        }
    }

    private class PropertyTypeTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return element instanceof AbstractCamelModelElement && (property.equalsIgnoreCase("name") || property.equalsIgnoreCase("value"));
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AbstractCamelModelElement && columnIndex == 0) {
                Element xmlElement = (Element)((AbstractCamelModelElement)element).getXmlNode();
                return xmlElement.getAttribute("name");
            }
            if (element instanceof AbstractCamelModelElement && columnIndex == 1) {
                Element xmlElement = (Element)((AbstractCamelModelElement)element).getXmlNode();
                return xmlElement.getAttribute("value");
            }
            return null;
        }
    }
}

