/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.BeanClassExistsValidator;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.BeanRefClassExistsValidator;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.NewBeanIdValidator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.properties.BeanRefAndClassCrossValidator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBean;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;

public abstract class GlobalBeanBaseWizardPage
extends WizardPage {
    protected DataBindingContext dbc;
    protected String id;
    protected String classname;
    protected String beanRefId;
    protected AbstractCamelModelElement element;
    protected IObservableValue<String> classObservable;
    protected BeanConfigUtil beanConfigUtil = new BeanConfigUtil();
    protected IProject project = null;
    protected Text classText;
    protected Text idText;
    protected Combo beanRefIdCombo;
    private Binding refBinding;
    private Binding classBinding;
    private BeanRefClassExistsValidator refValidator;
    private BeanClassExistsValidator classValidator;
    protected ISWTObservableValue refUiObservable = null;
    protected ISWTObservableValue classUiObservable = null;
    protected Button browseBeanButton;
    protected Button newBeanButton;

    public GlobalBeanBaseWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.createIdLine(composite);
        this.createClassLine(composite);
        this.createBrowseButton(composite);
        this.createClassNewButton(composite);
        this.createBeanRefIdLine(composite);
        this.refValidator.setControl(this.classText);
        this.classValidator.setControl(this.beanRefIdCombo);
        Group argsPropsGroup = new Group(composite, 0);
        argsPropsGroup.setText(UIMessages.globalBeanWizardPageArgumentsGroupLabel);
        argsPropsGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        argsPropsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(4, 1).create());
        this.createArgumentsControls((Composite)argsPropsGroup, 4);
        Group beanPropsGroup = new Group(composite, 0);
        beanPropsGroup.setText(UIMessages.globalBeanWizardPagePropertiesGroupLabel);
        beanPropsGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        beanPropsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(4, 1).create());
        this.createPropsControls((Composite)beanPropsGroup, 4);
        BeanRefAndClassCrossValidator beanRefAndClassCrossValidator = new BeanRefAndClassCrossValidator(this.classUiObservable, this.refUiObservable);
        ControlDecorationSupport.create((ValidationStatusProvider)beanRefAndClassCrossValidator, (int)16512);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)beanRefAndClassCrossValidator);
        this.setControl((Control)composite);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
    }

    protected abstract void createArgumentsControls(Composite var1, int var2);

    protected abstract void createPropsControls(Composite var1, int var2);

    protected abstract Binding createBeanRefBinding(UpdateValueStrategy var1);

    protected abstract Binding createClassBinding(UpdateValueStrategy var1);

    protected abstract Binding createIdBinding(UpdateValueStrategy var1);

    protected void createIdLine(Composite composite) {
        Label idLabel = new Label(composite, 0);
        idLabel.setText(UIMessages.globalEndpointWizardPageIdFieldLabel);
        this.idText = new Text(composite, 2048);
        this.idText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).span(3, 1).create());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)new NewBeanIdValidator(this.element));
        this.createIdBinding(strategy);
    }

    protected void createClassLine(Composite composite) {
        Label classLabel = new Label(composite, 0);
        classLabel.setText(UIMessages.globalBeanWizardPageClassLabel);
        this.classText = new Text(composite, 2048);
        this.classText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).create());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        this.classValidator = new BeanClassExistsValidator(this.project, this.element, this.beanRefIdCombo);
        strategy.setBeforeSetValidator((IValidator)this.classValidator);
        this.classBinding = this.createClassBinding(strategy);
        this.classText.addModifyListener(value -> this.pingBindings());
    }

    private void createBrowseButton(Composite composite) {
        this.browseBeanButton = new Button(composite, 8);
        this.browseBeanButton.setText("...");
        this.browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String value = GlobalBeanBaseWizardPage.this.beanConfigUtil.handleClassBrowse(GlobalBeanBaseWizardPage.this.project, GlobalBeanBaseWizardPage.this.getShell());
                if (value != null) {
                    GlobalBeanBaseWizardPage.this.classObservable.setValue((Object)value);
                    GlobalBeanBaseWizardPage.this.classText.setText(value);
                }
            }
        });
    }

    private void createClassNewButton(Composite composite) {
        this.newBeanButton = new Button(composite, 8);
        this.newBeanButton.setText("+");
        this.newBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String initialClassName = GlobalBeanBaseWizardPage.this.classText.getText();
                String value = GlobalBeanBaseWizardPage.this.beanConfigUtil.handleNewClassWizard(GlobalBeanBaseWizardPage.this.project, GlobalBeanBaseWizardPage.this.getShell(), initialClassName);
                if (value != null) {
                    GlobalBeanBaseWizardPage.this.classObservable.setValue((Object)value);
                    GlobalBeanBaseWizardPage.this.classText.setText(value);
                }
            }
        });
    }

    protected String getEditedBeanId() {
        if (this.element instanceof CamelBean) {
            return ((CamelBean)this.element).getId();
        }
        return null;
    }

    protected void createBeanRefIdLine(Composite composite) {
        Label beanRefIdLabel = new Label(composite, 0);
        beanRefIdLabel.setText(UIMessages.globalBeanBaseWizardPageFactoryBeanLabel);
        this.beanRefIdCombo = new Combo(composite, 2060);
        this.beanRefIdCombo.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).span(3, 1).create());
        if (this.element != null) {
            String[] beanRefs = CamelComponentUtils.getRefs((CamelFile)this.element.getCamelFile());
            String[] updatedBeanRefs = this.beanConfigUtil.removeRefsWithNoClassFromArray(beanRefs, this.element);
            String beanId = this.getEditedBeanId();
            if (beanId != null) {
                String[] updatedBeanRefsNoId = this.beanConfigUtil.removeStringFromStringArray(updatedBeanRefs, beanId);
                this.beanRefIdCombo.setItems(updatedBeanRefsNoId);
            } else {
                this.beanRefIdCombo.setItems(updatedBeanRefs);
            }
        }
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        this.refValidator = new BeanRefClassExistsValidator(this.project, this.element, this.classText);
        strategy.setBeforeSetValidator((IValidator)this.refValidator);
        this.beanRefIdCombo.addModifyListener(value -> this.pingBindings());
        this.beanRefIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalBeanBaseWizardPage.this.pingBindings();
            }
        });
        this.refBinding = this.createBeanRefBinding(strategy);
    }

    private void pingBindings() {
        Display.getCurrent().asyncExec(() -> {
            if (this.classBinding != null) {
                this.classValidator.setControl(this.beanRefIdCombo);
                if (!this.classText.isDisposed()) {
                    this.classBinding.validateTargetToModel();
                }
            }
            if (this.refBinding != null) {
                this.refValidator.setControl(this.classText);
                if (!this.beanRefIdCombo.isDisposed()) {
                    this.refBinding.validateTargetToModel();
                }
            }
        });
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBeanRefId() {
        return this.beanRefId;
    }

    public void setBeanRefId(String beanRefId) {
        this.beanRefId = beanRefId;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    protected void setClassUiObservable(ISWTObservableValue uiObservable) {
        this.classUiObservable = uiObservable;
    }

    protected void setRefUiObservable(ISWTObservableValue uiObservable) {
        this.refUiObservable = uiObservable;
    }
}

