/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.BeanClassExistsValidator;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.BeanRefClassExistsValidator;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.properties.BeanRefAndClassCrossValidator;
import org.fusesource.ide.camel.editor.properties.FusePropertySection;
import org.fusesource.ide.camel.editor.properties.bean.AttributeTextFieldPropertyUICreatorWithBrowse;
import org.fusesource.ide.camel.editor.properties.bean.BeanRefAttributeComboFieldPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.bean.NewBeanIdPropertyValidator;
import org.fusesource.ide.camel.editor.properties.bean.PropertyMethodValidator;
import org.fusesource.ide.camel.editor.properties.bean.PropertyRequiredValidator;
import org.fusesource.ide.camel.editor.properties.bean.ScopeAttributeComboFieldPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.AbstractParameterPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.AbstractTextFieldParameterPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.TextParameterPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.advanced.UnsupportedParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.modifylisteners.text.ComboParameterPropertyModifyListener;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public class AdvancedBeanPropertiesSection
extends FusePropertySection {
    private static final int PUBLIC_AND_STATIC_METHOD_BROWSE = 1;
    private static final int PUBLIC_NO_ARG_METHOD_BROWSE = 2;
    private static final int PUBLIC_OR_STATIC_METHOD_BROWSE = 3;
    private BeanConfigUtil beanConfigUtil = new BeanConfigUtil();
    private Map<String, Parameter> parameterList;
    private Map<String, IObservableValue<?>> modelValueMap = new HashMap();
    private Map<String, IObservableValue<?>> targetValueMap = new HashMap();
    private String factoryBeanTag;
    private AbstractParameterPropertyUICreator classCreator;
    private AbstractParameterPropertyUICreator beanRefCreator;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        this.createStandardTabLayout(UIMessages.advancedBeanPropertiesSectionTitle);
    }

    private void createParameterList() {
        this.parameterList = new HashMap<String, Parameter>();
        Parameter idParam = this.beanConfigUtil.createParameter("id", String.class.getName());
        idParam.setRequired("true");
        this.parameterList.put("id", idParam);
        Parameter classParam = this.beanConfigUtil.createParameter("class", String.class.getName());
        this.parameterList.put("class", classParam);
        this.parameterList.put("scope", this.beanConfigUtil.createParameter("scope", String.class.getName()));
        this.parameterList.put("depends-on", this.beanConfigUtil.createParameter("depends-on", String.class.getName()));
        this.parameterList.put("init-method", this.beanConfigUtil.createParameter("init-method", String.class.getName()));
        this.parameterList.put("destroy-method", this.beanConfigUtil.createParameter("destroy-method", String.class.getName()));
        this.factoryBeanTag = this.beanConfigUtil.getFactoryBeanTag(this.selectedEP.getXmlNode());
        Parameter factoryBeanParameter = this.beanConfigUtil.createParameter(this.factoryBeanTag, String.class.getName());
        this.parameterList.put(this.factoryBeanTag, factoryBeanParameter);
        String factoryAttribute = this.beanConfigUtil.getFactoryMethodAttribute();
        this.parameterList.put(factoryAttribute, this.beanConfigUtil.createParameter(factoryAttribute, String.class.getName()));
    }

    @Override
    protected void createContentTabs(CTabFolder folder) {
        this.createParameterList();
        CTabItem contentTab = new CTabItem(this.tabFolder, 0);
        contentTab.setText(Strings.humanize((String)"Common"));
        Composite page = this.toolkit.createComposite((Composite)folder);
        page.setLayout((Layout)new GridLayout(4, false));
        this.generateTabContents(this.parameterList, page);
        contentTab.setControl((Control)page);
        this.tabs.add(contentTab);
    }

    private AbstractParameterPropertyUICreator handleField(Parameter p, Composite page) {
        this.createPropertyLabel(this.toolkit, page, p);
        AbstractParameterPropertyUICreator creator = this.createPropertyFieldEditor(page, p);
        if (creator != null) {
            IObservableValue modelValue = (IObservableValue)creator.getBinding().getModel();
            ISWTObservableValue targetValue = creator.getUiObservable();
            this.modelValueMap.put(p.getName(), modelValue);
            this.targetValueMap.put(p.getName(), (IObservableValue<?>)targetValue);
            return creator;
        }
        throw new NullPointerException();
    }

    protected void generateTabContents(Map<String, Parameter> props, Composite page) {
        this.handleField(props.get("id"), page);
        props.remove("id");
        Group classOrBeanGroup = new Group(page, 0);
        classOrBeanGroup.setText("Bean Class or Global Bean Reference");
        classOrBeanGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        classOrBeanGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).grab(true, false).create());
        this.toolkit.adapt((Composite)classOrBeanGroup);
        final Button optClass = this.toolkit.createButton((Composite)classOrBeanGroup, "Bean Class", 16);
        optClass.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).span(4, 1).grab(true, false).create());
        Parameter classParm = props.get("class");
        this.classCreator = this.handleField(classParm, (Composite)classOrBeanGroup);
        props.remove("class");
        Button optBeanRef = this.toolkit.createButton((Composite)classOrBeanGroup, "Bean Reference", 16);
        optBeanRef.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).span(4, 1).grab(true, false).create());
        Parameter beanRefParm = props.get(this.factoryBeanTag);
        try {
            this.beanRefCreator = this.handleField(beanRefParm, (Composite)classOrBeanGroup);
            props.remove(this.factoryBeanTag);
            IObservableValue<?> classNameObservable = this.modelValueMap.get("class");
            classNameObservable.addChangeListener(event -> this.refreshClassAndBeanRefBindings());
            IObservableValue beanRefObservable = (IObservableValue)this.beanRefCreator.getBinding().getModel();
            beanRefObservable.addChangeListener(event -> this.refreshClassAndBeanRefBindings());
            optBeanRef.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedBeanPropertiesSection.this.updateOptionButtons(e, optClass, AdvancedBeanPropertiesSection.this.beanRefCreator, AdvancedBeanPropertiesSection.this.classCreator);
                }
            });
            optClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedBeanPropertiesSection.this.updateOptionButtons(e, optClass, AdvancedBeanPropertiesSection.this.beanRefCreator, AdvancedBeanPropertiesSection.this.classCreator);
                }
            });
            if (!Strings.isEmpty((String)((String)beanRefObservable.getValue()))) {
                optBeanRef.setSelection(true);
                optBeanRef.notifyListeners(13, new Event());
            } else {
                optClass.setSelection(true);
                optClass.notifyListeners(13, new Event());
            }
        }
        catch (NullPointerException npe) {
            CamelEditorUIActivator.pluginLog().logError("Error encountered while generating bean text and reference controls.", (Throwable)npe);
        }
        for (Parameter p : props.values()) {
            this.handleField(p, page);
        }
        BeanRefAndClassCrossValidator beanRefAndClassCrossValidator = new BeanRefAndClassCrossValidator(this.classCreator.getUiObservable(), this.beanRefCreator.getUiObservable());
        ControlDecorationSupport.create((ValidationStatusProvider)beanRefAndClassCrossValidator, (int)16512);
    }

    private void updateOptionButtons(SelectionEvent e, Button optClass, AbstractParameterPropertyUICreator beanRefCreator, AbstractParameterPropertyUICreator classCreator) {
        boolean classCreatorEnablement;
        Button selectedOption = (Button)e.widget;
        boolean isSelected = selectedOption.getSelection();
        boolean isClassBtn = selectedOption.equals(optClass);
        boolean beanRefCreatorEnablement = !isClassBtn && isSelected;
        boolean bl = classCreatorEnablement = isClassBtn && isSelected;
        if (beanRefCreatorEnablement) {
            Text textControl = (Text)classCreator.getControl();
            textControl.setText("");
        } else if (classCreatorEnablement) {
            Combo comboControl = (Combo)beanRefCreator.getControl();
            comboControl.deselectAll();
        }
        beanRefCreator.getControl().setEnabled(beanRefCreatorEnablement);
        classCreator.getControl().setEnabled(classCreatorEnablement);
    }

    private void refreshClassAndBeanRefBindings() {
        this.dbc.updateTargets();
    }

    private AbstractParameterPropertyUICreator createPropertyFieldEditor(Composite page, Parameter p) {
        String propName = p.getName();
        if ("class".equals(propName)) {
            return this.createTextFieldWithClassBrowseAndNew(p, page);
        }
        if ("init-method".equals(propName) || "destroy-method".equals(propName)) {
            return this.createTextFieldWithNoArgMethodBrowse(p, page);
        }
        if ("factory-method".equals(propName)) {
            return this.createTextFieldWithPublicOrStaticMethodBrowse(p, page);
        }
        if ("id".equals(propName)) {
            return this.createIDTextField(p, page);
        }
        if ("scope".equals(propName)) {
            return this.createScopeCombo(p, page);
        }
        if ("factory-bean".equals(propName) || "factory-ref".equals(propName)) {
            return this.createRefCombo(p, page);
        }
        if (CamelComponentUtils.isTextProperty((Parameter)p) || CamelComponentUtils.isCharProperty((Parameter)p)) {
            return this.createTextField(p, page);
        }
        if (CamelComponentUtils.isUnsupportedProperty((Parameter)p)) {
            UnsupportedParameterPropertyUICreatorForAdvanced creator = new UnsupportedParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory());
            creator.create();
            return creator;
        }
        return null;
    }

    private IValidator getValidatorForField(Parameter p) {
        Object validator = null;
        IProject project = this.selectedEP.getCamelFile().getResource().getProject();
        String propName = p.getName();
        if ("class".equals(propName)) {
            validator = new BeanClassExistsValidator(project, this.selectedEP, this.modelMap);
        } else if ("init-method".equals(propName) || "destroy-method".equals(propName) || "factory-method".equals(propName)) {
            validator = new PropertyMethodValidator(this.modelMap, project, this.selectedEP);
        } else if ("factory-bean".equals(propName) || "factory-ref".equals(propName) || this.factoryBeanTag.equals(propName)) {
            validator = new BeanRefClassExistsValidator(project, this.selectedEP, this.modelMap);
        } else if ("id".equals(propName)) {
            validator = new NewBeanIdPropertyValidator(p, this.selectedEP);
        }
        if (validator == null && p.getRequired() != null && "true".contentEquals(p.getRequired())) {
            validator = new PropertyRequiredValidator(p);
        }
        return validator;
    }

    private AbstractTextFieldParameterPropertyUICreator createTextFieldWithClassBrowseAndNew(Parameter p, Composite page) {
        AttributeTextFieldPropertyUICreatorWithBrowse txtFieldCreator = new AttributeTextFieldPropertyUICreatorWithBrowse(this.dbc, (IObservableMap<String, String>)this.modelMap, this.eip, this.selectedEP, p, this.getValidatorForField(p), page, this.getWidgetFactory());
        txtFieldCreator.setColumnSpan(1);
        txtFieldCreator.create();
        this.createClassBrowseButton(page, txtFieldCreator.getControl());
        this.createClassNewButton(page, txtFieldCreator.getControl());
        return txtFieldCreator;
    }

    private AbstractTextFieldParameterPropertyUICreator createTextFieldWithPublicOrStaticMethodBrowse(Parameter p, Composite page) {
        AttributeTextFieldPropertyUICreatorWithBrowse txtFieldCreator = new AttributeTextFieldPropertyUICreatorWithBrowse(this.dbc, (IObservableMap<String, String>)this.modelMap, this.eip, this.selectedEP, p, this.getValidatorForField(p), page, this.getWidgetFactory());
        txtFieldCreator.setColumnSpan(2);
        txtFieldCreator.create();
        this.createPublicOrStaticMethodBrowseButton(page, txtFieldCreator.getControl());
        return txtFieldCreator;
    }

    private AbstractTextFieldParameterPropertyUICreator createTextFieldWithNoArgMethodBrowse(Parameter p, Composite page) {
        AttributeTextFieldPropertyUICreatorWithBrowse txtFieldCreator = new AttributeTextFieldPropertyUICreatorWithBrowse(this.dbc, (IObservableMap<String, String>)this.modelMap, this.eip, this.selectedEP, p, this.getValidatorForField(p), page, this.getWidgetFactory());
        txtFieldCreator.setColumnSpan(2);
        txtFieldCreator.create();
        this.createNoArgMethodBrowseButton(page, txtFieldCreator.getControl());
        return txtFieldCreator;
    }

    private AbstractTextFieldParameterPropertyUICreator createIDTextField(Parameter p, Composite page) {
        TextParameterPropertyUICreator txtFieldCreator = new TextParameterPropertyUICreator(this.dbc, this.modelMap, this.eip, this.selectedEP, p, this.getValidatorForField(p), page, this.getWidgetFactory());
        txtFieldCreator.create();
        return txtFieldCreator;
    }

    private AbstractTextFieldParameterPropertyUICreator createTextField(Parameter p, Composite page) {
        TextParameterPropertyUICreator txtFieldCreator = new TextParameterPropertyUICreator(this.dbc, this.modelMap, this.eip, this.selectedEP, p, this.getValidatorForField(p), page, this.getWidgetFactory());
        txtFieldCreator.create();
        return txtFieldCreator;
    }

    private ScopeAttributeComboFieldPropertyUICreator createScopeCombo(Parameter p, Composite page) {
        ScopeAttributeComboFieldPropertyUICreator scopeFieldCreator = new ScopeAttributeComboFieldPropertyUICreator(this.dbc, (IObservableMap<String, String>)this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory());
        scopeFieldCreator.create();
        return scopeFieldCreator;
    }

    private BeanRefAttributeComboFieldPropertyUICreator createRefCombo(Parameter p, Composite page) {
        BeanRefAttributeComboFieldPropertyUICreator refFieldCreator = new BeanRefAttributeComboFieldPropertyUICreator(this.dbc, (IObservableMap<String, String>)this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory(), new ComboParameterPropertyModifyListener(this.selectedEP, p.getName()), this.getValidatorForField(p));
        refFieldCreator.create();
        return refFieldCreator;
    }

    private void createClassBrowseButton(Composite composite, final Text field) {
        Button browseBeanButton = new Button(composite, 8);
        browseBeanButton.setText("...");
        browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IProject project = AdvancedBeanPropertiesSection.this.selectedEP.getCamelFile().getResource().getProject();
                String className = AdvancedBeanPropertiesSection.this.beanConfigUtil.handleClassBrowse(project, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                if (className != null) {
                    field.setText(className);
                }
            }
        });
    }

    private void createClassNewButton(Composite composite, final Text field) {
        Button newBeanButton = new Button(composite, 8);
        newBeanButton.setText("+");
        newBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IProject project = AdvancedBeanPropertiesSection.this.selectedEP.getCamelFile().getResource().getProject();
                String initialClassName = field.getText();
                String value = AdvancedBeanPropertiesSection.this.beanConfigUtil.handleNewClassWizard(project, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell(), initialClassName);
                if (value != null) {
                    field.setText(value);
                }
            }
        });
    }

    private void createNoArgMethodBrowseButton(Composite composite, Text field) {
        this.createMethodBrowseBtn(composite, field, 2);
    }

    private void createMethodBrowseBtn(Composite composite, Text field, int methodBrowseType) {
        Button browseBeanButton = new Button(composite, 8);
        browseBeanButton.setText("...");
        browseBeanButton.addSelectionListener((SelectionListener)new MethodSelectionListener(methodBrowseType, field));
    }

    private void createPublicOrStaticMethodBrowseButton(Composite composite, Text field) {
        this.createMethodBrowseBtn(composite, field, 3);
    }

    class MethodSelectionListener
    extends SelectionAdapter {
        private int methodBrowseType;
        private Text field;

        public MethodSelectionListener(int browseType, Text field) {
            this.methodBrowseType = browseType;
            this.field = field;
        }

        public void widgetSelected(SelectionEvent event) {
            Object control = AdvancedBeanPropertiesSection.this.modelMap.get((Object)"class");
            if (Strings.isEmpty((String)((String)control))) {
                Object ref = AdvancedBeanPropertiesSection.this.modelMap.get((Object)AdvancedBeanPropertiesSection.this.beanConfigUtil.getFactoryBeanTag(AdvancedBeanPropertiesSection.this.selectedEP.getXmlNode()));
                control = AdvancedBeanPropertiesSection.this.beanConfigUtil.getClassNameFromReferencedCamelBean(AdvancedBeanPropertiesSection.this.selectedEP, (String)ref);
            }
            if (control != null) {
                String methodName;
                IProject project = AdvancedBeanPropertiesSection.this.selectedEP.getCamelFile().getResource().getProject();
                String className = (String)control;
                switch (this.methodBrowseType) {
                    case 1: {
                        methodName = AdvancedBeanPropertiesSection.this.beanConfigUtil.handlePublicAndStaticMethodBrowse(project, className, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                        break;
                    }
                    case 2: {
                        if (AdvancedBeanPropertiesSection.this.beanConfigUtil.isBlueprintConfig(AdvancedBeanPropertiesSection.this.selectedEP.getXmlNode())) {
                            methodName = AdvancedBeanPropertiesSection.this.beanConfigUtil.handleVoidPublicNoArgMethodBrowse(project, className, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                            break;
                        }
                        methodName = AdvancedBeanPropertiesSection.this.beanConfigUtil.handlePublicNoArgMethodBrowse(project, className, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                        break;
                    }
                    case 3: {
                        methodName = AdvancedBeanPropertiesSection.this.beanConfigUtil.handlePublicOrStaticMethodBrowse(project, className, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                        break;
                    }
                    default: {
                        methodName = AdvancedBeanPropertiesSection.this.beanConfigUtil.handleMethodBrowse(project, className, AdvancedBeanPropertiesSection.this.getDisplay().getActiveShell());
                    }
                }
                if (methodName != null) {
                    this.field.setText(methodName);
                }
            }
        }
    }
}

