/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties.creators;

import java.net.URLClassLoader;
import java.util.Arrays;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.properties.creators.AbstractTextFieldParameterPropertyUICreator;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public class AbstractClassBasedParameterPropertyUICreator
extends AbstractTextFieldParameterPropertyUICreator {
    public AbstractClassBasedParameterPropertyUICreator(DataBindingContext dbc, IObservableMap modelMap, Eip eip, AbstractCamelModelElement camelModelElement, Parameter parameter, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, ModifyListener modifyListener) {
        super(dbc, modelMap, eip, camelModelElement, parameter, parent, widgetFactory, modifyListener);
    }

    @Override
    protected void init(Composite parent) {
        super.init(parent);
        IProject project = this.camelModelElement.getCamelFile().getResource().getProject();
        URLClassLoader child = CamelComponentUtils.getProjectClassLoader((IProject)project);
        Class<?> classToLoad = this.computeClassToLoad(child);
        this.createCreateButton(parent, project, classToLoad);
        this.createBrowseButton(parent, project, classToLoad);
    }

    private Class<?> computeClassToLoad(URLClassLoader child) {
        Class<?> classToLoad;
        String javaType = this.parameter.getJavaType();
        try {
            classToLoad = javaType.indexOf(60) != -1 ? child.loadClass(javaType.substring(0, javaType.indexOf(60))) : child.loadClass(javaType);
        }
        catch (ClassNotFoundException ex) {
            CamelEditorUIActivator.pluginLog().logWarning("Cannot find class " + javaType + " on classpath.", (Throwable)ex);
            classToLoad = null;
        }
        return classToLoad;
    }

    private void createBrowseButton(Composite parent, final IProject project, Class<?> fClass) {
        Button btnBrowse = this.getWidgetFactory().createButton(parent, "...", 0x800008);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                    IJavaElement[] elements = new IJavaElement[]{javaProject};
                    IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
                    FilteredTypesSelectionDialog dlg = new FilteredTypesSelectionDialog(Display.getDefault().getActiveShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 5);
                    if (dlg.open() == 0) {
                        Object o = dlg.getFirstResult();
                        if (o instanceof SourceType) {
                            AbstractClassBasedParameterPropertyUICreator.this.getControl().setText(((SourceType)o).getFullyQualifiedName());
                        } else if (o instanceof BinaryType) {
                            AbstractClassBasedParameterPropertyUICreator.this.getControl().setText(((BinaryType)o).getFullyQualifiedName());
                        }
                    }
                }
                catch (Exception ex) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                }
            }
        });
        btnBrowse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnBrowse.setEnabled(fClass != null);
    }

    private void createCreateButton(Composite parent, final IProject project, final Class<?> fClass) {
        Button btnCreate = this.getWidgetFactory().createButton(parent, " + ", 0x800008);
        btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                NewClassCreationWizard wiz = new NewClassCreationWizard();
                wiz.addPages();
                wiz.init(PlatformUI.getWorkbench(), null);
                NewClassWizardPage wp = (NewClassWizardPage)wiz.getStartingPage();
                WizardDialog wd = new WizardDialog(e.display.getActiveShell(), (IWizard)wiz);
                if (fClass.isInterface()) {
                    wp.setSuperInterfaces(Arrays.asList(fClass.getName()), true);
                } else {
                    wp.setSuperClass(fClass.getName(), true);
                }
                wp.setAddComments(true, true);
                this.setInitialPackageFrament(project, wp);
                if (wd.open() == 0 && (value = wp.getCreatedType().getFullyQualifiedName()) != null) {
                    AbstractClassBasedParameterPropertyUICreator.this.getControl().setText(value);
                }
            }

            private void setInitialPackageFrament(IProject project2, NewClassWizardPage wp) {
                try {
                    IJavaProject javaProject = (IJavaProject)project2.getNature("org.eclipse.jdt.core.javanature");
                    if (javaProject != null) {
                        IPackageFragmentRoot fragroot = this.findPackageFragmentRoot(project2, javaProject);
                        wp.setPackageFragmentRoot(fragroot, true);
                        wp.setPackageFragment(PropertiesUtils.getPackage((IJavaProject)javaProject, (IPackageFragmentRoot)fragroot), true);
                    }
                }
                catch (Exception ex) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                }
            }

            private IPackageFragmentRoot findPackageFragmentRoot(IProject project2, IJavaProject javaProject) throws JavaModelException {
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project2, (IProgressMonitor)new NullProgressMonitor());
                if (facade != null) {
                    IPath[] paths = facade.getCompileSourceLocations();
                    if (paths != null && paths.length > 0) {
                        IPath[] iPathArray = paths;
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPath p = iPathArray[n2];
                            if (p != null) {
                                IResource res = project2.findMember(p);
                                return javaProject.getPackageFragmentRoot(res);
                            }
                            ++n2;
                        }
                    }
                } else {
                    IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    if (allPackageFragmentRoots.length == 1) {
                        return allPackageFragmentRoots[0];
                    }
                }
                return null;
            }
        });
        btnCreate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnCreate.setEnabled(fClass != null);
    }

    @Override
    protected GridData createPropertyFieldLayoutData() {
        return GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).create();
    }
}

