/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Repository;
import org.fusesource.ide.camel.model.service.core.CamelManagerException;
import org.fusesource.ide.camel.model.service.core.CamelSchemaProvider;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCoordinates;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class CamelManagerServiceProxy
extends ServiceTracker<ICamelManagerService, ICamelManagerService>
implements ICamelManagerService {
    private String serviceVersion;

    public CamelManagerServiceProxy(BundleContext context, String serviceVersion) throws InvalidSyntaxException {
        super(context, context.createFilter(MessageFormat.format("(&(objectClass={0})(camel.version={1}))", ICamelManagerService.class.getCanonicalName(), serviceVersion)), null);
        this.serviceVersion = serviceVersion;
        this.open();
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    private ICamelManagerService checkedGetService() throws CamelManagerException {
        ICamelManagerService service = (ICamelManagerService)this.getService();
        if (service == null) {
            throw new CamelManagerException("Could not acquire Camel Management service");
        }
        return service;
    }

    @Override
    public CamelModel getCamelModel(String camelVersion, String runtimeProvider) {
        return this.checkedGetService().getCamelModel(camelVersion, runtimeProvider);
    }

    @Override
    public CamelModel getCamelModelForKarafRuntimeProvider(String camelVersion) {
        return this.getCamelModel(camelVersion, "karaf");
    }

    @Override
    public void updateMavenRepositoryLookup(List<Repository> repositories, CamelCatalogCoordinates coords) {
        this.checkedGetService().updateMavenRepositoryLookup(repositories, coords);
    }

    @Override
    public CamelSchemaProvider getCamelSchemaProvider(CamelCatalogCoordinates coords) {
        return this.checkedGetService().getCamelSchemaProvider(coords);
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> properties, CamelCatalogCoordinates coords) throws URISyntaxException {
        return this.checkedGetService().createEndpointUri(scheme, properties, coords);
    }

    @Override
    public String createEndpointXml(String scheme, Map<String, String> properties, CamelCatalogCoordinates coords) throws URISyntaxException {
        return this.checkedGetService().createEndpointXml(scheme, properties, coords);
    }

    @Override
    public Map<String, String> getEndpointProperties(String uri, CamelCatalogCoordinates coords) throws URISyntaxException {
        return this.checkedGetService().getEndpointProperties(uri, coords);
    }

    @Override
    public String getEndpointScheme(String uri, CamelCatalogCoordinates coords) {
        return this.checkedGetService().getEndpointScheme(uri, coords);
    }

    @Override
    public String testExpression(String language, String expression) {
        return this.checkedGetService().testExpression(language, expression);
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> properties, boolean encode, CamelCatalogCoordinates coords) throws URISyntaxException {
        return this.checkedGetService().createEndpointUri(scheme, properties, encode, coords);
    }

    @Override
    public String createEndpointXml(String scheme, Map<String, String> properties, boolean encode, CamelCatalogCoordinates coords) throws URISyntaxException {
        return this.checkedGetService().createEndpointXml(scheme, properties, encode, coords);
    }

    @Override
    public long durationToMillis(String duration) {
        return this.checkedGetService().durationToMillis(duration);
    }

    @Override
    public Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return this.checkedGetService().parseQuery(uri);
    }

    @Override
    public String createQuery(Map<String, Object> parameters) throws URISyntaxException {
        return this.checkedGetService().createQuery(parameters);
    }

    @Override
    public boolean isCamelVersionExisting(String camelVersion) {
        return this.checkedGetService().isCamelVersionExisting(camelVersion);
    }
}

