/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core;

import java.util.ArrayList;
import java.util.Collection;
import org.fusesource.ide.camel.model.service.core.CamelManagerException;
import org.fusesource.ide.camel.model.service.core.CamelManagerServiceProxy;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.foundation.core.util.BundleUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CamelServiceManagerUtil {
    public static final String DEFAULT_SERVICE = "dynamic";

    private CamelServiceManagerUtil() {
    }

    public static ICamelManagerService getManagerService() {
        return CamelServiceManagerUtil.getManagerService(DEFAULT_SERVICE);
    }

    public static ICamelManagerService getManagerService(String serviceVersion) {
        try {
            BundleContext context = CamelModelServiceCoreActivator.getBundleContext();
            CamelManagerServiceProxy proxy = new CamelManagerServiceProxy(context, serviceVersion);
            proxy.open();
            return proxy;
        }
        catch (InvalidSyntaxException ise) {
            throw new CamelManagerException(ise);
        }
    }

    public static String[] getAvailableVersions() {
        try {
            BundleContext context = CamelModelServiceCoreActivator.getBundleContext();
            Collection refs = BundleUtils.findServiceReferences((BundleContext)context, ICamelManagerService.class);
            ArrayList<String> ret = new ArrayList<String>();
            for (ServiceReference next : refs) {
                String vers = (String)next.getProperty("camel.version");
                if (ret.contains(vers)) continue;
                ret.add(vers);
            }
            return ret.toArray(new String[ret.size()]);
        }
        catch (InvalidSyntaxException ise) {
            throw new CamelManagerException(ise);
        }
    }

    public static <RESULT> RESULT executeWithService(IServiceAware<RESULT> serviceAware, String version) throws Exception {
        ICamelManagerService service = null;
        service = CamelServiceManagerUtil.getManagerService(version);
        return serviceAware.execute(service);
    }

    public static interface IServiceAware<RESULT> {
        public RESULT execute(ICamelManagerService var1) throws Exception;
    }
}

