/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.camel.model.service.core.CamelServiceManagerUtil;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCoordinates;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.internal.Messages;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;

public class CamelCatalogCacheManager {
    private static Map<CamelCatalogCoordinates, CamelModel> camelModelCache = new HashMap<CamelCatalogCoordinates, CamelModel>();
    private static final CamelCatalogCacheManager instance = new CamelCatalogCacheManager();
    private static CamelModel lastRetrievedCamelCatalog;

    protected CamelCatalogCacheManager() {
    }

    public static CamelCatalogCacheManager getInstance() {
        return instance;
    }

    public void clear() {
        camelModelCache.clear();
    }

    private synchronized CamelModel getCachedCatalog(CamelCatalogCoordinates coordinates, IProgressMonitor monitor) {
        CamelModel camelModel;
        if (!camelModelCache.containsKey(coordinates)) {
            this.initializeCatalog(coordinates, monitor);
        }
        lastRetrievedCamelCatalog = camelModel = camelModelCache.get(coordinates);
        return camelModel;
    }

    public void clearCachedCatalog(CamelCatalogCoordinates coordinates) {
        camelModelCache.remove(coordinates);
    }

    @Deprecated
    public CamelModel getCamelModelForProject(IProject project) {
        return this.getCamelModelForProject(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public CamelModel getDefaultCamelModel(String version) {
        CamelCatalogCoordinates coords = CamelCatalogUtils.getDefaultCatalogCoordinates();
        coords.setVersion(version);
        if (CamelCatalogUtils.isCamelVersionWithoutProviderSupport(version)) {
            coords.setArtifactId("camel-catalog");
        }
        return this.getCachedCatalog(coords, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initializeCatalog(CamelCatalogCoordinates coordinates, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.initializingCamelModel, (Object)coordinates.getVersion()), (int)1);
        Dependency dep = new Dependency();
        dep.setGroupId(coordinates.getGroupId());
        dep.setArtifactId(coordinates.getArtifactId());
        dep.setVersion(coordinates.getVersion());
        camelModelCache.put(coordinates, CamelServiceManagerUtil.getManagerService().getCamelModel(coordinates.getVersion(), CamelCatalogUtils.getRuntimeProviderFromDependency(dep)));
        subMonitor.setWorkRemaining(0);
    }

    public CamelModel getCamelModelForProject(IProject project, IProgressMonitor monitor) {
        CamelCatalogCoordinates coords;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.retrievingCamelModel, (int)3);
        if (project == null) {
            if (lastRetrievedCamelCatalog != null) {
                return lastRetrievedCamelCatalog;
            }
            coords = CamelCatalogUtils.getDefaultCatalogCoordinates();
        } else {
            coords = CamelCatalogUtils.getCatalogCoordinatesForProject(project, (IProgressMonitor)subMonitor.split(1));
            List<Repository> mavenRepositories = new CamelMavenUtils().getRepositories(project, (IProgressMonitor)subMonitor.split(1));
            CamelServiceManagerUtil.getManagerService().updateMavenRepositoryLookup(mavenRepositories, coords);
        }
        subMonitor.setWorkRemaining(1);
        if (coords != null) {
            return this.getCachedCatalog(coords, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.setWorkRemaining(0);
        return null;
    }

    public Map<CamelCatalogCoordinates, CamelModel> getCachedCatalog() {
        return camelModelCache;
    }

    public static void setCachedCatalog(Map<CamelCatalogCoordinates, CamelModel> cachedCatalog) {
        camelModelCache = cachedCatalog;
    }
}

