/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.cache;

import java.util.Objects;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;

public class CamelCatalogCoordinates {
    private String groupId;
    private String artifactId;
    private String version;

    public CamelCatalogCoordinates(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public CamelCatalogCoordinates(Dependency dependency) {
        this.groupId = dependency.getGroupId();
        this.artifactId = dependency.getArtifactId();
        this.version = dependency.getVersion();
        org.apache.maven.model.Dependency dep = new org.apache.maven.model.Dependency();
        dep.setGroupId(this.groupId);
        dep.setArtifactId(this.artifactId);
        dep.setVersion(this.version);
        CamelCatalogUtils.getRuntimeProviderFromDependency(dep);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof CamelCatalogCoordinates) {
            CamelCatalogCoordinates other = (CamelCatalogCoordinates)arg0;
            return this.isSameCoordinateIgnoringCase(this.getGroupId(), other.getGroupId()) && this.isSameCoordinateIgnoringCase(this.getArtifactId(), other.getArtifactId()) && this.isSameCoordinateIgnoringCase(this.getVersion(), other.getVersion());
        }
        return false;
    }

    private boolean isSameCoordinateIgnoringCase(String us, String their) {
        return us == null && their == null || us != null && us.equalsIgnoreCase(their);
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    public org.apache.maven.model.Dependency asMavenDependency() {
        org.apache.maven.model.Dependency dep = new org.apache.maven.model.Dependency();
        dep.setGroupId(this.getGroupId());
        dep.setArtifactId(this.getArtifactId());
        dep.setVersion(this.getVersion());
        return dep;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version != null ? this.version : "2.18.1.redhat-000021";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getVersion());
    }
}

