/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.catalog.languages.Language;

public class CamelModel {
    private Map<String, Component> components = new HashMap<String, Component>();
    private Map<String, DataFormat> dataformats = new HashMap<String, DataFormat>();
    private Map<String, Eip> eips = new HashMap<String, Eip>();
    private Map<String, Language> languages = new HashMap<String, Language>();

    public void addComponent(Component component) {
        this.components.put(component.getScheme(), component);
    }

    public Component getComponent(String scheme) {
        return this.components.get(scheme);
    }

    public Collection<Component> getComponents() {
        return this.components.values();
    }

    public Component getComponentForScheme(String scheme) {
        for (Map.Entry<String, Component> e : this.components.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(scheme)) continue;
            return e.getValue();
        }
        return null;
    }

    public void setComponents(Map<String, Component> components) {
        this.components.putAll(components);
    }

    public void addDataFormat(DataFormat dataformat) {
        this.dataformats.put(dataformat.getName(), dataformat);
    }

    public DataFormat getDataFormat(String name) {
        return this.dataformats.get(name);
    }

    public Collection<DataFormat> getDataFormats() {
        return this.dataformats.values();
    }

    public Collection<DataFormat> getDataFormatsByModelName(String modelName) {
        ArrayList<DataFormat> dfs = new ArrayList<DataFormat>();
        for (DataFormat df : this.dataformats.values()) {
            if (!df.getModelName().equalsIgnoreCase(modelName)) continue;
            dfs.add(df);
        }
        return dfs;
    }

    public void setDataFormats(Map<String, DataFormat> dataformats) {
        this.dataformats.putAll(dataformats);
    }

    public void addEip(Eip eip) {
        this.eips.put(eip.getName(), eip);
    }

    public Eip getEip(String name) {
        return this.eips.get(name);
    }

    public Collection<Eip> getEips() {
        return this.eips.values();
    }

    public void setEips(Map<String, Eip> eips) {
        this.eips.putAll(eips);
    }

    public void addLanguage(Language language) {
        this.languages.put(language.getName(), language);
    }

    public Language getLanguage(String name) {
        return this.languages.get(name);
    }

    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    public void setLanguages(Map<String, Language> languages) {
        this.languages.putAll(languages);
    }
}

