/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.components;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.ICamelCatalogElement;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentProperty;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public class Component
implements ICamelCatalogElement,
IParameterContainer {
    public static final String PROPERTY_CONSUMER_ONLY = "consumerOnly";
    public static final String PROPERTY_PRODUCER_ONLY = "producerOnly";
    public static final String PROPERTY_SCHEME = "scheme";
    public static final String PROPERTY_KIND = "kind";
    public static final String PROPERTY_JAVA_TYPE = "javaType";
    public static final String PROPERTY_SYNTAX = "syntax";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_GROUPID = "groupId";
    public static final String PROPERTY_ARTIFACTID = "artifactId";
    public static final String PROPERTY_VERSION = "version";
    @JsonProperty(value="component")
    private Map<String, String> model = new HashMap<String, String>();
    @JsonProperty(value="componentProperties")
    private Map<String, ComponentProperty> componentProperties = new HashMap<String, ComponentProperty>();
    @JsonProperty(value="properties")
    private Map<String, Parameter> properties = new HashMap<String, Parameter>();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> otherProperties = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.otherProperties;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.otherProperties.put(name, value);
    }

    @Override
    public Parameter getParameter(String name) {
        return this.properties.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.properties.values());
    }

    public String getId() {
        return this.getScheme();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public String getConsumerOnly() {
        String consumerOnly = this.model.get(PROPERTY_CONSUMER_ONLY);
        if (!Strings.isEmpty((String)consumerOnly)) {
            return consumerOnly;
        }
        return Boolean.FALSE.toString();
    }

    public void setConsumerOnly(String consumerOnly) {
        this.model.put(PROPERTY_CONSUMER_ONLY, consumerOnly);
    }

    public String getProducerOnly() {
        String producerOnly = this.model.get(PROPERTY_PRODUCER_ONLY);
        if (producerOnly != null && producerOnly.trim().length() > 0) {
            return producerOnly;
        }
        return Boolean.FALSE.toString();
    }

    public void setProducerOnly(String producerOnly) {
        this.model.put(PROPERTY_PRODUCER_ONLY, producerOnly);
    }

    public String getKind() {
        return this.model.get(PROPERTY_KIND);
    }

    public void setKind(String kind) {
        this.model.put(PROPERTY_KIND, kind);
    }

    public String getScheme() {
        return this.model.get(PROPERTY_SCHEME);
    }

    public void setScheme(String scheme) {
        this.model.put(PROPERTY_SCHEME, scheme);
    }

    public String getClazz() {
        return this.model.get(PROPERTY_JAVA_TYPE);
    }

    public void setClazz(String clazz) {
        this.model.put(PROPERTY_JAVA_TYPE, clazz);
    }

    public String getSyntax() {
        return this.model.get(PROPERTY_SYNTAX);
    }

    public void setSyntax(String syntax) {
        this.model.put(PROPERTY_SYNTAX, syntax);
    }

    public String getDescription() {
        return this.model.get(PROPERTY_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.model.put(PROPERTY_DESCRIPTION, description);
    }

    public String getTitle() {
        return this.model.get(PROPERTY_TITLE);
    }

    public void setTitle(String title) {
        this.model.put(PROPERTY_TITLE, title);
    }

    public List<String> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            this.tags = CamelCatalogUtils.initializeTags(this.model.get(PROPERTY_LABEL));
        }
        return this.tags;
    }

    public void setTags(List<String> tags) {
        String label = tags != null ? tags.stream().collect(Collectors.joining(",")) : "";
        this.model.put(PROPERTY_LABEL, label);
        this.tags = tags;
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            this.dependencies = new ArrayList<Dependency>();
            CamelCatalogUtils.parseDependencies(this.dependencies, this.getModel());
        }
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = new ArrayList<Dependency>(dependencies);
    }

    public boolean supportsScheme(String scheme) {
        return this.getScheme().equals(scheme);
    }

    public String getSchemeTitle() {
        return this.getScheme();
    }

    public String getDisplayTitle() {
        return Strings.isBlank((String)this.getTitle()) ? Strings.humanize((String)this.getSchemeTitle()) : this.getTitle();
    }

    public Map<String, String> getModel() {
        return this.model;
    }

    public void setModel(Map<String, String> model) {
        this.model = model;
    }

    public Map<String, ComponentProperty> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(Map<String, ComponentProperty> componentProperties) {
        this.componentProperties = componentProperties;
        PropertiesUtils.initializeComponentPropertyNames(this.componentProperties);
    }

    public Map<String, Parameter> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Parameter> properties) {
        this.properties = properties;
        PropertiesUtils.initializePropertyNames(this.properties);
    }

    public boolean containsCustomValueForKey(String key) {
        return this.model.containsKey(key);
    }

    public String getCustomComponentModelValue(String key) {
        return this.model.get(key);
    }

    public void setCustomComponentModelValue(String key, String value) {
        this.model.put(key, value);
    }

    public Component duplicateFor(final String scheme, String clazz) {
        Component dup = new Component(){

            @Override
            public boolean supportsScheme(String testScheme) {
                return scheme.equals(testScheme);
            }
        };
        dup.setScheme(scheme);
        dup.setClazz(clazz);
        dup.setComponentProperties(this.getComponentProperties());
        dup.setConsumerOnly(this.getConsumerOnly());
        dup.setDescription(this.getDescription());
        dup.setKind(this.getKind());
        dup.setProducerOnly(this.getProducerOnly());
        dup.setSyntax(this.getSyntax().replaceFirst(String.format("%s:", this.getScheme()), String.format("%s:", scheme)));
        dup.setTags(this.getTags());
        dup.setTitle(this.getTitle());
        dup.setProperties(this.getProperties());
        return dup;
    }

    public static Component getJSONFactoryInstance(InputStream stream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Component)mapper.readValue(stream, Component.class);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

