/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.dataformats;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.ICamelCatalogElement;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public class DataFormat
implements ICamelCatalogElement,
IParameterContainer {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_KIND = "kind";
    public static final String PROPERTY_MODEL_NAME = "modelName";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_JAVA_TYPE = "javaType";
    public static final String PROPERTY_MODEL_JAVA_TYPE = "modelJavaType";
    public static final String PROPERTY_GROUPID = "groupId";
    public static final String PROPERTY_ARTIFACTID = "artifactId";
    public static final String PROPERTY_VERSION = "version";
    @JsonProperty(value="dataformat")
    private Map<String, String> model = new HashMap<String, String>();
    @JsonProperty(value="properties")
    private Map<String, Parameter> properties = new HashMap<String, Parameter>();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> otherProperties = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.otherProperties;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.otherProperties.put(name, value);
    }

    @Override
    public Parameter getParameter(String name) {
        return this.properties.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.properties.values());
    }

    @Override
    public String getName() {
        return this.model.get(PROPERTY_NAME);
    }

    public void setName(String name) {
        this.model.put(PROPERTY_NAME, name);
    }

    public String getKind() {
        return this.model.get(PROPERTY_KIND);
    }

    public void setKind(String kind) {
        this.model.put(PROPERTY_KIND, kind);
    }

    public String getModelJavaType() {
        return this.model.get(PROPERTY_MODEL_JAVA_TYPE);
    }

    public void setModelJavaType(String modelJavaType) {
        this.model.put(PROPERTY_MODEL_JAVA_TYPE, modelJavaType);
    }

    public String getModelName() {
        return this.model.get(PROPERTY_MODEL_NAME);
    }

    public void setModelName(String modelName) {
        this.model.put(PROPERTY_MODEL_NAME, modelName);
    }

    public String getClazz() {
        return this.model.get(PROPERTY_JAVA_TYPE);
    }

    public void setClazz(String clazz) {
        this.model.put(PROPERTY_JAVA_TYPE, clazz);
    }

    public String getDescription() {
        return this.model.get(PROPERTY_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.model.put(PROPERTY_DESCRIPTION, description);
    }

    public String getTitle() {
        return this.model.get(PROPERTY_TITLE);
    }

    public void setTitle(String title) {
        this.model.put(PROPERTY_TITLE, title);
    }

    public List<String> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            this.tags = CamelCatalogUtils.initializeTags(this.model.get(PROPERTY_LABEL));
        }
        return this.tags;
    }

    public void setTags(List<String> tags) {
        String label = tags != null ? tags.stream().collect(Collectors.joining(",")) : "";
        this.model.put(PROPERTY_LABEL, label);
        this.tags = tags;
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            this.dependencies = new ArrayList<Dependency>();
            CamelCatalogUtils.parseDependencies(this.dependencies, this.getModel());
        }
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public Map<String, String> getModel() {
        return this.model;
    }

    public void setModel(Map<String, String> model) {
        this.model = model;
    }

    public Map<String, Parameter> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Parameter> properties) {
        this.properties = properties;
        PropertiesUtils.initializePropertyNames(properties);
    }

    public boolean containsCustomValueForKey(String key) {
        return this.model.containsKey(key);
    }

    public String getCustomComponentModelValue(String key) {
        return this.model.get(key);
    }

    public void setCustomComponentModelValue(String key, String value) {
        this.model.put(key, value);
    }

    public static DataFormat getJSONFactoryInstance(InputStream stream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (DataFormat)mapper.readValue(stream, DataFormat.class);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

