/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.eips;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fusesource.ide.camel.model.service.core.catalog.ICamelCatalogElement;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public class Eip
implements ICamelCatalogElement,
IParameterContainer {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_KIND = "kind";
    public static final String PROPERTY_JAVA_TYPE = "javaType";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_INPUT = "input";
    public static final String PROPERTY_OUTPUT = "output";
    @JsonProperty(value="model")
    private Map<String, String> model = new HashMap<String, String>();
    @JsonProperty(value="properties")
    private Map<String, Parameter> properties = new HashMap<String, Parameter>();
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> otherProperties = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.otherProperties;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.otherProperties.put(name, value);
    }

    @Override
    public Parameter getParameter(String name) {
        return this.properties.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.properties.values());
    }

    @Override
    public String getName() {
        return this.model.get(PROPERTY_NAME);
    }

    public void setName(String name) {
        this.model.put(PROPERTY_NAME, name);
    }

    public String getKind() {
        return this.model.get(PROPERTY_KIND);
    }

    public void setKind(String kind) {
        this.model.put(PROPERTY_KIND, kind);
    }

    public String getInput() {
        String input = this.model.get(PROPERTY_INPUT);
        if (input != null && input.trim().length() > 0) {
            return input;
        }
        return Boolean.FALSE.toString();
    }

    public void setInput(String input) {
        this.model.put(PROPERTY_INPUT, input);
    }

    public String getOutput() {
        String output = this.model.get(PROPERTY_OUTPUT);
        if (output != null && output.trim().length() > 0) {
            return output;
        }
        return Boolean.FALSE.toString();
    }

    public void setOutput(String output) {
        this.model.put(PROPERTY_OUTPUT, output);
    }

    public String getClazz() {
        return this.model.get(PROPERTY_JAVA_TYPE);
    }

    public void setClazz(String clazz) {
        this.model.put(PROPERTY_JAVA_TYPE, clazz);
    }

    public String getDescription() {
        return this.model.get(PROPERTY_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.model.put(PROPERTY_DESCRIPTION, description);
    }

    public String getTitle() {
        return this.model.get(PROPERTY_TITLE);
    }

    public void setTitle(String title) {
        this.model.put(PROPERTY_TITLE, title);
    }

    public List<String> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            this.tags = CamelCatalogUtils.initializeTags(this.model.get(PROPERTY_LABEL));
        }
        return this.tags;
    }

    public void setTags(List<String> tags) {
        String label = tags != null ? tags.stream().collect(Collectors.joining(",")) : "";
        this.model.put(PROPERTY_LABEL, label);
        this.tags = tags;
    }

    public Map<String, String> getModel() {
        return this.model;
    }

    public void setModel(Map<String, String> model) {
        this.model = model;
    }

    public Map<String, Parameter> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Parameter> properties) {
        this.properties = properties;
        PropertiesUtils.initializePropertyNames(this.properties);
    }

    public boolean containsCustomValueForKey(String key) {
        return this.model.containsKey(key);
    }

    public String getCustomComponentModelValue(String key) {
        return this.model.get(key);
    }

    public void setCustomComponentModelValue(String key, String value) {
        this.model.put(key, value);
    }

    public boolean canHaveChildren() {
        for (Parameter p : this.getParameters()) {
            if (!"array".equalsIgnoreCase(p.getType()) || !"element".equalsIgnoreCase(p.getKind()) || !"true".equalsIgnoreCase(this.getInput())) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllowedChildrenNodeTypes() {
        ArrayList<String> allowedNodeTypes = new ArrayList<String>();
        if (this.canHaveChildren()) {
            for (Parameter p : this.getParameters()) {
                String[] types;
                if (!"array".equalsIgnoreCase(p.getType()) || !"element".equalsIgnoreCase(p.getKind()) || p.getOneOf() == null) continue;
                String[] stringArray = types = p.getOneOf();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    allowedNodeTypes.add(type.trim());
                    ++n2;
                }
            }
        }
        return allowedNodeTypes;
    }

    public boolean canBeAddedToCamelContextDirectly() {
        return "route".equalsIgnoreCase(this.getName()) || "rest".equalsIgnoreCase(this.getName()) || "restConfiguration".equalsIgnoreCase(this.getName());
    }

    public static Eip getJSONFactoryInstance(InputStream stream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Eip)mapper.readValue(stream, Eip.class);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

