/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.internal.io;

import java.util.Stack;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SAXHandlerWithLineNumber
extends DefaultHandler2 {
    private final Document doc;
    private final Stack<Node> elementStack = new Stack();
    private final StringBuilder textBuffer = new StringBuilder();
    private Locator locator;

    public SAXHandlerWithLineNumber(Document doc) {
        this.doc = doc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addTextIfNeeded();
        Element el = this.doc.createElement(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            el.setAttribute(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        el.setUserData("LINE_NUMBER_ATT_NAME", this.locator.getLineNumber(), new UserDataHandler(){

            @Override
            public void handle(short arg0, String arg1, Object arg2, Node arg3, Node arg4) {
            }
        });
        this.elementStack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Node closedEl = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Node parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Node el = this.elementStack.peek();
            CharacterData textNode = null;
            if (el instanceof Element) {
                textNode = this.doc.createTextNode(this.textBuffer.toString());
            } else if (el instanceof Comment) {
                textNode = this.doc.createComment(this.textBuffer.toString());
            }
            el.appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }

    public Locator getLocator() {
        return this.locator;
    }
}

