/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.preferences.PreferenceManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractCamelModelElement {
    private static final String NODE_KIND_VALUE = "value";
    private static final String DESCRIPTION_NODE_NAME = "description";
    public static final String NODE_KIND_EXPRESSION = "expression";
    public static final String NODE_KIND_ATTRIBUTE = "attribute";
    public static final String NODE_KIND_ELEMENT = "element";
    public static final String URI_PARAMETER_KEY = "uri";
    public static final String ENDPOINT_TYPE_TO = "to";
    public static final String ENDPOINT_TYPE_FROM = "from";
    public static final String TOPIC_REMOVE_CAMEL_ELEMENT = "TOPIC_REMOVE_CAMEL_ELEMENT";
    public static final String TOPIC_ID_RENAMING = "TOPIC_ID_RENAMING";
    public static final String PROPERTY_KEY_OLD_ID = "OLD_ID";
    public static final String PROPERTY_KEY_NEW_ID = "NEW_ID";
    public static final String PROPERTY_KEY_CAMEL_FILE = "CAMEL_FILE";
    public static final String PARAMETER_LANGUAGENAME = "languageName";
    public static final String CHOICE_NODE_NAME = "choice";
    public static final String WHEN_NODE_NAME = "when";
    public static final String OTHERWISE_NODE_NAME = "otherwise";
    public static final String WIRETAP_NODE_NAME = "wireTap";
    public static final String ROUTE_NODE_NAME = "route";
    public static final String ID_ATTRIBUTE = "id";
    public static final String ROUTE_ATTRIBUTE = "route";
    public static final String DATA_FORMATS_NODE_NAME = "dataFormats";
    public static final String ENDPOINT_NODE_NAME = "endpoint";
    public static final String CAMEL_CONTEXT_NODE_NAME = "camelContext";
    public static final String BEAN_NODE = "bean";
    private List<AbstractCamelModelElement> childElements = new ArrayList<AbstractCamelModelElement>();
    private AbstractCamelModelElement inputElement;
    private AbstractCamelModelElement outputElement;
    private AbstractCamelModelElement parent;
    private Node xmlNode;
    private Eip underlyingMetaModelObject;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private CamelFile cf;
    private CamelRouteContainerElement container;
    private String name;
    private String description;
    private static boolean optimizedXML = true;

    protected AbstractCamelModelElement(AbstractCamelModelElement parent, Node underlyingNode) {
        this.xmlNode = underlyingNode;
        this.parent = parent;
        if (underlyingNode != null) {
            this.setUnderlyingMetaModelObject(this.getEipByName(CamelUtils.getTagNameWithoutPrefix((Node)underlyingNode)));
        }
        if (!(parent == null || parent.getXmlNode() == null || underlyingNode == null || this.getXmlNode().getParentNode() != null && DATA_FORMATS_NODE_NAME.equals(CamelUtils.getTagNameWithoutPrefix((Node)this.getXmlNode().getParentNode())))) {
            boolean alreadyChild = false;
            NodeList siblingNodes = parent.getXmlNode().getChildNodes();
            int i = 0;
            while (i < siblingNodes.getLength()) {
                if (siblingNodes.item(i).isEqualNode(underlyingNode)) {
                    alreadyChild = true;
                    break;
                }
                ++i;
            }
            if (!alreadyChild) {
                if (CHOICE_NODE_NAME.equals(parent.getNodeTypeId())) {
                    if (WHEN_NODE_NAME.equals(this.getNodeTypeId())) {
                        Node otherwiseNode = null;
                        int i2 = 0;
                        while (i2 < siblingNodes.getLength()) {
                            if (OTHERWISE_NODE_NAME.equals(CamelUtils.getTagNameWithoutPrefix((Node)siblingNodes.item(i2)))) {
                                otherwiseNode = siblingNodes.item(i2);
                                break;
                            }
                            ++i2;
                        }
                        parent.getXmlNode().insertBefore(this.getXmlNode(), otherwiseNode);
                    } else if (OTHERWISE_NODE_NAME.equals(this.getNodeTypeId())) {
                        parent.getXmlNode().appendChild(this.getXmlNode());
                    }
                } else {
                    parent.getXmlNode().appendChild(this.getXmlNode());
                }
            }
        }
    }

    public static boolean useOptimizedXML() {
        return optimizedXML;
    }

    public static void setOptimizedXML(boolean optimizedXML) {
        AbstractCamelModelElement.optimizedXML = optimizedXML;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public AbstractCamelModelElement findEndpoint(String uri) {
        if (uri != null) {
            if (this.getChildElements().isEmpty()) {
                if (uri.equals(this.getParameter(URI_PARAMETER_KEY))) {
                    return this;
                }
            } else {
                return this.getChildElements().stream().filter(cme -> cme.findEndpoint(uri) != null).findFirst().orElse(null);
            }
        }
        return null;
    }

    protected Node getFirstChild(Node parentNode) {
        int i = 0;
        while (i < parentNode.getChildNodes().getLength()) {
            Node n = parentNode.getChildNodes().item(i);
            if (n.getNodeType() == 1) {
                return n;
            }
            ++i;
        }
        return null;
    }

    protected Node getLastChild(Node parentNode) {
        int i = parentNode.getChildNodes().getLength() - 1;
        while (i >= 0) {
            Node n = parentNode.getChildNodes().item(i);
            if (n.getNodeType() == 1) {
                return n;
            }
            --i;
        }
        return null;
    }

    protected Node getPreviousNode(Node node) {
        Node n = node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return n;
            }
            n = n.getPreviousSibling();
        }
        return null;
    }

    protected Node getNextNode(Node node) {
        Node n = node.getNextSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public AbstractCamelModelElement getParent() {
        return this.parent;
    }

    public boolean hasSameParent(AbstractCamelModelElement other) {
        return this.getParent().equals(other.getParent());
    }

    public boolean canBeAddedToCamelContextDirectly() {
        return this.getUnderlyingMetaModelObject().canBeAddedToCamelContextDirectly();
    }

    public AbstractCamelModelElement getFirstInFlow() {
        AbstractCamelModelElement node = this;
        while (node != null && node.getInputElement() != null) {
            node = node.getInputElement();
        }
        return node;
    }

    public AbstractCamelModelElement getLastInFlow() {
        AbstractCamelModelElement node = this;
        while (node != null && node.getOutputElement() != null) {
            node = node.getOutputElement();
        }
        return node;
    }

    public CamelRouteElement getRoute() {
        AbstractCamelModelElement cme = this.getParent();
        while (!(cme instanceof CamelRouteElement) && cme != null) {
            cme = cme.getParent();
        }
        if (cme != null && cme instanceof CamelRouteElement) {
            return (CamelRouteElement)cme;
        }
        return null;
    }

    public void setParent(AbstractCamelModelElement parent) {
        this.parent = parent;
    }

    public String getId() {
        if (this.getParameter(ID_ATTRIBUTE) != null) {
            return (String)this.getParameter(ID_ATTRIBUTE);
        }
        return null;
    }

    public void setId(String id) {
        this.setParameter(ID_ATTRIBUTE, id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setParameter(DESCRIPTION_NODE_NAME, description);
    }

    public String getDisplayText() {
        return this.getDisplayText(true);
    }

    public final String getDisplayText(boolean useID) {
        String answer;
        Object propVal;
        String uri;
        String result = String.format("%s ", Strings.capitalize((String)this.getNodeTypeId()));
        boolean preferID = false;
        if (useID) {
            preferID = PreferenceManager.getInstance().containsPreference("preferIdAsLabelPreference");
            if (PreferenceManager.getInstance().containsPreference("preferIdAsLabelPreference")) {
                preferID = PreferenceManager.getInstance().loadPreferenceAsBoolean("preferIdAsLabelPreference");
            }
        }
        if (preferID && this.getId() != null && this.getId().trim().length() > 0) {
            result = String.valueOf(result) + this.getId();
            return result;
        }
        if (this.isEndpointElement() && (uri = (String)this.getParameter(URI_PARAMETER_KEY)) != null && uri.trim().length() > 0) {
            result = uri;
            return result;
        }
        String eipType = this.getNodeTypeId();
        String[] nodeNameOnly = new String[]{CHOICE_NODE_NAME, "try", "finally", OTHERWISE_NODE_NAME, "marshal", "unmarshal"};
        if (Arrays.asList(nodeNameOnly).contains(eipType)) {
            return result.trim();
        }
        HashMap<String, String> singlePropertyDisplay = new HashMap<String, String>();
        singlePropertyDisplay.put(BEAN_NODE, "ref");
        singlePropertyDisplay.put("convertBodyTo", "type");
        singlePropertyDisplay.put("enrich", URI_PARAMETER_KEY);
        singlePropertyDisplay.put("inOnly", URI_PARAMETER_KEY);
        singlePropertyDisplay.put("inOut", URI_PARAMETER_KEY);
        singlePropertyDisplay.put("interceptSendToEndpoint", URI_PARAMETER_KEY);
        singlePropertyDisplay.put("log", "logName");
        singlePropertyDisplay.put("onException", "exception");
        singlePropertyDisplay.put("pollEnrich", URI_PARAMETER_KEY);
        singlePropertyDisplay.put("removeHeader", "headerName");
        singlePropertyDisplay.put("removeProperty", "propertyName");
        singlePropertyDisplay.put("rollback", "message");
        singlePropertyDisplay.put("sort", NODE_KIND_EXPRESSION);
        singlePropertyDisplay.put(WHEN_NODE_NAME, NODE_KIND_EXPRESSION);
        String propertyToCheck = (String)singlePropertyDisplay.get(eipType);
        if (propertyToCheck != null && (propVal = this.getParameter(propertyToCheck)) != null) {
            if (propVal instanceof AbstractCamelModelElement) {
                String expression;
                String string = expression = ((AbstractCamelModelElement)propVal).getParameter(NODE_KIND_EXPRESSION) != null ? (String)((AbstractCamelModelElement)propVal).getParameter(NODE_KIND_EXPRESSION) : null;
                if (expression != null) {
                    return String.valueOf(result) + expression;
                }
            } else {
                return String.valueOf(result) + propVal.toString();
            }
        }
        if (Strings.isBlank(answer = null)) {
            answer = String.valueOf(result) + this.getId();
        }
        if (Strings.isBlank(answer) && this.getUnderlyingMetaModelObject() != null) {
            answer = this.getUnderlyingMetaModelObject().getName();
        }
        if (Strings.isBlank(answer) && this.getNodeTypeId() != null) {
            answer = this.getNodeTypeId();
        }
        return answer;
    }

    public AbstractCamelModelElement getInputElement() {
        return this.inputElement;
    }

    public boolean isEndpointElement() {
        return Arrays.asList(ENDPOINT_TYPE_FROM, ENDPOINT_TYPE_TO, ENDPOINT_NODE_NAME).contains(this.getNodeTypeId());
    }

    public void setInputElement(AbstractCamelModelElement inputElement) {
        this.inputElement = inputElement;
        if (inputElement != null) {
            Node inputNode = inputElement.getXmlNode();
            Node insertPosNode = this.getNextNode(inputNode);
            if (insertPosNode != null && !this.getXmlNode().isEqualNode(insertPosNode)) {
                inputNode.getParentNode().insertBefore(this.getXmlNode(), insertPosNode);
            }
            if (insertPosNode == null) {
                inputNode.getParentNode().appendChild(inputNode);
            }
            if (this.isEndpointElement()) {
                this.checkEndpointType();
            }
        }
    }

    public void checkEndpointType() {
        if (this.isFromEndpoint() && this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getName().equalsIgnoreCase(ENDPOINT_TYPE_TO)) {
            this.switchEndpointType(ENDPOINT_TYPE_FROM);
        } else if (this.isToEndpoint() && this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getName().equalsIgnoreCase(ENDPOINT_TYPE_FROM)) {
            this.switchEndpointType(ENDPOINT_TYPE_TO);
        } else if (this.getUnderlyingMetaModelObject() == null) {
            if (this.isFromEndpoint()) {
                this.setUnderlyingMetaModelObject(this.getEipByName(ENDPOINT_TYPE_FROM));
            } else {
                this.setUnderlyingMetaModelObject(this.getEipByName(ENDPOINT_TYPE_TO));
            }
        }
    }

    private void switchEndpointType(String newEndpointType) {
        this.setUnderlyingMetaModelObject(this.getEipByName(newEndpointType));
        Node xmlNodeToReplace = this.getXmlNode();
        if (xmlNodeToReplace != null) {
            Element newNode = this.createElement(newEndpointType, this.determineNSPrefixFromParent());
            Node parentXmlNode = this.getParent().getXmlNode();
            if (xmlNodeToReplace.getParentNode() != null) {
                parentXmlNode.replaceChild(newNode, xmlNodeToReplace);
            } else {
                parentXmlNode.appendChild(newNode);
            }
            this.setXmlNode(newNode);
            this.updateXMLNode();
        }
    }

    private String determineNSPrefixFromParent() {
        return this.parent != null && this.parent.getXmlNode() != null ? this.parent.getXmlNode().getPrefix() : null;
    }

    public void updateXMLNode() {
        for (String key : this.getParameters().keySet()) {
            Object val = this.getParameter(key);
            this.setParameter(key, val, true);
        }
    }

    public boolean isFromEndpoint() {
        return this.getInputElement() == null && this.getParent() instanceof CamelRouteElement;
    }

    public boolean isToEndpoint() {
        return this.getInputElement() != null;
    }

    public AbstractCamelModelElement getOutputElement() {
        return this.outputElement;
    }

    public void setOutputElement(AbstractCamelModelElement outputElement) {
        this.outputElement = outputElement;
        if (this.isEndpointElement()) {
            this.checkEndpointType();
        }
    }

    public List<AbstractCamelModelElement> getChildElements() {
        return this.childElements;
    }

    public void setChildElements(List<AbstractCamelModelElement> childElements) {
        this.childElements = childElements;
    }

    public void clearChildElements() {
        this.childElements.clear();
    }

    public void addChildElement(AbstractCamelModelElement element) {
        if (!this.childElements.contains(element)) {
            this.childElements.add(element);
            if (this.getNodeTypeId().equalsIgnoreCase(CHOICE_NODE_NAME) && element.getNodeTypeId().equalsIgnoreCase(OTHERWISE_NODE_NAME)) {
                this.getParameters().put(OTHERWISE_NODE_NAME, element);
            }
        }
    }

    public void removeChildElement(AbstractCamelModelElement element) {
        if (this.childElements.contains(element)) {
            this.childElements.remove(element);
            element.setParent(null);
            boolean childFound = false;
            int i = 0;
            while (i < this.getXmlNode().getChildNodes().getLength()) {
                if (this.getXmlNode().getChildNodes().item(i).isEqualNode(element.getXmlNode())) {
                    childFound = true;
                    break;
                }
                ++i;
            }
            if (childFound) {
                this.getXmlNode().removeChild(element.getXmlNode());
                this.notifyAboutDeletion(element);
            }
        }
        if (this.getNodeTypeId().equalsIgnoreCase(CHOICE_NODE_NAME) && element.getNodeTypeId().equalsIgnoreCase(OTHERWISE_NODE_NAME)) {
            this.getParameters().remove(OTHERWISE_NODE_NAME);
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void removeParameter(String name) {
        if (this.parameters.containsKey(name)) {
            Object removedItem = this.parameters.remove(name);
            if (removedItem instanceof AbstractCamelModelElement) {
                this.getXmlNode().removeChild(((AbstractCamelModelElement)removedItem).getXmlNode());
            }
            ((Element)this.getXmlNode()).removeAttribute(name);
        }
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, Object value) {
        this.setParameter(name, value, false);
    }

    private boolean shouldIgnoreParameter(String name) {
        return this instanceof CamelRouteContainerElement && this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getParameter(name) != null && NODE_KIND_ELEMENT.equalsIgnoreCase(this.getUnderlyingMetaModelObject().getParameter(name).getKind());
    }

    protected void setParameter(String name, Object value, boolean overrideChangeCheck) {
        if (this.shouldIgnoreParameter(name)) {
            return;
        }
        Object oldValue = this.parameters.get(name);
        if (!overrideChangeCheck) {
            if (oldValue == null && value == null) {
                return;
            }
            if (oldValue != null && value != null && oldValue.equals(value)) {
                return;
            }
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
            if (value != null && value.equals(oldValue)) {
                return;
            }
            if (oldValue == null && value != null && this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getParameter(name) != null && value.equals(this.getUnderlyingMetaModelObject().getParameter(name).getDefaultValue())) {
                return;
            }
        }
        this.parameters.put(name, value);
        Element e = (Element)this.getXmlNode();
        if (e == null) {
            return;
        }
        String kind = this.getKind(name);
        String javaType = this.getJavaType(name);
        if (this instanceof CamelContextElement) {
            kind = NODE_KIND_ATTRIBUTE;
        }
        if ((!CamelUtils.isCamelNamespaceElement((Node)this.getXmlNode()) || this.getEipByName(CamelUtils.getTagNameWithoutPrefix((Node)this.getXmlNode())) == null) && ID_ATTRIBUTE.equalsIgnoreCase(name)) {
            kind = NODE_KIND_ATTRIBUTE;
        }
        if (value == null || value.toString().length() < 1) {
            if (kind.equalsIgnoreCase(NODE_KIND_ATTRIBUTE) && e.hasAttribute(name)) {
                e.removeAttribute(name);
            } else if ((kind.equalsIgnoreCase(NODE_KIND_ELEMENT) || kind.equalsIgnoreCase(NODE_KIND_EXPRESSION)) && value == null) {
                int i = 0;
                while (i < e.getChildNodes().getLength()) {
                    Node subElem = e.getChildNodes().item(i);
                    if (subElem.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subElem).equals(name)) {
                        e.removeChild(subElem);
                        break;
                    }
                    ++i;
                }
            } else if (NODE_KIND_VALUE.equalsIgnoreCase(kind)) {
                e.setTextContent(null);
            }
        } else {
            if (kind == null && !(value instanceof AbstractCamelModelElement)) {
                kind = NODE_KIND_VALUE;
            }
            if (kind == null && value instanceof AbstractCamelModelElement) {
                Node oldChild = this.getFirstChild(e);
                Node newChild = ((AbstractCamelModelElement)value).getXmlNode();
                e.replaceChild(newChild, oldChild);
            } else if (NODE_KIND_ATTRIBUTE.equalsIgnoreCase(kind)) {
                this.updateAttribute(name, value, oldValue, e);
            } else if (NODE_KIND_ELEMENT.equalsIgnoreCase(kind) && "org.apache.camel.model.DataFormatDefinition".equals(javaType)) {
                this.updateDataFormatDefinition(value, e);
            } else if (NODE_KIND_ELEMENT.equalsIgnoreCase(kind) && DESCRIPTION_NODE_NAME.equals(name)) {
                this.updateElement(name, value, e);
            } else if (NODE_KIND_ELEMENT.equalsIgnoreCase(kind) && value instanceof List && !"exception".equals(name)) {
                this.updateElementList((Element)this.getXmlNode(), name, (List)value);
            } else if (NODE_KIND_EXPRESSION.equalsIgnoreCase(kind)) {
                this.updateExpression(name, value, e);
            } else if (NODE_KIND_VALUE.equalsIgnoreCase(kind)) {
                e.setTextContent(this.getMappedValue(value));
            }
        }
    }

    private void updateElementList(Element element, String nodeName, List<?> value) {
        NodeList grandChildNodes = element.getElementsByTagName(nodeName);
        HashSet<Node> nodesToRemove = new HashSet<Node>();
        int i = 0;
        while (i < grandChildNodes.getLength()) {
            Node grandChildNode = grandChildNodes.item(i);
            nodesToRemove.add(grandChildNode);
            ++i;
        }
        for (Node nodeToRemove : nodesToRemove) {
            nodeToRemove.getParentNode().removeChild(nodeToRemove);
        }
        for (Object childInTheList : value) {
            Element grandChild = this.createElement(nodeName, this.determineNSPrefixFromParent());
            grandChild.setTextContent(childInTheList.toString());
            element.appendChild(grandChild);
        }
    }

    private String getJavaType(String name) {
        if (this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getParameter(name) != null) {
            return this.getUnderlyingMetaModelObject().getParameter(name).getJavaType();
        }
        return null;
    }

    public String getKind(String name) {
        if (this.getUnderlyingMetaModelObject() != null && this.getUnderlyingMetaModelObject().getParameter(name) != null) {
            return this.getUnderlyingMetaModelObject().getParameter(name).getKind();
        }
        return null;
    }

    private void updateExpression(String name, Object value, Element e) {
        Eip subEip;
        AbstractCamelModelElement exp = null;
        if (value instanceof AbstractCamelModelElement) {
            exp = (AbstractCamelModelElement)value;
        }
        if ((subEip = this.getEipByName(exp.getNodeTypeId())) != null) {
            boolean createSubNode = true;
            Node subNode = null;
            String comparedNodeName = name.equals(NODE_KIND_EXPRESSION) ? exp.getNodeTypeId() : name;
            int c = 0;
            while (c < e.getChildNodes().getLength()) {
                subNode = e.getChildNodes().item(c);
                if (subNode.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subNode).equals(comparedNodeName)) {
                    createSubNode = false;
                    break;
                }
                ++c;
            }
            if (createSubNode) {
                subNode = this.createElement(comparedNodeName, this.determineNSPrefixFromParent());
                e.appendChild(subNode);
                if (!NODE_KIND_EXPRESSION.equals(comparedNodeName)) {
                    Element subSubNode = this.createElement(exp.getNodeTypeId(), this.determineNSPrefixFromParent());
                    subNode.appendChild(subSubNode);
                    subNode = subSubNode;
                }
            }
            int i = 0;
            while (i < ((Element)subNode).getAttributes().getLength()) {
                Node attrNode = ((Element)subNode).getAttributes().item(i);
                ((Element)subNode).removeAttribute(CamelUtils.getTagNameWithoutPrefix((Node)attrNode));
                ++i;
            }
            for (String pKey : exp.getParameters().keySet()) {
                Object oValue = exp.getParameter(pKey);
                if (NODE_KIND_VALUE.equalsIgnoreCase(subEip.getParameter(pKey).getKind())) {
                    if (oValue == null || oValue.toString().trim().length() <= 0) continue;
                    ((Element)subNode).setNodeValue(oValue.toString());
                    continue;
                }
                if (oValue == null || oValue.toString().trim().length() <= 0) continue;
                ((Element)subNode).setAttribute(pKey, oValue.toString());
            }
        } else {
            Node oldChild = null;
            int i = 0;
            while (i < e.getChildNodes().getLength()) {
                if (e.getChildNodes().item(i).getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)e.getChildNodes().item(i)).equals(name)) {
                    oldChild = e.getChildNodes().item(i);
                    break;
                }
                ++i;
            }
            Node newChild = ((AbstractCamelModelElement)value).getXmlNode();
            e.replaceChild(newChild, oldChild);
        }
    }

    private void updateDataFormatDefinition(Object value, Element e) {
        Eip subEip;
        AbstractCamelModelElement df = null;
        if (value instanceof AbstractCamelModelElement) {
            df = (AbstractCamelModelElement)value;
        }
        if ((subEip = this.getEipByName(df.getNodeTypeId())) != null) {
            boolean createSubNode = true;
            Node subNode = null;
            int c = 0;
            while (c < e.getChildNodes().getLength()) {
                subNode = e.getChildNodes().item(c);
                if (subNode.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subNode).equals(df.getNodeTypeId())) {
                    createSubNode = false;
                    break;
                }
                ++c;
            }
            if (createSubNode) {
                subNode = this.createElement(df.getNodeTypeId(), this.determineNSPrefixFromParent());
                e.appendChild(subNode);
            }
            int i = 0;
            while (i < ((Element)subNode).getAttributes().getLength()) {
                Node attrNode = ((Element)subNode).getAttributes().item(i);
                ((Element)subNode).removeAttribute(CamelUtils.getTagNameWithoutPrefix((Node)attrNode));
                ++i;
            }
            for (String pKey : df.getParameters().keySet()) {
                Object oValue = df.getParameter(pKey);
                Parameter subEipParameter = subEip.getParameter(pKey);
                if (oValue == null || oValue.toString().trim().length() <= 0) continue;
                if (NODE_KIND_VALUE.equalsIgnoreCase(subEipParameter.getKind())) {
                    ((Element)subNode).setNodeValue(oValue.toString());
                    continue;
                }
                if (this.isElementKind(subEipParameter) && this.isArrayType(subEipParameter) && oValue instanceof List) {
                    this.updateElementList((Element)subNode, pKey, (List)oValue);
                    continue;
                }
                ((Element)subNode).setAttribute(pKey, oValue.toString());
            }
        }
    }

    private void updateElement(String name, Object value, Element e) {
        Eip subEip = this.getEipByName(name);
        if (subEip != null) {
            boolean createSubNode = true;
            Node subNode = null;
            int c = 0;
            while (c < e.getChildNodes().getLength()) {
                subNode = e.getChildNodes().item(c);
                if (subNode.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subNode).equals(name)) {
                    createSubNode = false;
                    break;
                }
                ++c;
            }
            if (createSubNode) {
                subNode = this.createElement(name, this.determineNSPrefixFromParent());
                e.appendChild(subNode);
            }
            subNode.setTextContent(this.getMappedValue(value));
        }
    }

    private void updateAttribute(String name, Object newValue, Object oldValue, Element e) {
        String defaultValue;
        String string = defaultValue = this.underlyingMetaModelObject != null && this.underlyingMetaModelObject.getParameter(name) != null ? this.underlyingMetaModelObject.getParameter(name).getDefaultValue() : null;
        if (defaultValue != null && defaultValue.equals(this.getMappedValue(newValue)) && AbstractCamelModelElement.useOptimizedXML()) {
            e.removeAttribute(name);
        } else {
            e.setAttribute(name, this.getMappedValue(newValue));
            if (ID_ATTRIBUTE.equals(name) && oldValue != null && !oldValue.equals(newValue)) {
                IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
                HashMap<String, Object> eventMap = new HashMap<String, Object>();
                eventMap.put(PROPERTY_KEY_OLD_ID, oldValue);
                eventMap.put(PROPERTY_KEY_NEW_ID, newValue);
                eventMap.put(PROPERTY_KEY_CAMEL_FILE, this.getCamelFile());
                eventBroker.send(TOPIC_ID_RENAMING, eventMap);
            }
        }
    }

    public Node getXmlNode() {
        return this.xmlNode;
    }

    public void setXmlNode(Node xmlNode) {
        this.xmlNode = xmlNode;
    }

    public boolean hasUnderlyingXmlNode() {
        return this.xmlNode != null;
    }

    public Eip getUnderlyingMetaModelObject() {
        return this.underlyingMetaModelObject;
    }

    public void setUnderlyingMetaModelObject(Eip underlyingMetaModelObject) {
        this.underlyingMetaModelObject = underlyingMetaModelObject;
    }

    public void initialize() {
        if (this.xmlNode != null) {
            this.parseNode();
        }
    }

    protected void parseNode() {
        if (this.shouldParseNode()) {
            this.parseAttributes();
            this.parseChildren();
            this.linkChildrenToAttributes();
        }
    }

    protected boolean shouldParseNode() {
        return true;
    }

    protected void parseAttributes() {
        String nodename = this.getTagNameWithoutPrefix();
        Eip eip = this.getEipByName(nodename);
        if (eip != null) {
            for (Parameter param : eip.getParameters()) {
                if (this.isAttributeKind(param)) {
                    this.parseAttributeKindAttribute(param);
                    continue;
                }
                if (this.isElementKind(param)) {
                    if (this.isDataFormatDefinition(param)) {
                        this.parseDataFormatElementAttribute(param);
                        continue;
                    }
                    if (this.isRedeliveryPolicy(param)) {
                        this.parseRedeliveryPolicyElementAttribute(param);
                        continue;
                    }
                    this.parseBasicElementAttribute(param);
                    continue;
                }
                if (NODE_KIND_VALUE.equalsIgnoreCase(param.getKind())) {
                    this.parseValueAttribute(param);
                    continue;
                }
                if (!this.isAnExpressionGuessedByKind(param)) continue;
                this.parseExpressionKindAttribute(param);
            }
        } else {
            CamelModelServiceCoreActivator.pluginLog().logWarning("ParseAttributes: Unsupported EIP will be ignored: " + nodename);
        }
    }

    private void parseBasicElementAttribute(Parameter param) {
        if (this.isArrayType(param)) {
            this.parseNotDataFormatElementArrayElementAttribute(param);
        } else {
            this.parseNotDataFormatElementSimpleElementAttribute(param);
        }
    }

    private void parseNotDataFormatElementSimpleElementAttribute(Parameter param) {
        String val;
        NodeList childNodes = this.getXmlNode().getChildNodes();
        Node descNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node subNode = childNodes.item(i);
            if (subNode.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subNode).equals(param.getName())) {
                descNode = subNode;
                break;
            }
            ++i;
        }
        if (descNode != null && (val = descNode.getTextContent()) != null) {
            this.setParameter(param.getName(), val);
            if (DESCRIPTION_NODE_NAME.equalsIgnoreCase(param.getName())) {
                this.setDescription(val);
            }
        }
    }

    private void parseNotDataFormatElementArrayElementAttribute(Parameter param) {
        NodeList childNodes = this.getXmlNode().getChildNodes();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < childNodes.getLength()) {
            String val;
            Node subNode = childNodes.item(i);
            if (subNode.getNodeType() == 1 && CamelUtils.getTagNameWithoutPrefix((Node)subNode).equals(param.getName()) && (val = subNode.getTextContent()) != null && !val.trim().isEmpty() && !list.contains(val)) {
                list.add(val);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            this.setParameter(param.getName(), list);
        }
    }

    private void parseAttributeKindAttribute(Parameter param) {
        Node tmp = this.getXmlNode().getAttributes().getNamedItem(param.getName());
        if (tmp != null) {
            this.setParameter(param.getName(), tmp.getNodeValue());
        }
    }

    private void parseValueAttribute(Parameter param) {
        String val = this.getXmlNode().getTextContent();
        if (val != null) {
            this.setParameter(param.getName(), val);
            if (DESCRIPTION_NODE_NAME.equalsIgnoreCase(param.getName())) {
                this.setDescription(val);
            }
        }
    }

    private void parseDataFormatElementAttribute(Parameter param) {
        NodeList childNodes = this.getXmlNode().getChildNodes();
        String[] dfs = param.getOneOf();
        ArrayList<String> dfList = new ArrayList<String>(Arrays.asList(dfs));
        int i = 0;
        while (i < childNodes.getLength()) {
            Node subNode = childNodes.item(i);
            if (subNode.getNodeType() == 1 && dfList.contains(CamelUtils.getTagNameWithoutPrefix((Node)subNode))) {
                CamelBasicModelElement dfNode = new CamelBasicModelElement(this, subNode);
                dfNode.initialize();
                this.setParameter(param.getName(), dfNode);
            }
            ++i;
        }
    }

    private void parseRedeliveryPolicyElementAttribute(Parameter param) {
        NodeList childNodes = this.getXmlNode().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node subNode = childNodes.item(i);
            if (subNode.getNodeType() == 1) {
                CamelBasicModelElement redeliveryPolicyNode = new CamelBasicModelElement(this, subNode);
                redeliveryPolicyNode.initialize();
                this.setParameter(param.getName(), redeliveryPolicyNode);
            }
            ++i;
        }
    }

    private void parseExpressionKindAttribute(Parameter param) {
        NodeList childNodes = this.getXmlNode().getChildNodes();
        List<String> langList = Arrays.asList(param.getOneOf());
        int i = 0;
        while (i < childNodes.getLength()) {
            Node subNode = childNodes.item(i);
            if (subNode.getNodeType() == 1) {
                CamelBasicModelElement expNode;
                if (subNode != null && this.isAnExpressionGuessedByName(param) && langList.contains(CamelUtils.getTagNameWithoutPrefix((Node)subNode))) {
                    expNode = new CamelBasicModelElement(this, subNode);
                    expNode.initialize();
                    this.setParameter(param.getName(), expNode);
                } else if (subNode != null && !this.isAnExpressionGuessedByName(param) && param.getName().equals(CamelUtils.getTagNameWithoutPrefix((Node)subNode))) {
                    int x = 0;
                    while (x < subNode.getChildNodes().getLength()) {
                        Node subExpNode = subNode.getChildNodes().item(x);
                        if (subExpNode.getNodeType() == 1 && subExpNode != null && langList.contains(CamelUtils.getTagNameWithoutPrefix((Node)subExpNode))) {
                            CamelBasicModelElement expContainer = new CamelBasicModelElement(this, subNode);
                            expNode = new CamelBasicModelElement(expContainer, subExpNode);
                            expNode.initialize();
                            expContainer.setParameter(NODE_KIND_EXPRESSION, expNode);
                            this.setParameter(param.getName(), expContainer);
                            break;
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
    }

    private boolean isAnExpressionGuessedByKind(Parameter param) {
        return NODE_KIND_EXPRESSION.equalsIgnoreCase(param.getKind());
    }

    private boolean isAnExpressionGuessedByName(Parameter param) {
        return NODE_KIND_EXPRESSION.equals(param.getName());
    }

    private boolean isArrayType(Parameter param) {
        return "array".equalsIgnoreCase(param.getType());
    }

    public boolean isElementKind(Parameter param) {
        return NODE_KIND_ELEMENT.equalsIgnoreCase(param.getKind());
    }

    private boolean isAttributeKind(Parameter param) {
        return NODE_KIND_ATTRIBUTE.equalsIgnoreCase(param.getKind());
    }

    public boolean isDataFormatDefinition(Parameter param) {
        return "org.apache.camel.model.DataFormatDefinition".equalsIgnoreCase(param.getJavaType());
    }

    private boolean isRedeliveryPolicy(Parameter param) {
        return "redeliveryPolicy".equals(param.getName());
    }

    public Eip getEipByName(String name) {
        IProject project = this.getCamelFile() != null && this.getCamelFile().getResource() != null ? this.getCamelFile().getResource().getProject() : null;
        CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
        Eip eip = model.getEip(name);
        if (eip == null && ENDPOINT_NODE_NAME.equals(name)) {
            eip = model.getEip(ENDPOINT_TYPE_TO);
        }
        return eip;
    }

    protected boolean hasChildren(String name) {
        Eip eip = this.getEipByName(name);
        if (eip != null) {
            for (Parameter p : eip.getParameters()) {
                if (!this.isElementKind(p) || !this.isArrayType(p) || "exception".equals(p.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasSpecialHandling(String name) {
        Eip eip = this.getEipByName(name);
        if (eip != null) {
            return CHOICE_NODE_NAME.equalsIgnoreCase(eip.getName());
        }
        return false;
    }

    protected void parseChildren() {
        boolean canHaveChildren;
        String nodeName = this.getTagNameWithoutPrefix();
        boolean bl = canHaveChildren = this.hasChildren(nodeName) || this.hasSpecialHandling(nodeName);
        if (canHaveChildren) {
            NodeList children = this.getXmlNode().getChildNodes();
            CamelBasicModelElement lastNode = null;
            int i = 0;
            while (i < children.getLength()) {
                Node tmp = children.item(i);
                if (tmp.getNodeType() == 1 && !this.isUsedAsAttribute(tmp)) {
                    CamelBasicModelElement cme = new CamelBasicModelElement(this, tmp);
                    this.addChildElement(cme);
                    cme.initialize();
                    boolean createLink = lastNode != null && !CHOICE_NODE_NAME.equals(this.getNodeTypeId());
                    cme.setParent(this);
                    if (createLink) {
                        cme.setInputElement(lastNode);
                        lastNode.setOutputElement(cme);
                    }
                    lastNode = cme;
                }
                ++i;
            }
        }
    }

    protected boolean isSpecialCase(Node childNode) {
        return CHOICE_NODE_NAME.equalsIgnoreCase(this.getTagNameWithoutPrefix()) && OTHERWISE_NODE_NAME.equalsIgnoreCase(CamelUtils.getTagNameWithoutPrefix((Node)childNode));
    }

    protected boolean isUsedAsAttribute(Node childNode) {
        String nodeName = CamelUtils.getTagNameWithoutPrefix((Node)childNode);
        if (this.isSpecialCase(childNode)) {
            return false;
        }
        if (this.getUnderlyingMetaModelObject() != null) {
            for (Parameter p : this.getUnderlyingMetaModelObject().getParameters()) {
                List<String> langs;
                if (p.getName().equals(nodeName)) {
                    return true;
                }
                if (!NODE_KIND_EXPRESSION.equals(p.getKind()) || !(langs = Arrays.asList(p.getOneOf())).contains(nodeName)) continue;
                return true;
            }
        }
        return false;
    }

    protected void linkChildrenToAttributes() {
        if (this.getUnderlyingMetaModelObject() == null) {
            return;
        }
        for (Parameter p : this.getUnderlyingMetaModelObject().getParameters()) {
            if (!this.isAnExpressionGuessedByKind(p) && !this.isElementKind(p)) continue;
            for (AbstractCamelModelElement child : this.getChildElements()) {
                if (!child.getNodeTypeId().equalsIgnoreCase(p.getName()) || !"object".equalsIgnoreCase(p.getType())) continue;
                this.parameters.put(p.getName(), child);
            }
        }
    }

    protected String getMappedValue(Object value) {
        return value.toString();
    }

    protected void clearAttributes() {
        NamedNodeMap attribs = this.getXmlNode().getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attr = attribs.item(i);
            if (attr != null) {
                this.getXmlNode().getAttributes().removeNamedItem(CamelUtils.getTagNameWithoutPrefix((Node)attr));
            }
            ++i;
        }
    }

    public String getIconName() {
        if (this.isEndpointElement()) {
            String u = (String)this.getParameter(URI_PARAMETER_KEY);
            if (u != null && u.trim().length() > 0) {
                if (u.startsWith("ref:")) {
                    String refId = u.substring(u.indexOf(58) + 1);
                    CamelRouteContainerElement container = this.getRouteContainer();
                    if (container instanceof CamelContextElement) {
                        AbstractCamelModelElement endpointRef = ((CamelContextElement)container).getEndpointDefinitions().get(refId);
                        if (endpointRef != null) {
                            String refUri = (String)endpointRef.getParameter(URI_PARAMETER_KEY);
                            if (refUri != null && refUri.contains(":")) {
                                return refUri.substring(0, refUri.indexOf(58));
                            }
                            return ENDPOINT_NODE_NAME;
                        }
                    } else {
                        CamelModelServiceCoreActivator.pluginLog().logWarning("ref: notation not supported for " + container.getNodeTypeId());
                    }
                } else if (u.indexOf(58) != -1) {
                    return u.substring(0, u.indexOf(58));
                }
            }
            return ENDPOINT_NODE_NAME;
        }
        return this.getNodeTypeId();
    }

    public String getNodeTypeId() {
        return this.underlyingMetaModelObject != null ? this.underlyingMetaModelObject.getName() : (this.xmlNode != null ? CamelUtils.getTagNameWithoutPrefix((Node)this.xmlNode) : CAMEL_CONTEXT_NODE_NAME);
    }

    public String getDocumentationFileName() {
        if (this.isEndpointElement()) {
            return ENDPOINT_NODE_NAME;
        }
        return String.format("%sEIP", this.getNodeTypeId());
    }

    public CamelFile getCamelFile() {
        if (this.cf == null) {
            AbstractCamelModelElement tmp = this;
            while (tmp.getParent() != null && !(tmp.getParent() instanceof CamelFile)) {
                tmp = tmp.getParent();
            }
            if (tmp.getParent() != null && tmp.getParent() instanceof CamelFile) {
                this.cf = (CamelFile)tmp.getParent();
            }
        }
        return this.cf;
    }

    public CamelRouteContainerElement getRouteContainer() {
        if (this.container == null) {
            AbstractCamelModelElement tmp = this;
            while (tmp.getParent() != null && !(tmp.getParent() instanceof CamelRouteContainerElement)) {
                tmp = tmp.getParent();
            }
            if (tmp.getParent() != null && tmp.getParent() instanceof CamelRouteContainerElement) {
                this.container = (CamelRouteContainerElement)tmp.getParent();
            }
        }
        return this.container;
    }

    public String getNewID() {
        int i = 1;
        String answer = String.format("_%s%d", this.getNodeTypeId(), i++);
        while (!this.getRouteContainer().isNewIDAvailable(answer)) {
            answer = String.format("_%s%d", this.getNodeTypeId(), i++);
        }
        return answer;
    }

    public boolean isIDUnique(String id) {
        if (id == null || id.trim().length() < 1) {
            return false;
        }
        return this.getRouteContainer().findAllNodesWithId(id).size() <= 1;
    }

    public boolean isNewIDAvailable(String newId) {
        if (newId == null || newId.trim().isEmpty()) {
            return false;
        }
        return this.getRouteContainer() == null || this.getRouteContainer().findNode(newId) == null;
    }

    public AbstractCamelModelElement findNode(String nodeId) {
        if (this.getId() != null && this.getId().equals(nodeId)) {
            return this;
        }
        if (this instanceof CamelContextElement) {
            CamelContextElement ctx = (CamelContextElement)this;
            if (ctx.getDataformats().containsKey(nodeId)) {
                return ctx.getDataformats().get(nodeId);
            }
            if (ctx.getEndpointDefinitions().containsKey(nodeId)) {
                return ctx.getEndpointDefinitions().get(nodeId);
            }
        }
        if (this.getChildElements() != null) {
            for (AbstractCamelModelElement e : this.getChildElements()) {
                AbstractCamelModelElement cme = e.findNode(nodeId);
                if (cme == null) continue;
                return cme;
            }
        }
        return null;
    }

    public List<AbstractCamelModelElement> findAllNodesWithId(String nodeId) {
        ArrayList<AbstractCamelModelElement> result = new ArrayList<AbstractCamelModelElement>();
        if (this.getId() != null && this.getId().equals(nodeId)) {
            result.add(this);
        }
        if (this.getChildElements() != null) {
            for (AbstractCamelModelElement e : this.getChildElements()) {
                result.addAll(e.findAllNodesWithId(nodeId));
            }
        }
        return result;
    }

    public boolean isFirstNodeInRoute() {
        return this.getInputElement() == null && this.getParent() instanceof CamelRouteElement;
    }

    public boolean supportsBreakpoint() {
        return !this.isFirstNodeInRoute() && !WHEN_NODE_NAME.equals(this.getNodeTypeId()) && !OTHERWISE_NODE_NAME.equals(this.getNodeTypeId());
    }

    public Element createElement(String nodeTypeId, String namespace) {
        String nodeName = nodeTypeId;
        if (namespace != null && namespace.trim().length() > 0) {
            nodeName = String.valueOf(namespace) + ":" + nodeTypeId;
        }
        return this.getCamelFile().getDocument().createElement(nodeName);
    }

    public String getTagNameWithoutPrefix() {
        return CamelUtils.getTagNameWithoutPrefix((Node)this.getXmlNode());
    }

    protected void notifyAboutDeletion(AbstractCamelModelElement modelElement) {
        IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (eventBroker != null) {
            eventBroker.post(TOPIC_REMOVE_CAMEL_ELEMENT, (Object)modelElement);
        }
    }
}

