/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBean;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerWithoutGlobalConfigElement;
import org.fusesource.ide.camel.model.service.core.model.CamelSchemaType;
import org.fusesource.ide.camel.model.service.core.model.GlobalDefinitionCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.ICamelModelListener;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class CamelFile
extends AbstractCamelModelElement
implements EventListener {
    public static final int XML_INDENT_VALUE = 3;
    private static final String CAMEL_CONTEXT = "camelContext";
    private static final String ROUTE_CONTEXT = "routeContext";
    public static final String CAMEL_ROUTES = "routes";
    private Map<String, GlobalDefinitionCamelModelElement> globalDefinitions = new HashMap<String, GlobalDefinitionCamelModelElement>();
    private IResource resource;
    private CamelSchemaType schemaType;
    private Document document;
    private List<ICamelModelListener> modelListeners = new ArrayList<ICamelModelListener>();

    public CamelFile(IResource resource) {
        super(null, null);
        this.resource = resource;
    }

    public void resetContents() {
        this.getGlobalDefinitions().clear();
        this.getChildElements().clear();
    }

    @Override
    public void initialize() {
        super.initialize();
        NodeList childNodes = this.document.getDocumentElement().getChildNodes();
        if (CAMEL_ROUTES.equals(CamelUtils.getTagNameWithoutPrefix((Node)this.document.getDocumentElement()))) {
            int endIdx;
            CamelRouteContainerWithoutGlobalConfigElement cre = new CamelRouteContainerWithoutGlobalConfigElement(this, this.document.getDocumentElement());
            Node namedItem = this.document.getDocumentElement().getAttributes().getNamedItem("id");
            String containerId = namedItem != null ? namedItem.getNodeValue() : String.valueOf(CamelUtils.getTagNameWithoutPrefix((Node)this.document.getDocumentElement())) + "-" + UUID.randomUUID().toString();
            int startIdx = this.resource.getFullPath().toOSString().indexOf("--");
            if (startIdx != (endIdx = this.resource.getFullPath().toOSString().indexOf("--", startIdx + 1)) && startIdx != -1) {
                containerId = this.resource.getFullPath().toOSString().substring(startIdx + 2, endIdx);
            }
            cre.setId(containerId);
            cre.initialize();
            this.addChildElement(cre);
        } else {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 1) {
                    String name = CamelUtils.getTagNameWithoutPrefix((Node)child);
                    String id = this.computeId(child);
                    if (CAMEL_CONTEXT.equals(name)) {
                        CamelContextElement cce = new CamelContextElement(this, child);
                        cce.setId(id);
                        cce.initialize();
                        this.addChildElement(cce);
                    } else if (CAMEL_ROUTES.equals(name) || ROUTE_CONTEXT.equals(name)) {
                        CamelRouteContainerWithoutGlobalConfigElement cre = new CamelRouteContainerWithoutGlobalConfigElement(this, child);
                        cre.setId(id);
                        cre.initialize();
                        this.addChildElement(cre);
                    } else if (CamelUtils.isGlobalBean((Node)child)) {
                        CamelBean cb = new CamelBean(this, child);
                        cb.setId(id);
                        cb.initialize();
                        this.addGlobalDefinition(id, cb);
                    } else {
                        GlobalDefinitionCamelModelElement cme = new GlobalDefinitionCamelModelElement(this, child);
                        cme.setId(id);
                        cme.initialize();
                        this.addGlobalDefinition(id, cme);
                    }
                }
                ++i;
            }
        }
    }

    private String computeId(Node child) {
        Node idNode = child.getAttributes().getNamedItem("id");
        if (idNode != null) {
            return idNode.getNodeValue();
        }
        if (this.ignoreNode(child)) {
            return null;
        }
        return String.valueOf(CamelUtils.getTagNameWithoutPrefix((Node)child)) + "-" + UUID.randomUUID().toString();
    }

    private boolean ignoreNode(Node child) {
        return !CamelUtils.isCamelNamespaceElement((Node)child) && !this.isSupportedGlobalType(child);
    }

    private boolean isSupportedGlobalType(Node child) {
        return "bean".equalsIgnoreCase(child.getNodeName());
    }

    public CamelFile reloadModelFromXML(String xmlString) {
        try {
            CamelIOHandler ioHandler = new CamelIOHandler();
            return ioHandler.loadCamelModel(xmlString, (IProgressMonitor)new NullProgressMonitor(), this);
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to load Camel context file from String: \n" + xmlString, (Throwable)ex);
            return null;
        }
    }

    public Map<String, GlobalDefinitionCamelModelElement> getGlobalDefinitions() {
        return this.globalDefinitions;
    }

    public void setGlobalDefinitions(Map<String, GlobalDefinitionCamelModelElement> globalDefinitions) {
        this.globalDefinitions = globalDefinitions;
    }

    public String addGlobalDefinition(String id, GlobalDefinitionCamelModelElement cme) {
        String usedId;
        if (this.globalDefinitions.containsKey(id)) {
            return id;
        }
        String string = usedId = id != null ? id : "_def" + UUID.randomUUID().toString();
        if (this.globalDefinitions.containsKey(usedId) || id == null && this.globalDefinitions.containsValue(cme)) {
            return null;
        }
        this.globalDefinitions.put(usedId, cme);
        Node parentNode = cme.getXmlNode().getParentNode();
        Element documentElement = this.getDocument().getDocumentElement();
        if (parentNode == null || !parentNode.isEqualNode(documentElement)) {
            documentElement.insertBefore(cme.getXmlNode(), documentElement.getChildNodes().item(0));
            this.fireModelChanged();
        }
        return usedId;
    }

    public String updateGlobalDefinition(String id, GlobalDefinitionCamelModelElement cme) {
        String usedId = id != null ? id : "_def" + UUID.randomUUID().toString();
        Node oldDef = this.globalDefinitions.put(usedId, cme).getXmlNode();
        Node parentNode = cme.getXmlNode().getParentNode();
        Element documentElement = this.getDocument().getDocumentElement();
        if (parentNode == null || !parentNode.isEqualNode(documentElement)) {
            documentElement.replaceChild(cme.getXmlNode(), oldDef);
            this.fireModelChanged();
        }
        return usedId;
    }

    public void removeGlobalDefinition(String id) {
        Node nodeToRemove;
        GlobalDefinitionCamelModelElement cmeToremove = this.globalDefinitions.remove(id);
        if (cmeToremove != null && (nodeToRemove = cmeToremove.getXmlNode()) != null) {
            this.getDocument().getDocumentElement().removeChild(nodeToRemove);
            this.fireModelChanged();
            this.notifyAboutDeletion(cmeToremove);
        }
    }

    public void clearGlobalDefinitions() {
        this.globalDefinitions.clear();
    }

    public CamelSchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(CamelSchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void registerDOMListener() {
        if (this.document != null && this.document.getDocumentElement() instanceof EventTarget) {
            ((EventTarget)((Object)this.document.getDocumentElement())).addEventListener("DOMSubtreeModified", this, true);
        }
    }

    public void unregisterDOMListener() {
        if (this.document != null && this.document.getDocumentElement() instanceof EventTarget) {
            ((EventTarget)((Object)this.document.getDocumentElement())).removeEventListener("DOMSubtreeModified", this, true);
        }
    }

    public boolean isBlueprint() {
        return this.schemaType != null && this.schemaType.equals((Object)CamelSchemaType.BLUEPRINT);
    }

    public boolean isSpring() {
        return this.schemaType != null && this.schemaType.equals((Object)CamelSchemaType.SPRING);
    }

    @Override
    public CamelFile getCamelFile() {
        return this;
    }

    public boolean isEmpty() {
        return this.getRouteContainer() == null && this.getChildElements().isEmpty();
    }

    public String getDocumentAsXML() {
        try {
            int lineWidth = Integer.parseInt(XMLCorePlugin.getDefault().getPluginPreferences().getString("lineWidth"));
            int indentValue = XMLCorePlugin.getDefault().getPluginPreferences().getInt("indentationSize");
            String indentChar = XMLCorePlugin.getDefault().getPluginPreferences().getString("indentationChar");
            if ("tab".equalsIgnoreCase(indentChar)) {
                int tabWidth = EditorsPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
                indentValue *= tabWidth;
            }
            Document document = this.getDocument();
            OutputFormat format = new OutputFormat(document);
            format.setIndenting(true);
            format.setIndent(indentValue);
            format.setEncoding("UTF-8");
            format.setPreserveEmptyAttributes(false);
            format.setMethod("xml");
            format.setPreserveSpace(false);
            format.setOmitComments(false);
            format.setOmitDocumentType(false);
            format.setOmitXMLDeclaration(false);
            format.setLineWidth(lineWidth);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            return ((Object)out).toString();
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to save the camel file to " + this.getResource().getFullPath().toOSString(), (Throwable)ex);
            return null;
        }
    }

    public void addModelListener(ICamelModelListener listener) {
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeModelListener(ICamelModelListener listener) {
        if (this.modelListeners.contains(listener)) {
            this.modelListeners.remove(listener);
        }
    }

    public void fireModelChanged() {
        for (ICamelModelListener listener : this.modelListeners) {
            if (listener == null) continue;
            listener.modelChanged();
        }
    }

    @Override
    public CamelRouteContainerElement getRouteContainer() {
        for (AbstractCamelModelElement e : this.getChildElements()) {
            if (!(e instanceof CamelRouteContainerElement)) continue;
            return (CamelRouteContainerElement)e;
        }
        return null;
    }

    @Override
    public boolean supportsBreakpoint() {
        return false;
    }

    @Override
    public void handleEvent(Event evt) {
        this.fireModelChanged();
    }

    public CamelModel getCamelModel() {
        return CamelCatalogCacheManager.getInstance().getCamelModelForProject(this.resource.getProject());
    }

    @Override
    public List<AbstractCamelModelElement> findAllNodesWithId(String nodeId) {
        ArrayList<AbstractCamelModelElement> result = new ArrayList<AbstractCamelModelElement>();
        if (nodeId != null) {
            result.addAll(this.findAllGlobalelementsWithId(nodeId));
            List<AbstractCamelModelElement> superResult = super.findAllNodesWithId(nodeId);
            if (superResult != null && !superResult.isEmpty()) {
                result.addAll(superResult);
            }
        }
        return result;
    }

    private List<AbstractCamelModelElement> findAllGlobalelementsWithId(String nodeId) {
        ArrayList<AbstractCamelModelElement> result = new ArrayList<AbstractCamelModelElement>();
        if (this.getGlobalDefinitions() != null) {
            for (AbstractCamelModelElement abstractCamelModelElement : this.getGlobalDefinitions().values()) {
                if (!nodeId.equals(abstractCamelModelElement.getId())) continue;
                result.add(abstractCamelModelElement);
            }
        }
        return result;
    }
}

