/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;

public class CamelModelElementIDUtil {
    public void ensureUniqueID(AbstractCamelModelElement elem) {
        Eip underlyingMetaModelObject = elem.getUnderlyingMetaModelObject();
        if (this.isParentElementParameter(elem, underlyingMetaModelObject)) {
            return;
        }
        if (!(underlyingMetaModelObject == null && !(elem instanceof CamelContextElement) || elem.getId() != null && elem.getId().trim().length() >= 1)) {
            elem.setId(elem.getNewID());
        }
        for (AbstractCamelModelElement e : elem.getChildElements()) {
            this.ensureUniqueID(e);
        }
    }

    private boolean isParentElementParameter(AbstractCamelModelElement elem, Eip underlyingMetaModelObject) {
        AbstractCamelModelElement parentElement = elem.getParent();
        if (parentElement != null) {
            Parameter parameter;
            Eip parentUnderlyingMetaModelObject = parentElement.getUnderlyingMetaModelObject();
            String nodeName = elem.getTagNameWithoutPrefix();
            if (parentElement.getParameter(nodeName) != null && parentUnderlyingMetaModelObject != null && "element".equals((parameter = parentUnderlyingMetaModelObject.getParameter(nodeName)).getKind()) && !"otherwise".equalsIgnoreCase(underlyingMetaModelObject.getName())) {
                return true;
            }
        }
        return false;
    }
}

