/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.IFuseDetailsPropertyContributor;
import org.fusesource.ide.camel.model.service.core.util.CamelFilesFinder;
import org.w3c.dom.Node;

public class CamelRouteElement
extends AbstractCamelModelElement
implements IFuseDetailsPropertyContributor {
    private List<AbstractCamelModelElement> inputs = new ArrayList<AbstractCamelModelElement>();
    private List<AbstractCamelModelElement> outputs = new ArrayList<AbstractCamelModelElement>();

    public CamelRouteElement(AbstractCamelModelElement parent, Node underlyingNode) {
        super(parent, underlyingNode);
    }

    public CamelRouteElement(CamelContextElement camelContext, Node underlyingNode) {
        super(camelContext, underlyingNode);
    }

    @Override
    protected void parseChildren() {
        super.parseChildren();
        this.inputs.clear();
        this.outputs.clear();
        for (AbstractCamelModelElement c : this.getChildElements()) {
            if ("from".equalsIgnoreCase(c.getNodeTypeId())) {
                this.inputs.add(c);
                continue;
            }
            this.outputs.add(c);
        }
    }

    public List<AbstractCamelModelElement> getInputs() {
        return this.inputs;
    }

    public List<AbstractCamelModelElement> getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean supportsBreakpoint() {
        return false;
    }

    @Override
    public String getNewID() {
        Set<CamelFile> resolvedCamelFiles = this.findCamelFilesInSameProject();
        int i = 1;
        String answer = String.format("_%s%d", this.getNodeTypeId(), i++);
        while (!this.isNewIDAvailable(resolvedCamelFiles, answer)) {
            answer = String.format("_%s%d", this.getNodeTypeId(), i++);
        }
        return answer;
    }

    Set<CamelFile> findCamelFilesInSameProject() {
        Set<IFile> allCamelFilesInProject = new CamelFilesFinder().findFiles((IResource)this.getCamelFile().getResource().getProject());
        HashSet<CamelFile> cfSet = new HashSet<CamelFile>();
        for (IFile file : allCamelFilesInProject) {
            CamelFile cf = CamelFilesFinder.getFileFromEditor(file);
            if (cf != null) {
                cfSet.add(cf);
                continue;
            }
            cfSet.add(new CamelIOHandler().loadCamelModel((IResource)file, (IProgressMonitor)new NullProgressMonitor()));
        }
        return cfSet;
    }

    private boolean isNewIDAvailable(Set<CamelFile> resolvedCamelFiles, String answer) {
        for (CamelFile camelFile : resolvedCamelFiles) {
            if (camelFile.isNewIDAvailable(answer)) continue;
            return false;
        }
        return true;
    }
}

