/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCoordinates;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.camel.model.service.core.util.FuseBomFilter;
import org.fusesource.ide.camel.model.service.core.util.OnlineArtifactVersionSearcher;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.core.util.VersionUtil;

public class CamelCatalogUtils {
    public static final String CAMEL_TO_BOM_MAPPING_PROPERTY = "org.jboss.tools.fuse.camel2bom.url";
    public static final String CAMEL_TO_BOM_MAPPING_DEFAULT_URL = "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.properties";
    public static final String CAMEL_TO_BOM_MAPPING_URL = System.getProperty("org.jboss.tools.fuse.camel2bom.url", "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.properties");
    public static final String CAMEL_TO_BOM_MAPPING_FUSE_7_PROPERTY = "org.jboss.tools.fuse.camel2bom.fuse7.url";
    public static final String CAMEL_TO_BOM_MAPPING_FUSE_7_DEFAULT_URL = "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.fuse7.properties";
    public static final String CAMEL_TO_BOM_MAPPING_URL_FUSE_7 = System.getProperty("org.jboss.tools.fuse.camel2bom.fuse7.url", "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.fuse7.properties");
    public static final String CAMEL_TO_BOM_MAPPING_FUSE_7_WILDFLY_PROPERTY = "org.jboss.tools.fuse.camel2bom.fuse7wildfly.url";
    public static final String CAMEL_TO_BOM_MAPPING_FUSE_7_WILDFLY_DEFAULT_URL = "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.fuse7wildfly.properties";
    public static final String CAMEL_TO_BOM_MAPPING_URL_FUSE_7_WILDFLY = System.getProperty("org.jboss.tools.fuse.camel2bom.fuse7wildfly.url", "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/camel2bom.fuse7wildfly.properties");
    public static final String FISBOM_TOFABRIC8MAVENPLUGIN_MAPPING_FUSE_7_PROPERTY = "org.jboss.tools.fuse.fisbom2fabric8MavenVersion.fuse7.url";
    public static final String FISBOM_TOFABRIC8MAVENPLUGIN_MAPPING_FUSE_7_DEFAULT_URL = "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/fisBomToFabric8MavenPlugin.fuse7.properties";
    public static final String FISBOM_TOFABRIC8MAVENPLUGIN_URL_MAPPING_FUSE_7 = System.getProperty("org.jboss.tools.fuse.fisbom2fabric8MavenVersion.fuse7.url", "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/fisBomToFabric8MavenPlugin.fuse7.properties");
    public static final String FIS_MAPPING_PROPERTY = "org.jboss.tools.fuse.fismarker.url";
    public static final String FIS_MAPPING_DEFAULT_URL = "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/fismarker.properties";
    public static final String FIS_MAPPING_URL = System.getProperty("org.jboss.tools.fuse.fismarker.url", "https://raw.githubusercontent.com/jbosstools/jbosstools-fuse/master/configuration/fismarker.properties");
    public static final String KEY_CAMEL_TEST_VERSIONS = "FUSE_TOOLING_CAMEL_TEST_VERSIONS";
    private static final String FUSE_621_R0_CAMEL_VERSION = "2.15.1.redhat-621084";
    private static final String FUSE_621_R1_CAMEL_VERSION = "2.15.1.redhat-621090";
    private static final String FUSE_621_R2_CAMEL_VERSION = "2.15.1.redhat-621107";
    private static final String FUSE_621_R3_CAMEL_VERSION = "2.15.1.redhat-621117";
    private static final String FUSE_621_R4_CAMEL_VERSION = "2.15.1.redhat-621159";
    private static final String FUSE_621_R5_CAMEL_VERSION = "2.15.1.redhat-621169";
    private static final String FUSE_621_R6_CAMEL_VERSION = "2.15.1.redhat-621177";
    private static final String FUSE_621_R7_CAMEL_VERSION = "2.15.1.redhat-621186";
    private static final String FUSE_621_R8_CAMEL_VERSION = "2.15.1.redhat-621195";
    private static final String FUSE_621_R9_CAMEL_VERSION = "2.15.1.redhat-621216";
    private static final String FUSE_621_R0_BOM_VERSION = "6.2.1.redhat-084";
    private static final String FUSE_621_R1_BOM_VERSION = "6.2.1.redhat-090";
    private static final String FUSE_621_R2_BOM_VERSION = "6.2.1.redhat-107";
    private static final String FUSE_621_R3_BOM_VERSION = "6.2.1.redhat-117";
    private static final String FUSE_621_R4_BOM_VERSION = "6.2.1.redhat-159";
    private static final String FUSE_621_R5_BOM_VERSION = "6.2.1.redhat-169";
    private static final String FUSE_621_R6_BOM_VERSION = "6.2.1.redhat-177";
    private static final String FUSE_621_R7_BOM_VERSION = "6.2.1.redhat-186";
    private static final String FUSE_621_R8_BOM_VERSION = "6.2.1.redhat-195";
    private static final String FUSE_621_R9_BOM_VERSION = "6.2.1.redhat-216";
    private static final String FUSE_63_R0_CAMEL_VERSION = "2.17.0.redhat-630187";
    private static final String FUSE_63_R1_CAMEL_VERSION = "2.17.0.redhat-630224";
    private static final String FUSE_63_R2_CAMEL_VERSION = "2.17.0.redhat-630254";
    private static final String FUSE_63_R3_CAMEL_VERSION = "2.17.0.redhat-630262";
    public static final String FUSE_63_R4_CAMEL_VERSION = "2.17.0.redhat-630283";
    public static final String FUSE_63_R5_CAMEL_VERSION = "2.17.0.redhat-630310";
    private static final String FUSE_63_R0_BOM_VERSION = "6.3.0.redhat-187";
    private static final String FUSE_63_R1_BOM_VERSION = "6.3.0.redhat-224";
    private static final String FUSE_63_R2_BOM_VERSION = "6.3.0.redhat-254";
    private static final String FUSE_63_R3_BOM_VERSION = "6.3.0.redhat-262";
    static final String FUSE_63_R4_BOM_VERSION = "6.3.0.redhat-283";
    static final String FUSE_63_R5_BOM_VERSION = "6.3.0.redhat-310";
    public static final String FIS_20_R1_CAMEL_VERSION = "2.18.1.redhat-000012";
    public static final String FIS_20_R2_CAMEL_VERSION = "2.18.1.redhat-000015";
    public static final String FIS_20_R3_CAMEL_VERSION = "2.18.1.redhat-000021";
    public static final String DEFAULT_CAMEL_VERSION = "2.18.1.redhat-000021";
    public static final String CAMEL_SPRING_BOOT_STARTER = "camel-spring-boot-starter";
    public static final String CAMEL_WILDFLY = "org.wildfly.camel";
    public static final String CAMEL_VERSION_LATEST_COMMUNITY = "2.20.1";
    public static final String CAMEL_VERSION_LATEST_PRODUCTIZED_62 = "2.15.1.redhat-621216";
    public static final String CAMEL_VERSION_LATEST_PRODUCTIZED_63 = "2.17.0.redhat-630310";
    public static final String CAMEL_VERSION_LATEST_FIS_20 = "2.18.1.redhat-000021";
    public static final String RUNTIME_PROVIDER_KARAF = "karaf";
    public static final String RUNTIME_PROVIDER_SPRINGBOOT = "springboot";
    public static final String RUNTIME_PROVIDER_WILDFLY = "wildfly";
    public static final String CATALOG_CAMEL_ARTIFACTID = "camel-catalog";
    public static final String CATALOG_KARAF_GROUPID = "org.apache.camel";
    public static final String CATALOG_KARAF_ARTIFACTID = "camel-catalog-provider-karaf";
    public static final String CATALOG_SPRINGBOOT_GROUPID = "org.apache.camel";
    public static final String CATALOG_SPRINGBOOT_ARTIFACTID = "camel-catalog-provider-springboot";
    public static final String CATALOG_WILDFLY_GROUPID = "org.wildfly.camel";
    public static final String CATALOG_WILDFLY_ARTIFACTID = "wildfly-camel-catalog";
    public static final String GAV_KEY_GROUPID = "groupId";
    public static final String GAV_KEY_ARTIFACTID = "artifactId";
    public static final String GAV_KEY_VERSION = "version";
    private static final List<String> OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS;
    private static final List<String> ALL_CAMEL_CATALOG_VERSIONS;
    private static final List<String> TEST_CAMEL_VERSIONS;
    static final Map<String, String> CAMEL_VERSION_2_FUSE_6_BOM_MAPPING;
    static final Map<String, String> CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING;
    static final Map<String, String> CAMEL_VERSION_2_FUSE_7_BOM_MAPPING;
    static final Map<String, String> CAMEL_VERSION_2_FUSE_7_WILDFLY_BOM_MAPPING;
    static final Map<String, String> FISBOM_TO_FABRIC8MAVENPLUGIN_MAPPING;

    static {
        CAMEL_VERSION_2_FUSE_6_BOM_MAPPING = new HashMap<String, String>();
        CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING = new HashMap<String, String>();
        CAMEL_VERSION_2_FUSE_7_BOM_MAPPING = new HashMap<String, String>();
        CAMEL_VERSION_2_FUSE_7_WILDFLY_BOM_MAPPING = new HashMap<String, String>();
        ALL_CAMEL_CATALOG_VERSIONS = new ArrayList<String>();
        OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS = new ArrayList<String>();
        TEST_CAMEL_VERSIONS = new ArrayList<String>();
        FISBOM_TO_FABRIC8MAVENPLUGIN_MAPPING = new HashMap<String, String>();
        try {
            CamelCatalogUtils.createMappingFromOnlineFiles(CAMEL_VERSION_2_FUSE_6_BOM_MAPPING, CAMEL_TO_BOM_MAPPING_URL);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to retrieve the Camel Version -> BOM Version mappings for Fuse 6.x from online repo. Falling back to defaults.", (Throwable)ex);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R0_CAMEL_VERSION, FUSE_621_R0_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R1_CAMEL_VERSION, FUSE_621_R1_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R2_CAMEL_VERSION, FUSE_621_R2_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R3_CAMEL_VERSION, FUSE_621_R3_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R4_CAMEL_VERSION, FUSE_621_R4_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R5_CAMEL_VERSION, FUSE_621_R5_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R6_CAMEL_VERSION, FUSE_621_R6_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R7_CAMEL_VERSION, FUSE_621_R7_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_621_R8_CAMEL_VERSION, FUSE_621_R8_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put("2.15.1.redhat-621216", FUSE_621_R9_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_63_R0_CAMEL_VERSION, FUSE_63_R0_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_63_R1_CAMEL_VERSION, FUSE_63_R1_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_63_R2_CAMEL_VERSION, FUSE_63_R2_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_63_R3_CAMEL_VERSION, FUSE_63_R3_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put(FUSE_63_R4_CAMEL_VERSION, FUSE_63_R4_BOM_VERSION);
            CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.put("2.17.0.redhat-630310", FUSE_63_R5_BOM_VERSION);
            OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS.addAll(CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.keySet());
        }
        try {
            CamelCatalogUtils.createMappingFromOnlineFiles(CAMEL_VERSION_2_FUSE_7_BOM_MAPPING, CAMEL_TO_BOM_MAPPING_URL_FUSE_7);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to retrieve the Camel Version -> BOM Version mappings for Fuse 7.x from online repo. Falling back to defaults.", (Throwable)ex);
        }
        try {
            CamelCatalogUtils.createMappingFromOnlineFiles(CAMEL_VERSION_2_FUSE_7_WILDFLY_BOM_MAPPING, CAMEL_TO_BOM_MAPPING_URL_FUSE_7_WILDFLY);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to retrieve the Camel Version -> BOM Version mappings for Fuse 7.x on Wildfly from online repo. Falling back to defaults.", (Throwable)ex);
        }
        try {
            CamelCatalogUtils.createMappingFromOnlineFiles(FISBOM_TO_FABRIC8MAVENPLUGIN_MAPPING, FISBOM_TOFABRIC8MAVENPLUGIN_URL_MAPPING_FUSE_7);
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to retrieve the FIS bom Version -> Farbic8 Maven Plugin Version mappings for Fuse 7.x from online repo. Falling back to defaults.", (Throwable)ex);
        }
        try {
            Properties fisMapping = new Properties();
            URL url = new URL(FIS_MAPPING_URL);
            fisMapping.load(url.openStream());
            for (String camelVersion : fisMapping.stringPropertyNames()) {
                String bomVersion = fisMapping.getProperty(camelVersion);
                CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.put(camelVersion, bomVersion);
            }
        }
        catch (IOException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to retrieve the FIS-ONLY Camel Versions list from online repo. Falling back to defaults.", (Throwable)ex);
            CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.put(FIS_20_R1_CAMEL_VERSION, "2.2.170.redhat-000010");
            CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.put(FIS_20_R2_CAMEL_VERSION, "2.2.170.redhat-000013");
            CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.put("2.18.1.redhat-000021", "2.2.170.redhat-000019");
        }
        CamelCatalogUtils.initCamelVersionToTest();
        ALL_CAMEL_CATALOG_VERSIONS.addAll(CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.keySet());
        ALL_CAMEL_CATALOG_VERSIONS.addAll(OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS);
    }

    protected static void initCamelVersionToTest() {
        String camelVersionsForTesting = System.getProperty(KEY_CAMEL_TEST_VERSIONS, "").trim();
        if (camelVersionsForTesting.equalsIgnoreCase("null")) {
            camelVersionsForTesting = "";
        }
        if (!Strings.isBlank((String)camelVersionsForTesting)) {
            Arrays.stream(camelVersionsForTesting.split(",")).map(String::trim).filter(s -> !Strings.isBlank((String)s)).forEach(TEST_CAMEL_VERSIONS::add);
        } else {
            TEST_CAMEL_VERSIONS.add(CAMEL_VERSION_LATEST_COMMUNITY);
            TEST_CAMEL_VERSIONS.add("2.15.1.redhat-621216");
            TEST_CAMEL_VERSIONS.add("2.17.0.redhat-630310");
            TEST_CAMEL_VERSIONS.add("2.18.1.redhat-000021");
        }
    }

    protected static void createMappingFromOnlineFiles(Map<String, String> bomMapping, String onlineUrl) throws IOException {
        Properties vMapping = new Properties();
        URL url = new URL(onlineUrl);
        vMapping.load(url.openStream());
        for (String camelVersion : vMapping.stringPropertyNames()) {
            String bomVersion = vMapping.getProperty(camelVersion);
            bomMapping.put(camelVersion, bomVersion);
            OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS.add(camelVersion);
        }
    }

    private CamelCatalogUtils() {
    }

    public static List<String> getOfficialSupportedCamelCatalogVersions() {
        return OFFICIAL_SUPPORTED_CAMEL_CATALOG_VERSIONS;
    }

    public static List<String> getAllCamelCatalogVersions() {
        return ALL_CAMEL_CATALOG_VERSIONS;
    }

    public static List<String> getCamelVersionsToTestWith() {
        return TEST_CAMEL_VERSIONS;
    }

    public static List<String> getPureFISVersions() {
        return Arrays.asList(CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.keySet().toArray(new String[CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.size()]));
    }

    public static String getLatestCamelVersion() {
        return "2.18.1.redhat-000021";
    }

    public static String getBomVersionForCamelVersion(String camelVersion, IProject project, Model mavenModel, IProgressMonitor monitor) {
        org.apache.maven.model.Dependency fuseBomUsed = new OnlineArtifactVersionSearcher().retrieveAnyFuseBomUsed(mavenModel.getDependencyManagement());
        return CamelCatalogUtils.getBomVersionForCamelVersion(camelVersion, project, monitor, fuseBomUsed);
    }

    protected static String getBomVersionForCamelVersion(String camelVersion, IProject project, IProgressMonitor monitor, org.apache.maven.model.Dependency fuseBomUsed) {
        String bomVersion = null;
        if (fuseBomUsed != null) {
            if (CamelCatalogUtils.isBom(FuseBomFilter.BOM_FUSE_6, fuseBomUsed)) {
                bomVersion = CamelCatalogUtils.getFuse6BomVersion(camelVersion);
            } else if (CamelCatalogUtils.isBom(FuseBomFilter.BOM_FUSE_FIS, fuseBomUsed)) {
                bomVersion = CamelCatalogUtils.getFuseFISBomVersion(camelVersion, project, monitor);
            } else if (CamelCatalogUtils.isBom(FuseBomFilter.BOM_FUSE_7, fuseBomUsed)) {
                bomVersion = CamelCatalogUtils.getFuse7BomVersion(camelVersion, project, monitor);
            } else if (CamelCatalogUtils.isBom(FuseBomFilter.BOM_FUSE_7_WILDFLY, fuseBomUsed)) {
                bomVersion = CamelCatalogUtils.getFuse7WildflyBomVersion(camelVersion, project, monitor);
            }
        }
        return bomVersion;
    }

    protected static String getFuse7WildflyBomVersion(String camelVersion, IProject project, IProgressMonitor monitor) {
        if (CAMEL_VERSION_2_FUSE_7_WILDFLY_BOM_MAPPING.containsKey(camelVersion)) {
            return CAMEL_VERSION_2_FUSE_7_BOM_MAPPING.get(camelVersion);
        }
        return new OnlineArtifactVersionSearcher().findLatestBomVersionOnAvailableRepo(project, monitor);
    }

    protected static String getFuse7BomVersion(String camelVersion, IProject project, IProgressMonitor monitor) {
        if (CAMEL_VERSION_2_FUSE_7_BOM_MAPPING.containsKey(camelVersion)) {
            return CAMEL_VERSION_2_FUSE_7_BOM_MAPPING.get(camelVersion);
        }
        return new OnlineArtifactVersionSearcher().findLatestBomVersionOnAvailableRepo(project, monitor);
    }

    protected static String getFuseFISBomVersion(String camelVersion, IProject project, IProgressMonitor monitor) {
        if (CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.containsKey(camelVersion)) {
            return CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.get(camelVersion);
        }
        if (new VersionUtil().isStrictlyLowerThan2200(camelVersion)) {
            return CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.get("2.18.1.redhat-000021");
        }
        return new OnlineArtifactVersionSearcher().findLatestBomVersionOnAvailableRepo(project, monitor);
    }

    protected static String getFuse6BomVersion(String camelVersion) {
        if (CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.containsKey(camelVersion)) {
            return CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.get(camelVersion);
        }
        return CAMEL_VERSION_2_FUSE_6_BOM_MAPPING.values().stream().sorted(Comparator.reverseOrder()).findFirst().orElse(null);
    }

    private static boolean isBom(org.apache.maven.model.Dependency bom, org.apache.maven.model.Dependency fuseBomUsed) {
        return bom.getGroupId().equals(fuseBomUsed.getGroupId()) && bom.getArtifactId().equals(fuseBomUsed.getArtifactId());
    }

    public static boolean isPureFISVersion(String camelVersion) {
        return CAMEL_VERSION_2_FUSE_FIS_BOM_MAPPING.containsKey(camelVersion);
    }

    public static List<String> initializeTags(String label) {
        ArrayList<String> tags = new ArrayList<String>();
        if (label != null && label.trim().length() > 0) {
            String[] tagArray;
            String[] stringArray = tagArray = label.split(",");
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s_tag = stringArray[n2];
                tags.add(s_tag);
                ++n2;
            }
        }
        return tags;
    }

    private static boolean isValidGAV(String groupId, String artifactId, String version) {
        return !Strings.isBlank((String)groupId) && !Strings.isBlank((String)artifactId) && !Strings.isBlank((String)version);
    }

    public static CamelCatalogCoordinates getCatalogCoordinatesFor(String groupId, String artifactId, String version) {
        if (!CATALOG_CAMEL_ARTIFACTID.equals(artifactId) && CamelCatalogUtils.isCamelVersionWithoutProviderSupport(version)) {
            CamelCatalogCoordinates coord = CamelCatalogUtils.getDefaultCatalogCoordinates();
            coord.setArtifactId(CATALOG_CAMEL_ARTIFACTID);
            coord.setVersion(version);
            return coord;
        }
        return new CamelCatalogCoordinates(groupId, artifactId, version);
    }

    public static CamelCatalogCoordinates getCatalogCoordinatesFor(String runtimeProvider, String version) {
        if (CamelCatalogUtils.isCamelVersionWithoutProviderSupport(version)) {
            CamelCatalogCoordinates coord = CamelCatalogUtils.getDefaultCatalogCoordinates();
            coord.setArtifactId(CATALOG_CAMEL_ARTIFACTID);
            coord.setVersion(version);
            return coord;
        }
        if (RUNTIME_PROVIDER_SPRINGBOOT.equalsIgnoreCase(runtimeProvider)) {
            return new CamelCatalogCoordinates("org.apache.camel", CATALOG_SPRINGBOOT_ARTIFACTID, version);
        }
        return new CamelCatalogCoordinates("org.apache.camel", CATALOG_KARAF_ARTIFACTID, version);
    }

    public static boolean isCamelVersionWithoutProviderSupport(String version) {
        if (version == null) {
            return true;
        }
        ComparableVersion v1 = new ComparableVersion(version);
        ComparableVersion v2 = new ComparableVersion("2.18.1");
        return v1.compareTo(v2) < 0;
    }

    public static CamelCatalogCoordinates getDefaultCatalogCoordinates() {
        return CamelCatalogUtils.getCatalogCoordinatesFor("org.apache.camel", CATALOG_KARAF_ARTIFACTID, "2.18.1.redhat-000021");
    }

    public static CamelCatalogCoordinates getCatalogCoordinatesForProject(IProject project, IProgressMonitor monitor) {
        String camelVersion = new CamelMavenUtils().getCamelVersionFromMaven(project);
        String runtimeProvider = CamelCatalogUtils.getRuntimeprovider(project, monitor);
        if (RUNTIME_PROVIDER_SPRINGBOOT.equalsIgnoreCase(runtimeProvider)) {
            return CamelCatalogUtils.getCatalogCoordinatesFor("org.apache.camel", CATALOG_SPRINGBOOT_ARTIFACTID, camelVersion);
        }
        return CamelCatalogUtils.getCatalogCoordinatesFor("org.apache.camel", CATALOG_KARAF_ARTIFACTID, camelVersion);
    }

    public static String getRuntimeprovider(IProject camelProject, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (camelProject != null) {
            IMavenProjectFacade m2prj = MavenPlugin.getMavenProjectRegistry().create(camelProject, (IProgressMonitor)subMonitor.split(1));
            try {
                MavenProject mavenProject;
                if (m2prj != null && (mavenProject = m2prj.getMavenProject((IProgressMonitor)subMonitor.split(1))) != null) {
                    List dependencies = mavenProject.getDependencies();
                    return CamelCatalogUtils.getRuntimeProviderFromDependencyList(dependencies);
                }
            }
            catch (CoreException e) {
                CamelModelServiceCoreActivator.pluginLog().logWarning((Throwable)e);
            }
        }
        return RUNTIME_PROVIDER_KARAF;
    }

    public static String getRuntimeProviderFromDependency(org.apache.maven.model.Dependency dependency) {
        List<org.apache.maven.model.Dependency> deps = Arrays.asList(dependency);
        return CamelCatalogUtils.getRuntimeProviderFromDependencyList(deps);
    }

    public static String getRuntimeProviderFromDependencyList(List<org.apache.maven.model.Dependency> dependencies) {
        if (CamelCatalogUtils.hasSpringBootDependency(dependencies)) {
            return RUNTIME_PROVIDER_SPRINGBOOT;
        }
        return RUNTIME_PROVIDER_KARAF;
    }

    public static boolean hasSpringBootDependency(List<org.apache.maven.model.Dependency> dependencies) {
        return CamelCatalogUtils.hasDependency(dependencies, CAMEL_SPRING_BOOT_STARTER);
    }

    public static boolean hasWildflyDependency(List<org.apache.maven.model.Dependency> dependencies) {
        return CamelCatalogUtils.hasDependency(dependencies, "org.wildfly.camel");
    }

    private static boolean hasDependency(List<org.apache.maven.model.Dependency> dependencies, String dependencyToCheck) {
        return dependencies != null && dependencies.stream().filter(dependency -> dependencyToCheck.equals(dependency.getArtifactId())).findFirst().isPresent();
    }

    public static void parseDependencies(List<Dependency> dependencies, Map<String, String> properties) {
        String version;
        String artId;
        String grpId = properties.get(GAV_KEY_GROUPID);
        if (CamelCatalogUtils.isValidGAV(grpId, artId = properties.get(GAV_KEY_ARTIFACTID), version = properties.get(GAV_KEY_VERSION))) {
            Dependency dep = new Dependency();
            dep.setGroupId(grpId);
            dep.setArtifactId(artId);
            dep.setVersion(version);
            dependencies.add(dep);
        }
    }

    public static String getFabric8MavenPluginVersionForBomVersion(String bomVersion, IProgressMonitor monitor) {
        if (FISBOM_TO_FABRIC8MAVENPLUGIN_MAPPING.containsKey(bomVersion)) {
            return FISBOM_TO_FABRIC8MAVENPLUGIN_MAPPING.get(bomVersion);
        }
        org.apache.maven.model.Dependency artifactToSearch = new org.apache.maven.model.Dependency();
        artifactToSearch.setGroupId("io.fabric8");
        artifactToSearch.setArtifactId("fabric8-maven-plugin");
        try {
            return new OnlineArtifactVersionSearcher().findLatestVersion(monitor, artifactToSearch);
        }
        catch (CoreException e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
            return "";
        }
    }
}

