/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.IOUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public final class CamelComponentUtils {
    private static Map<CamelModel, Map<String, Component>> knownComponentsForCamelModel = new HashMap<CamelModel, Map<String, Component>>();

    private CamelComponentUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Component getComponentModel(String protocol, CamelFile camelFile) {
        Map<Object, Object> knownComponents;
        CamelModel camelModel = camelFile.getCamelModel();
        if (knownComponentsForCamelModel.containsKey(camelModel)) {
            knownComponents = knownComponentsForCamelModel.get(camelModel);
        } else {
            knownComponents = new HashMap();
            knownComponentsForCamelModel.put(camelModel, knownComponents);
        }
        String componentClass = CamelComponentUtils.getComponentClass(protocol, camelFile);
        if (knownComponents.containsKey(componentClass)) {
            return (Component)knownComponents.get(componentClass);
        }
        Component c = CamelComponentUtils.buildModelForComponent(protocol, componentClass, camelFile);
        if (c != null) {
            knownComponents.put(componentClass, c);
            return CamelComponentUtils.getComponentModel(protocol, camelFile);
        }
        return null;
    }

    public static String[] getRefs(CamelFile cf) {
        CamelContextElement camelContext;
        ArrayList<String> refs = new ArrayList<String>();
        refs.add("");
        Set<String> globalDefinitionIds = cf.getCamelFile().getGlobalDefinitions().keySet();
        refs.addAll(Arrays.asList(globalDefinitionIds.toArray(new String[globalDefinitionIds.size()])));
        if (cf.getRouteContainer() instanceof CamelContextElement && (camelContext = (CamelContextElement)cf.getRouteContainer()) != null) {
            Set<String> globalEndpointDefinitionIds = camelContext.getEndpointDefinitions().keySet();
            refs.addAll(Arrays.asList(globalEndpointDefinitionIds.toArray(new String[globalEndpointDefinitionIds.size()])));
            Set<String> globalDataformatIds = camelContext.getDataformats().keySet();
            refs.addAll(Arrays.asList(globalDataformatIds.toArray(new String[globalDataformatIds.size()])));
        }
        return refs.toArray(new String[refs.size()]);
    }

    public static boolean isRefProperty(Parameter p) {
        return "ref".equalsIgnoreCase(p.getName()) && "string".equalsIgnoreCase(p.getType()) && "java.lang.String".equalsIgnoreCase(p.getJavaType()) && "attribute".equalsIgnoreCase(p.getKind());
    }

    public static boolean isBooleanProperty(Parameter p) {
        return "boolean".equalsIgnoreCase(p.getJavaType()) || "java.lang.Boolean".equalsIgnoreCase(p.getJavaType());
    }

    public static boolean isDescriptionProperty(Parameter p) {
        return "element".equals(p.getKind()) && "org.apache.camel.model.DescriptionDefinition".equalsIgnoreCase(p.getJavaType()) && "description".equals(p.getName());
    }

    public static boolean isTextProperty(Parameter p) {
        return p.getChoice() == null && !"ref".equalsIgnoreCase(p.getName()) && !"expression".equals(p.getKind()) && ("String".equalsIgnoreCase(p.getJavaType()) || "java.lang.String".equalsIgnoreCase(p.getJavaType()) || "java.net.URL".equalsIgnoreCase(p.getJavaType()) || "java.net.URI".equalsIgnoreCase(p.getJavaType()) || "Text".equalsIgnoreCase(p.getJavaType()));
    }

    public static boolean isCharProperty(Parameter p) {
        return "char".equalsIgnoreCase(p.getJavaType());
    }

    public static boolean isNumberProperty(Parameter p) {
        String javaType = p.getJavaType();
        return p.getChoice() == null && ("int".equalsIgnoreCase(javaType) || "Integer".equalsIgnoreCase(javaType) || "java.lang.Integer".equalsIgnoreCase(javaType) || "long".equalsIgnoreCase(javaType) || "java.lang.Long".equalsIgnoreCase(javaType) || "double".equalsIgnoreCase(javaType) || "java.lang.Double".equalsIgnoreCase(javaType) || "float".equalsIgnoreCase(javaType) || "java.lang.Float".equalsIgnoreCase(javaType) || "Number".equalsIgnoreCase(javaType));
    }

    public static boolean isChoiceProperty(Parameter p) {
        return p.getChoice() != null && p.getChoice().length > 0;
    }

    public static boolean isFileProperty(Parameter p) {
        return "file".equalsIgnoreCase(p.getJavaType()) || "java.io.file".equalsIgnoreCase(p.getJavaType());
    }

    public static boolean isClassProperty(Parameter p) {
        return "object".equalsIgnoreCase(p.getType());
    }

    public static boolean isExpressionProperty(Parameter p) {
        return "expression".equalsIgnoreCase(p.getKind()) || "org.apache.camel.model.language.ExpressionDefinition".equalsIgnoreCase(p.getJavaType());
    }

    public static boolean isDataFormatProperty(Parameter p) {
        return "element".equalsIgnoreCase(p.getKind()) && "org.apache.camel.model.DataFormatDefinition".equalsIgnoreCase(p.getJavaType());
    }

    public static boolean isListProperty(Parameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.list") || p.getJavaType().toLowerCase().startsWith("java.util.collection");
    }

    public static boolean isMapProperty(Parameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.map");
    }

    public static boolean isUriPathParameter(Parameter p) {
        return p.getKind() != null && "path".equalsIgnoreCase(p.getKind());
    }

    public static boolean isUriOptionParameter(Parameter p) {
        return p.getKind() != null && "parameter".equalsIgnoreCase(p.getKind());
    }

    public static boolean isUnsupportedProperty(Parameter p) {
        return CamelComponentUtils.isMapProperty(p) || p.getJavaType().toLowerCase().startsWith("java.util.date");
    }

    public static String[] getChoicesWithExtraEmptyEntry(Parameter p) {
        String[] choices = p.getChoice();
        ArrayList<String> res = new ArrayList<String>();
        res.add("");
        String[] stringArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String choice = stringArray[n2];
            res.add(choice);
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] getOneOfList(Parameter p) {
        return p.getOneOf();
    }

    public static String getComponentClassForScheme(String scheme, CamelFile camelFile) {
        String compClass = null;
        Collection<Component> components = camelFile.getCamelModel().getComponents();
        for (Component c : components) {
            if (!c.supportsScheme(scheme)) continue;
            compClass = c.getClazz();
            break;
        }
        return compClass;
    }

    private static String getClassFromZipEntry(String scheme, File cpEntryFile) {
        block13: {
            if (CamelComponentUtils.isJarFile(cpEntryFile)) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (ZipFile zf = new ZipFile(cpEntryFile);){
                        ZipEntry ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                        if (ze == null) break block13;
                        Properties p = new Properties();
                        p.load(zf.getInputStream(ze));
                        return p.getProperty("class");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
                }
            }
        }
        return null;
    }

    private static String getComponentClassFromJar(IJavaProject jpr, String scheme) {
        try {
            IClasspathEntry[] iClasspathEntryArray = jpr.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                File cpEntryFile = e.getPath().toFile();
                String compClass = CamelComponentUtils.getClassFromZipEntry(scheme, cpEntryFile);
                if (!Strings.isBlank((String)compClass)) {
                    return compClass;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
        }
        return null;
    }

    protected static String getComponentClass(String scheme, CamelFile camelFile) {
        IProject project;
        IJavaProject jpr;
        String compClass = CamelComponentUtils.getComponentClassForScheme(scheme, camelFile);
        if (compClass == null && (jpr = JavaCore.create((IProject)(project = camelFile.getResource().getProject()))).exists() && jpr.isOpen()) {
            compClass = CamelComponentUtils.getComponentClassFromJar(jpr, scheme);
        }
        return compClass;
    }

    private static String getComponentJsonFromJar(File cpEntryFile, String scheme) {
        block12: {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipFile zf = new ZipFile(cpEntryFile);){
                    ZipEntry ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                    if (ze == null) break block12;
                    Properties p = new Properties();
                    p.load(zf.getInputStream(ze));
                    String compClass = p.getProperty("class");
                    String packageName = compClass.substring(0, compClass.lastIndexOf(46));
                    String folder = packageName.replaceAll("\\.", "/");
                    ze = zf.getEntry(String.format("%s/%s.json", folder, scheme));
                    if (ze == null) break block12;
                    return IOUtils.loadText((InputStream)zf.getInputStream(ze), null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return null;
    }

    protected static String getComponentJSon(String scheme, IProject project) {
        IJavaProject jpr = JavaCore.create((IProject)project);
        if (jpr.exists() && jpr.isOpen()) {
            try {
                IClasspathEntry[] iClasspathEntryArray = jpr.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String compJSON;
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    File cpEntryFile = e.getPath().toFile();
                    if (CamelComponentUtils.isJarFile(cpEntryFile) && !Strings.isBlank((String)(compJSON = CamelComponentUtils.getComponentJsonFromJar(cpEntryFile, scheme)))) {
                        return compJSON;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return null;
    }

    private static boolean isJarFile(File f) {
        return f.isFile() && f.getName().toLowerCase().endsWith(".jar");
    }

    protected static Component buildModelForComponent(String scheme, String clazz, CamelFile camelFile) {
        CamelModel camelModel = camelFile.getCamelModel();
        Component resModel = camelModel.getComponentForScheme(scheme);
        if (resModel == null) {
            resModel = CamelComponentUtils.buildModelFromJSON(scheme, CamelComponentUtils.getComponentJSon(scheme, camelFile.getResource().getProject()), camelModel);
        }
        if (resModel == null && "activemq".equalsIgnoreCase(scheme)) {
            return camelModel.getComponentForScheme("jms").duplicateFor(scheme, clazz);
        }
        return resModel;
    }

    protected static Component buildModelFromJSON(String scheme, String oJSONBlob, CamelModel camelModel) {
        Component resModel = null;
        try {
            if (oJSONBlob != null) {
                resModel = CamelComponentUtils.buildModelFromJSonBlob(oJSONBlob);
                resModel.setScheme(scheme);
                CamelComponentUtils.saveModel(camelModel, resModel);
            }
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
        }
        return resModel;
    }

    private static void saveModel(CamelModel camelModel, Component component) {
        if (!knownComponentsForCamelModel.containsKey(camelModel)) {
            knownComponentsForCamelModel.put(camelModel, new HashMap());
        }
        knownComponentsForCamelModel.get(camelModel).put(component.getClazz(), component);
    }

    public static URLClassLoader getProjectClassLoader(IProject project) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IPackageFragmentRoot[] pfroots = javaProject.getAllPackageFragmentRoots();
            ArrayList<URL> urls = new ArrayList<URL>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = pfroots;
            int n = pfroots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                URL rUrl = root.getPath().toFile().toURI().toURL();
                urls.add(rUrl);
                ++n2;
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), CamelComponentUtils.class.getClassLoader());
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }

    protected static Component buildModelFromJSonBlob(String json) {
        return Component.getJSONFactoryInstance(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
    }
}

