/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.xml.namespace.CamelNamespaceXmlContentDescriber;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;

public class CamelFilesFinder {
    private static final String COM_SPRINGSOURCE_STS_CONFIG_UI_BEAN_CONFIG_FILE_CONTENT_TYPE = "com.springsource.sts.config.ui.beanConfigFile";

    public Set<IFile> findFiles(IResource resource) {
        HashSet<IFile> res = new HashSet<IFile>();
        if (resource instanceof IContainer && resource.exists()) {
            try {
                IResource[] children;
                IResource[] iResourceArray = children = ((IContainer)resource).members();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource f = iResourceArray[n2];
                    if (f instanceof IContainer) {
                        if (!this.isWorkProjectFolder(resource.getProject(), f) && !this.isTestProjectFolder(resource.getProject(), f)) {
                            res.addAll(this.findFiles(f));
                        }
                    } else {
                        IFile ifile = (IFile)f;
                        try {
                            if (this.isFuseCamelContentType(ifile)) {
                                res.add(ifile);
                            }
                        }
                        catch (CoreException e) {
                            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e1);
            }
        }
        return res;
    }

    public boolean isWorkProjectFolder(IProject project, IResource f) {
        String resourceName = f.getName();
        return ("target".equalsIgnoreCase(resourceName) || "bin".equalsIgnoreCase(resourceName)) && f.getParent().getName().equalsIgnoreCase(project.getName());
    }

    private boolean isTestProjectFolder(IProject project, IResource f) {
        String resourceName = f.getName();
        return "test".equalsIgnoreCase(resourceName) && "src".equalsIgnoreCase(f.getParent().getName()) && f.getParent().getParent().getName().equalsIgnoreCase(project.getName());
    }

    public boolean isFuseCamelContentType(IFile ifile) throws CoreException {
        IContentDescription contentDescription;
        if (ifile != null && ifile.isSynchronized(0) && ifile.isLocal(0) && (contentDescription = ifile.getContentDescription()) != null) {
            String contentTypeId = contentDescription.getContentType().getId();
            if (COM_SPRINGSOURCE_STS_CONFIG_UI_BEAN_CONFIG_FILE_CONTENT_TYPE.equals(contentTypeId)) {
                try {
                    ByteArrayInputStream markableAndResettableStream = new ByteArrayInputStream(Files.readAllBytes(ifile.getLocation().toFile().toPath()));
                    return 2 == new CamelNamespaceXmlContentDescriber().describe((InputStream)markableAndResettableStream, null);
                }
                catch (IOException e) {
                    CamelModelServiceCoreActivator.pluginLog().logInfo("Cannot check Content type of " + ifile.getName(), (Throwable)e);
                }
            } else {
                return "org.fusesource.ide.camel.editor.camelContentType".equals(contentTypeId);
            }
        }
        return false;
    }

    public static CamelFile getFileFromEditor(IFile file) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart oEditor;
                    IEditorReference editor = iEditorReferenceArray[n6];
                    if (editor.getId().equals("org.fusesource.ide.camel.editor") && (oEditor = editor.getEditor(false)) != null) {
                        CamelXMLEditorInput editorInput;
                        CamelXMLEditorInput camelXMLEditorInput = editorInput = oEditor.getEditorInput() != null ? (CamelXMLEditorInput)oEditor.getEditorInput() : null;
                        if (editorInput != null && editorInput.getCamelContextFile().equals((Object)file)) {
                            return (CamelFile)oEditor.getAdapter(CamelFile.class);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

