/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.preferences.initializer.StagingRepositoriesPreferenceInitializer;

public class CamelMavenUtils {
    public static final QualifiedName CAMEL_VERSION_QNAME = new QualifiedName("org.fusesource.ide.camel.model.service.core", "camelVersionString");

    public List<Repository> getRepositories(IProject project, IProgressMonitor monitor) {
        IMavenProjectFacade projectFacade = this.getMavenProjectFacade(project);
        ArrayList<Repository> reps = new ArrayList<Repository>();
        if (projectFacade != null) {
            try {
                MavenProject mavenProject = projectFacade.getMavenProject(monitor);
                reps.addAll(this.getRepositories(mavenProject));
            }
            catch (CoreException e) {
                CamelModelServiceCoreActivator.pluginLog().logError("Maven project has not been found (not imported?). Repositories won't be resolved.", (Throwable)e);
            }
        }
        return reps;
    }

    public List<Repository> getRepositories(MavenProject project) {
        if (project != null) {
            String pomPath = project.getFile().getPath();
            File pomFile = new File(pomPath);
            if (!pomFile.exists() || !pomFile.isFile()) {
                return Collections.emptyList();
            }
            try {
                Model model = MavenPlugin.getMaven().readModel(pomFile);
                ArrayList<Repository> repos = new ArrayList<Repository>();
                if (model.getRepositories() != null) {
                    repos.addAll(model.getRepositories());
                }
                if (model.getPluginRepositories() != null) {
                    repos.addAll(model.getPluginRepositories());
                }
                return repos;
            }
            catch (Exception ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    private void translateVariables(List<Dependency> deps, Model model) {
        for (Dependency dep : deps) {
            if (dep.getVersion() == null || !dep.getVersion().startsWith("${")) continue;
            String propName = dep.getVersion().substring(2, dep.getVersion().length() - 1);
            if (model.getProperties() == null) continue;
            String version = (String)model.getProperties().get(propName);
            dep.setVersion(version);
        }
    }

    public IMavenProjectFacade getMavenProjectFacade(IProject project) {
        IFile pomIFile;
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade res = projectRegistry.create(project, (IProgressMonitor)new NullProgressMonitor());
        if (res == null && (pomIFile = project.getFile((IPath)new Path("pom.xml"))).exists()) {
            res = projectRegistry.create(pomIFile, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return res;
    }

    public String getCamelVersionFromMaven(IProject project) {
        return this.getCamelVersionFromMaven(project, true);
    }

    public String getCamelVersionFromProjectName(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        return this.getCamelVersionFromMaven(project);
    }

    public String getCamelVersionFromMaven(IProject project, boolean useCachedCamelVersionInfo) {
        String camelVersion;
        try {
            if (!useCachedCamelVersionInfo || project.getSessionProperty(CAMEL_VERSION_QNAME) == null) {
                List<Dependency> deps = this.getDependencyList(project);
                if (deps.isEmpty()) {
                    camelVersion = CamelCatalogUtils.getLatestCamelVersion();
                } else {
                    camelVersion = this.getCamelVersionFromDependencies(deps);
                    if (camelVersion == null) {
                        camelVersion = this.getCamelVersionFromProperty(project);
                    }
                }
                project.setSessionProperty(CAMEL_VERSION_QNAME, (Object)camelVersion);
            } else {
                camelVersion = (String)project.getSessionProperty(CAMEL_VERSION_QNAME);
            }
        }
        catch (CoreException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            camelVersion = CamelCatalogUtils.getLatestCamelVersion();
        }
        return camelVersion;
    }

    private String getCamelVersionFromProperty(IProject project) {
        IMavenProjectFacade m2facade = this.getMavenProjectFacade(project);
        try {
            MavenProject m2Project = m2facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
            Properties mavenProperties = m2Project.getProperties();
            return mavenProperties.getProperty("camel.version");
        }
        catch (CoreException e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
            return null;
        }
    }

    public Model getMavenModel(IProject project) {
        return this.getMavenModel(project, false);
    }

    public Model getMavenModel(IProject project, boolean resolveFully) {
        if (resolveFully) {
            IMavenProjectFacade m2facade = this.getMavenProjectFacade(project);
            try {
                MavenProject m2Project = m2facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                return m2Project.getModel();
            }
            catch (CoreException ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        } else {
            try {
                return MavenPlugin.getMaven().readModel(project.getFile("pom.xml").getContents());
            }
            catch (CoreException ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return null;
    }

    public List<Dependency> getDependencyList(IProject project) {
        return this.getDependencyList(project, false);
    }

    public List<Dependency> getDependencyList(IProject project, boolean includeManagedDependencies) {
        IMavenProjectFacade m2facade = this.getMavenProjectFacade(project);
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (m2facade != null) {
            try {
                MavenProject m2Project = m2facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                deps.addAll(m2Project.getCompileDependencies());
                deps.addAll(m2Project.getDependencies());
                deps.addAll(m2Project.getRuntimeDependencies());
                deps.addAll(m2Project.getSystemDependencies());
                deps.addAll(m2Project.getTestDependencies());
                if (m2Project.getDependencyManagement() != null && includeManagedDependencies) {
                    deps.addAll(m2Project.getDependencyManagement().getDependencies());
                }
                this.translateVariables(deps, m2Project.getModel());
            }
            catch (CoreException ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return deps;
    }

    private String getCamelVersionFromDependencies(List<Dependency> deps) {
        for (Dependency pomDep : deps) {
            if (!"org.apache.camel".equalsIgnoreCase(pomDep.getGroupId()) || !pomDep.getArtifactId().startsWith("camel-")) continue;
            return pomDep.getVersion();
        }
        return null;
    }

    public String getWildFlyCamelVersionFromMaven(IProject project) {
        List<Dependency> deps = this.getDependencyList(project);
        for (Dependency pomDep : deps) {
            if (!"org.wildfly.camel".equalsIgnoreCase(pomDep.getGroupId())) continue;
            return pomDep.getVersion();
        }
        return null;
    }

    public boolean isRedHatBrandedVersion(String version) {
        return version.toLowerCase().indexOf(".redhat-") != -1;
    }

    public List<List<String>> getAdditionalRepos() {
        ArrayList<List<String>> repoList = new ArrayList<List<String>>();
        StagingRepositoriesPreferenceInitializer initializer = new StagingRepositoriesPreferenceInitializer();
        if (initializer.isStagingRepositoriesEnabled()) {
            repoList.addAll(initializer.getStagingRepositories());
        }
        repoList.add(Arrays.asList("asf-public", "https://repo.maven.apache.org/maven2"));
        repoList.add(Arrays.asList("old-fuse", "https://repository.jboss.org/nexus/content/repositories/fs-releases"));
        repoList.add(Arrays.asList("redhat-ga", "https://maven.repository.redhat.com/ga/"));
        return repoList;
    }
}

