/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.model.Dependency;

public class FuseBomFilter
implements Predicate<Dependency> {
    private static Set<Dependency> possibleBoms = new HashSet<Dependency>();
    public static final Dependency BOM_FUSE_6 = FuseBomFilter.initPossibleBomWith("org.jboss.fuse.bom", "jboss-fuse-parent");
    public static final Dependency BOM_FUSE_7_WILDFLY = FuseBomFilter.initPossibleBomWith("org.wildfly.camel", "wildfly-camel-bom");
    public static final Dependency BOM_FUSE_7 = FuseBomFilter.initPossibleBomWith("org.jboss.fuse", "jboss-fuse-parent");
    public static final Dependency BOM_FUSE_FIS = FuseBomFilter.initPossibleBomWith("io.fabric8", "fabric8-project-bom-camel-spring-boot");

    private static Dependency initPossibleBomWith(String groupId, String artifactId) {
        Dependency bom = new Dependency();
        bom.setGroupId(groupId);
        bom.setArtifactId(artifactId);
        bom.setType("pom");
        possibleBoms.add(bom);
        return bom;
    }

    @Override
    public boolean test(Dependency dependency) {
        return possibleBoms.stream().anyMatch(possibleBom -> possibleBom.getArtifactId().equals(dependency.getArtifactId()) && possibleBom.getGroupId().equals(dependency.getGroupId()));
    }
}

