/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;

public class JavaCamelFilesFinder {
    private IFile fileToOpen = null;

    public IFile findJavaDSLRouteBuilderClass(IProject project, IProgressMonitor monitor) {
        try {
            project.build(10, monitor);
        }
        catch (CoreException e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
        }
        try {
            JavaCamelFilesFinder.waitJob(20, monitor);
        }
        catch (OperationCanceledException opEx) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)opEx);
        }
        catch (InterruptedException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            Thread.currentThread().interrupt();
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType routeBuilderType = javaProject.findType("org.apache.camel.builder.RouteBuilder");
            if (routeBuilderType != null) {
                this.doSearch(javaProject, routeBuilderType, monitor);
            }
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
        }
        return this.fileToOpen;
    }

    private void doSearch(IJavaProject javaProject, IType routeBuilderType, IProgressMonitor monitor) {
        try {
            IJavaSearchScope searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)routeBuilderType, (boolean)true, (boolean)false, null);
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            SearchPattern searchPattern = SearchPattern.createPattern((String)"*", (int)5, (int)1, (int)2);
            new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, monitor);
            List results = requestor.getResults();
            for (SearchMatch searchMatch : results) {
                Object element = searchMatch.getElement();
                if (!(element instanceof ResolvedSourceType)) continue;
                this.fileToOpen = (IFile)((ResolvedSourceType)element).getCompilationUnit().getCorrespondingResource();
            }
        }
        catch (Exception e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    private static void waitJob(int decreasingCounter, IProgressMonitor monitor) throws InterruptedException {
        if (decreasingCounter > 0) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
        }
        catch (InterruptedException interruptedException) {
            JavaCamelFilesFinder.waitJob(decreasingCounter - 1, monitor);
            Thread.currentThread().interrupt();
        }
    }
}

