/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IMutableIndex;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.search.util.IndexSearchEngine;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.camel.model.service.core.util.FuseBomFilter;
import org.fusesource.ide.camel.model.service.core.util.SearchLatestBomVersionAvailableM2ECallable;
import org.fusesource.ide.preferences.initializer.StagingRepositoriesPreferenceInitializer;

public class OnlineArtifactVersionSearcher {
    public String findLatestBomVersionOnAvailableRepo(IProject project, IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        String bomVersion = null;
        try {
            IMavenProjectFacade mavenProjectFacade = new CamelMavenUtils().getMavenProjectFacade(project);
            MavenProject mavenProject = mavenProjectFacade.getMavenProject((IProgressMonitor)subMon.split(1));
            Dependency bomUsed = this.retrieveAnyFuseBomUsed(mavenProject);
            if (bomUsed != null) {
                bomVersion = this.findLatestBomVersionOnAvailableRepo(project, (IProgressMonitor)subMon.split(1), mavenProject, bomUsed);
            }
        }
        catch (CoreException e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
        }
        subMon.setWorkRemaining(0);
        return bomVersion;
    }

    protected String findLatestBomVersionOnAvailableRepo(IProject project, IProgressMonitor monitor, MavenProject mavenProject, Dependency bomToSearch) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IIndex index = MavenPlugin.getIndexManager().getIndex(project);
        IndexSearchEngine indexSearchEngine = new IndexSearchEngine(index);
        Collection versions = indexSearchEngine.findVersions(bomToSearch.getGroupId(), bomToSearch.getArtifactId(), null, Packaging.POM);
        subMon.setWorkRemaining(1);
        if (!versions.isEmpty()) {
            return (String)versions.iterator().next();
        }
        return (String)MavenPlugin.getMaven().createExecutionContext().execute(mavenProject, (ICallable)new SearchLatestBomVersionAvailableM2ECallable(mavenProject.getRepositories(), bomToSearch), (IProgressMonitor)subMon.split(1));
    }

    public String findLatestVersion(IProgressMonitor monitor, Dependency artifactToSearch) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IMutableIndex index = MavenPlugin.getIndexManager().getWorkspaceIndex();
        IndexSearchEngine indexSearchEngine = new IndexSearchEngine((IIndex)index);
        Collection versions = indexSearchEngine.findVersions(artifactToSearch.getGroupId(), artifactToSearch.getArtifactId(), null, Packaging.POM);
        subMon.setWorkRemaining(1);
        if (!versions.isEmpty()) {
            return (String)versions.iterator().next();
        }
        List<List<String>> additionalRepos = new CamelMavenUtils().getAdditionalRepos();
        ArrayList<Repository> additionalMavenRepos = new ArrayList<Repository>();
        for (List<String> repo : additionalRepos) {
            Repository mavenRepo = new Repository();
            mavenRepo.setId(repo.get(0));
            mavenRepo.setUrl(repo.get(1));
            additionalMavenRepos.add(mavenRepo);
        }
        StagingRepositoriesPreferenceInitializer initializer = new StagingRepositoriesPreferenceInitializer();
        if (!initializer.isStagingRepositoriesEnabled()) {
            Repository mavenRepo = new Repository();
            mavenRepo.setId("fuse-early-access");
            mavenRepo.setUrl("https://origin-repository.jboss.org/nexus/content/groups/ea/");
            additionalMavenRepos.add(mavenRepo);
        }
        return (String)MavenPlugin.getMaven().createExecutionContext().execute((ICallable)new SearchLatestBomVersionAvailableM2ECallable(additionalMavenRepos, artifactToSearch), (IProgressMonitor)subMon.split(1));
    }

    private Dependency retrieveAnyFuseBomUsed(MavenProject mavenProject) {
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();
        return this.retrieveAnyFuseBomUsed(dependencyManagement);
    }

    public Dependency retrieveAnyFuseBomUsed(DependencyManagement dependencyManagement) {
        Optional<Dependency> bomDependency;
        List managedDependencies;
        if (dependencyManagement != null && (managedDependencies = dependencyManagement.getDependencies()) != null && (bomDependency = managedDependencies.stream().filter(new FuseBomFilter()).findAny()).isPresent()) {
            return bomDependency.get();
        }
        return null;
    }
}

