/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;

public class ProjectClasspathChangedListener
implements IElementChangedListener,
IResourceChangeListener {
    private Map<IProject, String> knownProjects = new HashMap<IProject, String>();
    private boolean isActivated = true;

    public ProjectClasspathChangedListener() {
        for (IJavaProject jp : ProjectClasspathChangedListener.getCamelProjects()) {
            this.initializeProject(jp.getProject());
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.isActivated) {
            this.visit(event.getDelta());
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource rsrc = event.getResource();
        if (rsrc instanceof IProject) {
            IProject prj = (IProject)rsrc;
            if (event.getType() == 2 || event.getType() == 4) {
                this.knownProjects.remove(prj);
            } else if (this.isActivated && !this.knownProjects.containsKey(prj)) {
                this.initializeProject(prj);
            }
        }
    }

    private void initializeProject(IProject project) {
        this.notifyClasspathChanged(ProjectClasspathChangedListener.getJavaProjectForProject(project));
    }

    private void visitChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta c = iJavaElementDeltaArray[n2];
            this.visit(c);
            ++n2;
        }
    }

    private static List<IJavaProject> getCamelProjects() {
        ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (ProjectClasspathChangedListener.isOpenJavaProject(project) && ProjectClasspathChangedListener.isOpenCamelProject(project)) {
                    projectList.add(ProjectClasspathChangedListener.getJavaProjectForProject(project));
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ce);
        }
        return projectList;
    }

    private boolean isClasspathChanged(int flags) {
        return (flags & 0x220000) != 0;
    }

    private static IJavaProject getJavaProjectForProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    private static boolean isOpenJavaProject(IProject project) throws CoreException {
        return project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
    }

    private static boolean isOpenCamelProject(IProject project) throws CoreException {
        return project.isAccessible() && project.hasNature("org.fusesource.ide.project.RiderProjectNature");
    }

    private void visit(IJavaElementDelta delta) {
        IJavaElement el = delta.getElement();
        switch (el.getElementType()) {
            case 1: {
                this.visitChildren(delta);
                break;
            }
            case 2: {
                if (!this.isClasspathChanged(delta.getFlags())) break;
                this.notifyClasspathChanged((IJavaProject)el);
                break;
            }
        }
    }

    private void notifyClasspathChanged(IJavaProject project) {
        IProject prj = project.getProject();
        String camelVersion = new CamelMavenUtils().getCamelVersionFromMaven(prj);
        if (camelVersion != null) {
            boolean camelVersionChanged = true;
            String oldCamelVersion = this.knownProjects.get(prj);
            if (!this.knownProjects.containsKey(prj)) {
                this.knownProjects.put(prj, camelVersion);
            } else {
                boolean bl = camelVersionChanged = !camelVersion.equals(oldCamelVersion);
            }
            if (camelVersionChanged) {
                this.knownProjects.put(prj, camelVersion);
                CamelCatalogCacheManager.getInstance().getCamelModelForProject(prj, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void deactivate() {
        this.isActivated = false;
    }

    public void activate() {
        this.isActivated = true;
    }
}

