/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.fusesource.ide.camel.model.service.core.CamelServiceManagerUtil;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.UriParameterKind;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentProperty;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.core.util.CamelUtils;

public class PropertiesUtils {
    public static final Pattern PATH_DELIMETER = Pattern.compile(":|/");

    public static Parameter getUriParam(String name, Component c) {
        return PropertiesUtils.getUriParam(name, c.getParameters());
    }

    public static Parameter getUriParam(String name, List<Parameter> uriParams) {
        for (Parameter p : uriParams) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static Component getComponentFor(AbstractCamelModelElement selectedEP) {
        int protocolSeparatorIdx;
        if (selectedEP != null && selectedEP.getParameter("uri") != null && (protocolSeparatorIdx = ((String)selectedEP.getParameter("uri")).indexOf(58)) != -1) {
            return CamelComponentUtils.getComponentModel(((String)selectedEP.getParameter("uri")).substring(0, protocolSeparatorIdx), selectedEP.getCamelFile());
        }
        return null;
    }

    public static Eip getEipFor(AbstractCamelModelElement selectedEP) {
        if (selectedEP != null && selectedEP.getUnderlyingMetaModelObject() != null) {
            return selectedEP.getUnderlyingMetaModelObject();
        }
        return null;
    }

    public static List<Parameter> getPathProperties(AbstractCamelModelElement selectedEP) {
        int protocolSeparatorIdx;
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        if (selectedEP != null && selectedEP.getParameter("uri") != null && (protocolSeparatorIdx = ((String)selectedEP.getParameter("uri")).indexOf(58)) != -1) {
            Component componentModel = CamelComponentUtils.getComponentModel(((String)selectedEP.getParameter("uri")).substring(0, protocolSeparatorIdx), selectedEP.getCamelFile());
            return PropertiesUtils.getPathProperties(selectedEP, componentModel);
        }
        return result;
    }

    public static List<Parameter> getPathProperties(AbstractCamelModelElement selectedEP, Component componentModel) {
        int protocolSeparatorIdx;
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        if (selectedEP != null && selectedEP.getParameter("uri") != null && componentModel != null && (protocolSeparatorIdx = ((String)selectedEP.getParameter("uri")).indexOf(58)) != -1) {
            for (Parameter p : componentModel.getParameters()) {
                if (!"path".equalsIgnoreCase(p.getKind())) continue;
                result.add(p);
            }
        }
        return result;
    }

    public static List<Parameter> getPropertiesFor(AbstractCamelModelElement selectedEP, UriParameterKind kind) {
        Component componentModel;
        int protocolSeparatorIdx;
        if (selectedEP != null && selectedEP.getParameter("uri") != null && (protocolSeparatorIdx = ((String)selectedEP.getParameter("uri")).indexOf(58)) != -1 && (componentModel = CamelComponentUtils.getComponentModel(((String)selectedEP.getParameter("uri")).substring(0, protocolSeparatorIdx), selectedEP.getCamelFile())) != null) {
            return PropertiesUtils.getPropertiesFor(kind, componentModel);
        }
        return Collections.emptyList();
    }

    public static List<Parameter> getPropertiesFor(UriParameterKind kind, Component componentModel) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter p : componentModel.getParameters()) {
            if (kind == UriParameterKind.CONSUMER) {
                if (p.getLabel() == null || !PropertiesUtils.containsLabel("consumer", p)) continue;
                result.add(p);
                continue;
            }
            if (kind == UriParameterKind.PRODUCER) {
                if (p.getLabel() == null || !PropertiesUtils.containsLabel("producer", p)) continue;
                result.add(p);
                continue;
            }
            if (kind != UriParameterKind.BOTH || p.getLabel() != null && p.getLabel().trim().length() >= 1) continue;
            result.add(p);
        }
        return result;
    }

    public static List<Parameter> getComponentPropertiesFor(AbstractCamelModelElement selectedEP) {
        Component componentModel;
        int protocolSeparatorIdx;
        if (selectedEP != null && selectedEP.getParameter("uri") != null && (protocolSeparatorIdx = ((String)selectedEP.getParameter("uri")).indexOf(58)) != -1 && (componentModel = CamelComponentUtils.getComponentModel(((String)selectedEP.getParameter("uri")).substring(0, protocolSeparatorIdx), selectedEP.getCamelFile())) != null) {
            return componentModel.getParameters();
        }
        return new ArrayList<Parameter>();
    }

    public static boolean containsLabel(String label, Parameter p) {
        if (p.getLabel() == null) {
            return false;
        }
        String pLabelString = p.getLabel();
        if (pLabelString.indexOf(44) != -1) {
            String[] labels;
            String[] stringArray = labels = pLabelString.split(",");
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String lab = stringArray[n2];
                if (lab.trim().equalsIgnoreCase(label)) {
                    return true;
                }
                ++n2;
            }
        } else if (pLabelString.trim().equalsIgnoreCase(label)) {
            return true;
        }
        return false;
    }

    public static List<Parameter> getPropertiesFor(AbstractCamelModelElement selectedEP) {
        List<Parameter> result = new ArrayList<Parameter>();
        if (selectedEP != null && selectedEP.getUnderlyingMetaModelObject() != null) {
            Eip eip = selectedEP.getUnderlyingMetaModelObject();
            result = eip.getParameters();
        }
        return result;
    }

    public static String getPropertyFromUri(AbstractCamelModelElement selectedEP, Parameter p, Component c) {
        String kind = p.getKind();
        String uriParameterValue = (String)selectedEP.getParameter("uri");
        if ("parameter".equalsIgnoreCase(kind)) {
            int idx = uriParameterValue.indexOf(String.valueOf(p.getName()) + "=");
            if (idx != -1) {
                return uriParameterValue.substring(idx + (String.valueOf(p.getName()) + "=").length(), uriParameterValue.indexOf(38, idx + 1) != -1 ? uriParameterValue.indexOf(38, idx + 1) : uriParameterValue.length());
            }
            if (p.getDefaultValue() != null && p.getDefaultValue().trim().length() > 0) {
                return p.getDefaultValue();
            }
        } else if ("path".equalsIgnoreCase(kind)) {
            String delimiters = PropertiesUtils.getDelimitersAsString(c.getSyntax(), c.getParameters());
            String uri = uriParameterValue.substring(uriParameterValue.indexOf(58) + 1, uriParameterValue.lastIndexOf(63) != -1 ? uriParameterValue.lastIndexOf(63) : uriParameterValue.length());
            String pathParameters = PropertiesUtils.findParameterOfTheUriPath(selectedEP, c, uriParameterValue);
            if (delimiters.length() < 1) {
                if (pathParameters != null) {
                    return String.valueOf(uri) + "?" + pathParameters;
                }
                return uri;
            }
            return PropertiesUtils.getPathMap(selectedEP, c).get(p.getName());
        }
        return null;
    }

    private static String findParameterOfTheUriPath(AbstractCamelModelElement selectedEP, Component c, String uriParameterValue) {
        String pathParameters = null;
        if (uriParameterValue.lastIndexOf(63) != -1) {
            String parameters = uriParameterValue.substring(uriParameterValue.lastIndexOf(63) + 1, uriParameterValue.length());
            try {
                Map<String, Object> parseQuery = CamelServiceManagerUtil.getManagerService().parseQuery(parameters);
                for (Parameter componentParameter : c.getParameters()) {
                    String componentParameterName = componentParameter.getName();
                    if (!parseQuery.containsKey(componentParameterName)) continue;
                    parseQuery.remove(componentParameterName);
                }
                if (!parseQuery.isEmpty()) {
                    pathParameters = CamelServiceManagerUtil.getManagerService().createQuery(parseQuery);
                }
            }
            catch (URISyntaxException e) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
            }
        }
        return pathParameters;
    }

    private static int getFieldIndex(String delimiters, String syntax, String fieldName) {
        int idx = -1;
        StringTokenizer syntaxTok = new StringTokenizer(syntax, delimiters);
        while (syntaxTok.hasMoreTokens()) {
            ++idx;
            String fName = syntaxTok.nextToken();
            if (fName.equals(fieldName)) break;
        }
        return idx;
    }

    private static String getDelimitersAsString(String syntax, List<Parameter> params) {
        String syntaxWithoutScheme;
        String delimiterString = syntax;
        delimiterString = syntaxWithoutScheme = delimiterString.substring(delimiterString.indexOf(58) + 1);
        Collections.sort(params, (o1, o2) -> o2.getName().length() - o1.getName().length());
        for (Parameter p : params) {
            if (!CamelComponentUtils.isUriPathParameter(p)) continue;
            delimiterString = delimiterString.replace(p.getName(), "");
        }
        return delimiterString;
    }

    private static Map<String, String> getPathMap(AbstractCamelModelElement selectedEP, Component c) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        List<Parameter> pathParams = PropertiesUtils.getPathProperties(selectedEP, c);
        String syntax = c.getSyntax();
        String delimiters = PropertiesUtils.getDelimitersAsString(syntax, pathParams);
        String initialURIValue = (String)selectedEP.getParameter("uri");
        String uri = initialURIValue.substring(initialURIValue.indexOf(58) + 1, initialURIValue.indexOf(63) != -1 ? initialURIValue.indexOf(63) : initialURIValue.length());
        HashMap<Integer, Parameter> fieldMapping = new HashMap<Integer, Parameter>();
        for (Parameter param : pathParams) {
            int idx = PropertiesUtils.getFieldIndex(delimiters, syntax.substring(syntax.indexOf(58) + 1), param.getName());
            fieldMapping.put(idx, param);
        }
        int lastPos = 0;
        int skippedDelimiters = 0;
        int field = 0;
        while (field < delimiters.length() + 1) {
            Parameter uriParam = (Parameter)fieldMapping.get(field);
            boolean required = "true".equalsIgnoreCase(uriParam.getRequired());
            if (skippedDelimiters > 0 && !required) {
                retVal.put(uriParam.getName(), null);
                --skippedDelimiters;
            } else {
                int foundPos = -1;
                int delIdx = field + skippedDelimiters;
                while (delIdx < delimiters.length()) {
                    char delim = delimiters.charAt(delIdx);
                    int pos = uri.indexOf(delim, lastPos);
                    if (pos != -1) {
                        foundPos = pos;
                        break;
                    }
                    ++skippedDelimiters;
                    ++delIdx;
                }
                if (foundPos != -1) {
                    retVal.put(uriParam.getName(), uri.substring(lastPos, foundPos));
                    lastPos = foundPos + 1;
                } else {
                    String v = uri.substring(lastPos);
                    String fieldName = null;
                    while (fieldName == null && uriParam != null) {
                        if (field == 0 && (uriParam.getRequired() == null || uriParam.getRequired().equalsIgnoreCase("false"))) {
                            uriParam = (Parameter)fieldMapping.get(++field);
                            continue;
                        }
                        fieldName = uriParam.getName();
                    }
                    retVal.put(fieldName, v);
                    break;
                }
            }
            ++field;
        }
        return retVal;
    }

    public static Object getTypedPropertyFromUri(AbstractCamelModelElement selectedEP, Parameter p, Component c) {
        String val = PropertiesUtils.getPropertyFromUri(selectedEP, p, c);
        if (CamelComponentUtils.isBooleanProperty(p)) {
            return Boolean.parseBoolean(val);
        }
        if (CamelComponentUtils.isTextProperty(p)) {
            return val;
        }
        if (CamelComponentUtils.isClassProperty(p) && !"element".equals(p.getKind())) {
            return val;
        }
        if (CamelComponentUtils.isNumberProperty(p)) {
            return val;
        }
        if (CamelComponentUtils.isCharProperty(p)) {
            return val;
        }
        return null;
    }

    public static void updateURIParams(AbstractCamelModelElement selectedEP, Parameter p, Object value, Component c, IObservableMap<?, ?> modelMap) {
        if ("path".equalsIgnoreCase(p.getKind())) {
            String newUri = String.valueOf(PropertiesUtils.updatePathParams(selectedEP, c, c.getSyntax(), p, value, PropertiesUtils.getPathProperties(selectedEP), modelMap)) + "?";
            for (Parameter uriParam : c.getParameters()) {
                if ("path".equalsIgnoreCase(uriParam.getKind())) continue;
                String pName = uriParam.getName();
                String pValue = PropertiesUtils.getPropertyFromUri(selectedEP, uriParam, c);
                if (pValue == null || pValue.trim().length() < 1 || uriParam.getDefaultValue() != null && uriParam.getDefaultValue().trim().length() > 0 && pValue.equals(uriParam.getDefaultValue())) continue;
                if (!newUri.endsWith("?")) {
                    newUri = String.valueOf(newUri) + "&";
                }
                newUri = String.valueOf(newUri) + String.format("%s=%s", pName, pValue);
            }
            if (newUri.endsWith("?")) {
                newUri = newUri.substring(0, newUri.length() - 1);
            }
            selectedEP.setParameter("uri", newUri);
        } else {
            boolean equalsDefaultValue = value != null && p.getDefaultValue() != null && value.toString().equals(p.getDefaultValue());
            boolean valueDeleted = value == null || value.toString().trim().length() < 1 || equalsDefaultValue && AbstractCamelModelElement.useOptimizedXML();
            String val = PropertiesUtils.getPropertyFromUri(selectedEP, p, c);
            String key = String.format("%s=", p.getName());
            String uri = (String)selectedEP.getParameter("uri");
            int idx = uri.indexOf(key);
            if (val != null && idx != -1) {
                boolean firstParam;
                String newUri = "";
                boolean bl = firstParam = idx == -1 || uri.charAt(idx - 1) == '?';
                if (valueDeleted) {
                    newUri = uri.substring(0, firstParam ? idx : idx - 1);
                } else {
                    newUri = uri.substring(0, idx + key.length());
                    newUri = String.valueOf(newUri) + value.toString();
                }
                newUri = String.valueOf(newUri) + uri.substring(idx + key.length() + val.length());
                if (newUri.indexOf("?&") != -1) {
                    newUri = newUri.replace("?&", "?");
                }
                if (newUri.endsWith("?")) {
                    newUri = newUri.substring(0, newUri.indexOf(63));
                }
                selectedEP.setParameter("uri", newUri);
            } else {
                String newUri = uri;
                if (!valueDeleted) {
                    if (uri.indexOf(63) == -1) {
                        newUri = String.valueOf(newUri) + "?";
                    }
                    if (uri.indexOf(61) != -1) {
                        newUri = String.valueOf(newUri) + "&";
                    }
                    newUri = String.valueOf(newUri) + String.format("%s=%s", p.getName(), value.toString());
                }
                selectedEP.setParameter("uri", newUri);
            }
        }
    }

    public static String updatePathParams(AbstractCamelModelElement selectedEP, Component component, String syntax, Parameter param, Object value, List<Parameter> pathParams, Map<?, ?> modelMap) {
        String withoutScheme = syntax.substring(syntax.indexOf(58) + 1);
        for (Parameter pparam : pathParams) {
            Object storedValue;
            String val = param.getName().equals(pparam.getName()) ? value.toString() : ((storedValue = modelMap.get(pparam.getName())) != null ? storedValue.toString() : PropertiesUtils.getPropertyFromUri(selectedEP, pparam, component));
            if (val == null || val.trim().length() < 1) {
                val = pparam.getDefaultValue();
            }
            if (val == null) continue;
            String newWithoutScheme = PropertiesUtils.replaceParts(withoutScheme, pparam.getName(), val, PATH_DELIMETER);
            withoutScheme = withoutScheme.equals(newWithoutScheme) ? withoutScheme.replace(pparam.getName(), val) : newWithoutScheme;
        }
        return String.format("%s:%s", syntax.substring(0, syntax.indexOf(58)), withoutScheme);
    }

    public static String replaceParts(String text, String target, String replacement, String delimiter) {
        return PropertiesUtils.replaceParts(text, target, replacement, Pattern.compile(delimiter));
    }

    public static String replaceParts(String text, String target, String replacement, Pattern delimiterPattern) {
        String[] parts = delimiterPattern.split(text);
        int i = 0;
        while (i < parts.length) {
            if (parts[i] != null && parts[i].equals(target)) {
                parts[i] = replacement;
            }
            ++i;
        }
        Matcher matcher = delimiterPattern.matcher(text);
        StringBuilder result = new StringBuilder(parts[0]);
        int i2 = 1;
        while (matcher.find()) {
            result.append(matcher.group()).append(parts[i2++]);
        }
        return result.toString();
    }

    public static String getUsedProtocol(AbstractCamelModelElement selectedEP) {
        return ((String)selectedEP.getParameter("uri")).substring(0, ((String)selectedEP.getParameter("uri")).indexOf(58));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPackageFragment getPackage(IJavaProject javaProject, IPackageFragmentRoot pkgFragmentRoot) {
        String packName = null;
        IJavaElement[] packages = null;
        try {
            if (pkgFragmentRoot == null) return null;
            if (!pkgFragmentRoot.exists()) return null;
            packages = pkgFragmentRoot.getChildren();
            if (packages.length == 1) {
                packName = javaProject.getElementName();
                IStatus status = PropertiesUtils.validatePackageName(packName, javaProject);
                if (status.getSeverity() != 0) return null;
                return pkgFragmentRoot.getPackageFragment(packName);
            }
            int noOfPackages = 0;
            IPackageFragment thePackage = null;
            IJavaElement[] iJavaElementArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (noOfPackages != true) return null;
                    packName = thePackage.getElementName();
                    return pkgFragmentRoot.getPackageFragment(packName);
                }
                IJavaElement pack = iJavaElementArray[n2];
                IPackageFragment pkg = (IPackageFragment)pack;
                if (!(pkg.hasSubpackages() && !pkg.hasChildren() || pkg.isDefaultPackage())) {
                    thePackage = pkg;
                    if (++noOfPackages > 1) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IStatus validatePackageName(String text, IJavaProject project) {
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validatePackageName((String)text, (IJavaElement)project);
    }

    public static boolean isRequired(Parameter parameter) {
        return PropertiesUtils.isParameterValueTrue(parameter.getRequired());
    }

    public static boolean isDeprecated(Parameter parameter) {
        return PropertiesUtils.isParameterValueTrue(parameter.getDeprecated());
    }

    private static boolean isParameterValueTrue(String parameterValue) {
        return parameterValue != null && parameterValue.equalsIgnoreCase("true");
    }

    public static boolean validateDuration(String value) throws IllegalArgumentException {
        CamelServiceManagerUtil.getManagerService().durationToMillis(value);
        return true;
    }

    public static String getCurrentProjectCamelVersion() {
        String camelVersion = "2.18.1.redhat-000021";
        IProject wsProject = CamelUtils.getCurrentProject();
        if (wsProject != null) {
            camelVersion = new CamelMavenUtils().getCamelVersionFromMaven(wsProject);
        }
        return camelVersion;
    }

    public static void initializePropertyNames(Map<String, Parameter> props) {
        for (Map.Entry<String, Parameter> entry : props.entrySet()) {
            Parameter parameter = entry.getValue();
            String name = entry.getKey();
            parameter.setName(name);
        }
    }

    public static void initializeComponentPropertyNames(Map<String, ComponentProperty> props) {
        for (Map.Entry<String, ComponentProperty> entry : props.entrySet()) {
            ComponentProperty componentProperty = entry.getValue();
            String name = entry.getKey();
            componentProperty.setName(name);
        }
    }
}

