/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;

final class SearchLatestBomVersionAvailableM2ECallable
implements ICallable<String> {
    private Dependency bomUsed;
    private List<Repository> repositories;

    SearchLatestBomVersionAvailableM2ECallable(List<Repository> repositories, Dependency bomUsed) {
        this.repositories = repositories;
        this.bomUsed = bomUsed;
    }

    public String call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
        VersionRangeRequest request = new VersionRangeRequest();
        request.setArtifact((Artifact)new DefaultArtifact(this.bomUsed.getGroupId(), this.bomUsed.getArtifactId(), this.bomUsed.getType(), "(0,]"));
        request.setRepositories(this.repositories.stream().map(repo -> new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl()).build()).collect(Collectors.toList()));
        try {
            RepositorySystemSession repositorySession = context.getRepositorySession();
            VersionRangeResult result = this.retrieveRepositorySystem().resolveVersionRange(repositorySession, request);
            List productizedversion = result.getVersions().stream().filter(version -> {
                String versionAsString = version.toString();
                return versionAsString.contains("fuse") || versionAsString.contains("redhat");
            }).collect(Collectors.toList());
            VersionRangeResult versionRangeResultForProductizedVersion = new VersionRangeResult(request);
            versionRangeResultForProductizedVersion.setVersions(productizedversion);
            Version productizedHighestVersion = versionRangeResultForProductizedVersion.getHighestVersion();
            if (productizedHighestVersion != null) {
                return productizedHighestVersion.toString();
            }
            Version highestVersion = result.getHighestVersion();
            if (highestVersion != null) {
                return highestVersion.toString();
            }
        }
        catch (VersionRangeResolutionException e) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)e);
        }
        return null;
    }

    private RepositorySystem retrieveRepositorySystem() {
        return (RepositorySystem)((MavenImpl)MavenPlugin.getMaven()).lookupComponent(RepositorySystem.class);
    }
}

