/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;

public class CamelModelPatcher {
    private static final String CAMEL_VERSION_FIXING_CAMEL_CONTEXT_IN_CATALOG = "2.18.0";

    private CamelModelPatcher() {
    }

    public static void applyVersionSpecificCatalogFixes(CamelCatalog catalog, CamelModel loadedModel) {
        String camelVersion = catalog.getLoadedVersion();
        if (camelVersion == null) {
            return;
        }
        CamelModelPatcher.applyMissingOneOfValuesForExpressionsPatch(loadedModel);
        CamelModelPatcher.applyMissingWhenChildDefinitionForChoice(loadedModel);
        CamelModelPatcher.applyFixesToComponentsSyntax(loadedModel);
        CamelModelPatcher.applyMissingCamelContextEip(camelVersion, loadedModel);
    }

    private static void applyMissingCamelContextEip(String camelVersion, CamelModel loadedModel) {
        Eip eipLoadedFromInitialCatalog = loadedModel.getEip("camelContext");
        if (CAMEL_VERSION_FIXING_CAMEL_CONTEXT_IN_CATALOG.compareTo(camelVersion) > 0 && eipLoadedFromInitialCatalog == null) {
            Eip camelContextEip = CamelModelPatcher.getCamelContextModelForVersion(camelVersion);
            loadedModel.addEip(camelContextEip);
        }
    }

    protected static Eip getCamelContextModelForVersion(String camelVersion) {
        String versionRange = "2.17.x";
        if ("2.11".compareTo(camelVersion) > 0) {
            versionRange = "2.10.x";
        } else if ("2.12".compareTo(camelVersion) > 0) {
            versionRange = "2.11.x";
        } else if ("2.13".compareTo(camelVersion) > 0) {
            versionRange = "2.12.x";
        } else if ("2.14".compareTo(camelVersion) > 0) {
            versionRange = "2.13.x";
        } else if ("2.15".compareTo(camelVersion) > 0) {
            versionRange = "2.14.x";
        } else if ("2.16".compareTo(camelVersion) > 0) {
            versionRange = "2.15.x";
        } else if ("2.17".compareTo(camelVersion) > 0) {
            versionRange = "2.16.x";
        }
        InputStream inputStream = CamelModelPatcher.class.getResourceAsStream("camelContext-" + versionRange + ".json");
        return Eip.getJSONFactoryInstance((InputStream)inputStream);
    }

    private static void applyMissingOneOfValuesForExpressionsPatch(CamelModel loadedModel) {
        for (Eip eip : loadedModel.getEips()) {
            if (eip == null) continue;
            CamelModelPatcher.ensureAllParametersWithOneOfContainsAllPossibleValues(eip);
        }
    }

    private static void ensureAllParametersWithOneOfContainsAllPossibleValues(Eip eip) {
        for (Parameter p : eip.getParameters()) {
            if (!"expression".equalsIgnoreCase(p.getKind())) continue;
            CamelModelPatcher.ensureOneOfContainsAllPossiblevalues(p);
        }
    }

    private static void ensureOneOfContainsAllPossiblevalues(Parameter p) {
        ArrayList<String> possibleValues = new ArrayList<String>();
        possibleValues.addAll(Arrays.asList(p.getOneOf()));
        CamelModelPatcher.ensureListContains(possibleValues, "vtdxml");
        CamelModelPatcher.ensureListContains(possibleValues, "xpath");
        CamelModelPatcher.ensureListContains(possibleValues, "xquery");
        CamelModelPatcher.ensureListContains(possibleValues, "xtokenize");
        p.setOneOf((String[])possibleValues.stream().toArray(String[]::new));
    }

    private static void ensureListContains(List<String> possibleValues, String possibleExpressionLanguage) {
        if (!possibleValues.contains(possibleExpressionLanguage)) {
            possibleValues.add(possibleExpressionLanguage);
        }
    }

    private static void applyMissingWhenChildDefinitionForChoice(CamelModel loadedModel) {
        Eip choiceEip = loadedModel.getEip("choice");
        if (choiceEip != null) {
            for (Parameter p : choiceEip.getParameters()) {
                CamelModelPatcher.applyMissingWhenChildDefinitionForChoice(p);
            }
        }
    }

    private static void applyMissingWhenChildDefinitionForChoice(Parameter p) {
        if ("array".equalsIgnoreCase(p.getType()) && "element".equalsIgnoreCase(p.getKind())) {
            if (p.getOneOf() == null) {
                p.setOneOf(new String[0]);
            }
            ArrayList<String> possibleChildren = new ArrayList<String>();
            possibleChildren.addAll(Arrays.asList(p.getOneOf()));
            if (!possibleChildren.contains("when")) {
                possibleChildren.add("when");
                p.setOneOf((String[])possibleChildren.stream().toArray(String[]::new));
            }
        }
    }

    private static void applyFixesToComponentsSyntax(CamelModel loadedModel) {
        CamelModelPatcher.applyFixToComponent(loadedModel, "google-drive", "google-drive:drive:apiName/methodName", "google-drive:apiName/methodName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "couchbase", "couchbase:url", "couchbase:protocol:hostname");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-messaging", "ignite-messaging:[topic]", "ignite-messaging:topic");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-queue", "ignite-queue:[name]", "ignite-queue:name");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-compute", "ignite-compute:[endpointId]", "ignite-compute:endpointId");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-idgen", "ignite-idgen:[name]", "ignite-idgen:name");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-cache", "ignite-cache:[cacheName]", "ignite-cache:cacheName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-set", "ignite-set:[name]", "ignite-set:name");
        CamelModelPatcher.applyFixToComponent(loadedModel, "ignite-events", "ignite-events:[endpointId]", "ignite-events:endpointId");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-set", "atomix-set:setName", "atomix-set:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-value", "atomix-value:valueName", "atomix-value:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-queue", "atomix-queue:queueName", "atomix-queue:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-map", "atomix-map:mapName", "atomix-map:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-multimap", "atomix-multimap:multiMapName", "atomix-multimap:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "atomix-messaging", "atomix-messaging:group", "atomix-messaging:resourceName");
        CamelModelPatcher.applyFixToComponent(loadedModel, "iec60870-client", "iec60870-client:endpointUri", "iec60870-client:uriPath");
        CamelModelPatcher.applyFixToComponent(loadedModel, "iec60870-server", "iec60870-server:endpointUri", "iec60870-server:uriPath");
    }

    private static void applyFixToComponent(CamelModel loadedModel, String componentScheme, String invalidSyntaxBugFromOlderVersion, String correctSyntax) {
        Component c = loadedModel.getComponent(componentScheme);
        if (c != null && invalidSyntaxBugFromOlderVersion.equalsIgnoreCase(c.getSyntax())) {
            c.setSyntax(correctSyntax);
        }
    }
}

