/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class ReflectionHelper {
    public static Method getDeclaredMethod(Class<?> aClass, String name) throws NoSuchMethodException {
        try {
            return aClass.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = aClass.getSuperclass();
            if (aClass == Object.class || superclass == null) {
                throw e;
            }
            return ReflectionHelper.getDeclaredMethod(superclass, name);
        }
    }

    public static void setField(Object owner, String name, Object newValue, Class<?> definedIn) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionHelper.getFieldDescriptor(owner, name, definedIn);
        field.set(owner, newValue);
    }

    public static Field getDeclaredField(Class<?> aClass, String name) throws NoSuchFieldException {
        try {
            return aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = aClass.getSuperclass();
            if (aClass == Object.class || superclass == null) {
                throw e;
            }
            return ReflectionHelper.getDeclaredField(superclass, name);
        }
    }

    public static <T> T[] getArrayOf(Collection<?> coll, Class<T> aType) {
        ArrayList<T> answer = new ArrayList<T>(coll.size());
        for (Object element : coll) {
            if (!aType.isInstance(element)) continue;
            answer.add(aType.cast(element));
        }
        Object[] array = (Object[])Array.newInstance(aType, answer.size());
        return answer.toArray(array);
    }

    public static <T> T getField(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionHelper.getFieldDescriptor(instance, fieldName, aClass);
        return (T)field.get(instance);
    }

    public static Field getFieldDescriptor(Object instance, String fieldName) throws NoSuchFieldException {
        Class<?> aClass = instance.getClass();
        while (true) {
            try {
                return ReflectionHelper.getFieldDescriptor(instance, fieldName, aClass);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass;
                if (aClass != Object.class && (superclass = aClass.getSuperclass()) != null && superclass != Object.class && superclass != aClass) {
                    aClass = superclass;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static Field getFieldDescriptor(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException {
        ReflectionHelper.notNull(instance, "instance");
        Field field = aClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Method getMethodDescriptor(Object instance, String methodName, Class<? extends Object> aClass, Class<?> ... parameters) throws NoSuchMethodException {
        ReflectionHelper.notNull(instance, "instance");
        Method method = aClass.getDeclaredMethod(methodName, parameters);
        method.setAccessible(true);
        return method;
    }

    public static <T> T notNull(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

