/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.fusesource.ide.foundation.ui.actions.Messages;
import org.fusesource.ide.foundation.ui.config.ColumnConfiguration;
import org.fusesource.ide.foundation.ui.config.TableConfiguration;
import org.fusesource.ide.foundation.ui.util.IConfigurableColumns;
import org.fusesource.ide.foundation.ui.util.Viewers;

public class ConfigureColumnsDialog
extends ViewSettingsDialog {
    CheckboxTableViewer columnsViewer;
    private Button upButton;
    private Button downButton;
    private Button topButton;
    private Button bottomButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private IConfigurableColumns columns;
    private TableConfiguration configuration;

    protected ConfigureColumnsDialog(IConfigurableColumns columns) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.columns = columns;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.configureColumnsTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createColumnsViewer(inner);
        this.createButtons(inner);
        this.loadPreference();
        ConfigureColumnsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        this.storePreference();
        this.columns.updateColumnConfiguration(this.configuration);
        super.okPressed();
    }

    protected void performDefaults() {
        this.configuration.clear();
        this.columns.updateColumnConfiguration(null);
        this.loadPreference();
        Viewers.refresh((Viewer)this.columnsViewer);
    }

    private void createColumnsViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.configureColumnsMessage);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.columnsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        this.columnsViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.columnsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ColumnConfiguration) {
                    ColumnConfiguration config = (ColumnConfiguration)element;
                    return config.getName();
                }
                return super.getText(element);
            }
        });
        this.columnsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.topButton = new Button(composite, 8);
        this.topButton.setText(Messages.topLabel);
        this.setButtonLayoutData(this.topButton);
        this.topButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.moveTop(ConfigureColumnsDialog.this.selectedList());
            }
        });
        this.upButton = new Button(composite, 8);
        this.upButton.setText(Messages.upLabel);
        this.setButtonLayoutData(this.upButton);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.moveUp(ConfigureColumnsDialog.this.selectedList());
            }
        });
        this.downButton = new Button(composite, 8);
        this.downButton.setText(Messages.downLabel);
        this.setButtonLayoutData(this.downButton);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.moveDown(ConfigureColumnsDialog.this.selectedList());
            }
        });
        this.bottomButton = new Button(composite, 8);
        this.bottomButton.setText(Messages.bottomLabel);
        this.setButtonLayoutData(this.bottomButton);
        this.bottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.moveBottom(ConfigureColumnsDialog.this.selectedList());
            }
        });
        new Label(composite, 0);
        this.selectAllButton = new Button(composite, 8);
        this.selectAllButton.setText(Messages.selectAllLabel);
        this.setButtonLayoutData(this.selectAllButton);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.columnsViewer.setAllChecked(true);
            }
        });
        this.deselectAllButton = new Button(composite, 8);
        this.deselectAllButton.setText(Messages.deselectAllLabel);
        this.setButtonLayoutData(this.deselectAllButton);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureColumnsDialog.this.columnsViewer.setAllChecked(false);
            }
        });
    }

    private void loadPreference() {
        this.configuration = this.columns.getConfiguration();
        List<ColumnConfiguration> columnList = this.configuration.getColumnConfigurations();
        ArrayList<ColumnConfiguration> checkedList = new ArrayList<ColumnConfiguration>(columnList.size());
        for (ColumnConfiguration column : columnList) {
            if (!column.isVisible()) continue;
            checkedList.add(column);
        }
        this.columnsViewer.setInput(columnList);
        this.columnsViewer.setCheckedElements(checkedList.toArray());
    }

    private void storePreference() {
        HashSet<Object> checkedColumns = new HashSet<Object>(Arrays.asList(this.columnsViewer.getCheckedElements()));
        List<ColumnConfiguration> list = this.getColumns();
        this.configuration.setColumnConfigurations(list);
        for (ColumnConfiguration column : list) {
            boolean checked = checkedColumns.contains(column);
            column.setVisible(checked);
        }
        this.configuration.flush();
    }

    private List<ColumnConfiguration> getColumns() {
        return (List)this.columnsViewer.getInput();
    }

    void moveUp(List<ColumnConfiguration> items) {
        if (!items.isEmpty() && !items.get(0).equals(this.getColumns().get(0))) {
            for (ColumnConfiguration item : items) {
                this.moveUp(item);
            }
        }
    }

    protected void moveTop(List<ColumnConfiguration> selectedList) {
        ArrayList<ColumnConfiguration> reverseOrder = new ArrayList<ColumnConfiguration>(selectedList);
        Collections.reverse(reverseOrder);
        for (ColumnConfiguration config : reverseOrder) {
            this.moveTop(config);
        }
    }

    protected void moveBottom(List<ColumnConfiguration> selectedList) {
        for (ColumnConfiguration config : selectedList) {
            this.moveBottom(config);
        }
    }

    private void moveTop(ColumnConfiguration item) {
        ArrayList<ColumnConfiguration> newColumns = new ArrayList<ColumnConfiguration>();
        newColumns.add(item);
        for (ColumnConfiguration column : this.getColumns()) {
            if (column.equals(item)) continue;
            newColumns.add(column);
        }
        this.columnsViewer.setInput(newColumns);
    }

    private void moveBottom(ColumnConfiguration item) {
        ArrayList<ColumnConfiguration> newColumns = new ArrayList<ColumnConfiguration>();
        for (ColumnConfiguration column : this.getColumns()) {
            if (column.equals(item)) continue;
            newColumns.add(column);
        }
        newColumns.add(item);
        this.columnsViewer.setInput(newColumns);
    }

    void moveDown(List<ColumnConfiguration> items) {
        if (!items.isEmpty() && !items.get(items.size() - 1).equals(this.getColumns().get(this.getColumns().size() - 1))) {
            int i = items.size() - 1;
            while (i >= 0) {
                this.moveDown(items.get(i));
                --i;
            }
        }
    }

    private void moveUp(ColumnConfiguration item) {
        ColumnConfiguration movedColumn = null;
        ArrayList<ColumnConfiguration> newColumns = new ArrayList<ColumnConfiguration>();
        for (ColumnConfiguration column : this.getColumns()) {
            if (!column.equals(item) || movedColumn == null) {
                newColumns.add(column);
                movedColumn = column;
                continue;
            }
            newColumns.remove(movedColumn);
            newColumns.add(column);
            newColumns.add(movedColumn);
        }
        this.columnsViewer.setInput(newColumns);
    }

    private void moveDown(ColumnConfiguration item) {
        ColumnConfiguration movedColumn = null;
        ArrayList<ColumnConfiguration> newColumns = new ArrayList<ColumnConfiguration>();
        for (ColumnConfiguration column : this.getColumns()) {
            if (column.equals(item)) {
                movedColumn = item;
                continue;
            }
            newColumns.add(column);
            if (movedColumn == null) continue;
            newColumns.add(movedColumn);
            movedColumn = null;
        }
        this.columnsViewer.setInput(newColumns);
    }

    protected List selectedList() {
        return ((IStructuredSelection)this.columnsViewer.getSelection()).toList();
    }
}

