/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.archetypes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.fusesource.ide.foundation.ui.archetypes.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArchetypeHelper {
    private static String archetypeDescriptorUri = "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0";
    private static String requiredPropertyXPath = "/ad:archetype-descriptor/ad:requiredProperties/ad:requiredProperty";
    private InputStream archetypeIn;
    private File outputDir;
    private String groupId;
    private String artifactId;
    private String version;
    private String packageName = "";
    private Boolean verbose = Boolean.FALSE;
    private Boolean createDefaultDirectories = Boolean.TRUE;
    private Map<String, String> overrideProperties = new HashMap<String, String>();
    private String zipEntryPrefix = "archetype-resources/";
    private List<String> binarySuffixes = Arrays.asList(".png", ".ico", ".gif", ".jpg", ".jpeg", ".bmp");
    protected String webInfResources = "src/main/webapp/WEB-INF/resources";
    protected Pattern sourcePathRegexPattern = Pattern.compile("(src/(main|test)/(java)/)(.*)");

    public ArchetypeHelper(InputStream archetypeIn, File outputDir, String groupId, String artifactId) {
        this(archetypeIn, outputDir, groupId, artifactId, "1.0-SNAPSHOT");
    }

    public ArchetypeHelper(InputStream archetypeIn, File outputDir, String groupId, String artifactId, String version) {
        this.archetypeIn = archetypeIn;
        this.outputDir = outputDir;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    private void info(String s) {
        System.out.println(s);
    }

    private void debug(String s) {
        if (this.verbose.booleanValue()) {
            System.out.println(s);
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOverrideProperties(Map<String, String> overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public int execute() throws IOException {
        String[] stringArray;
        this.outputDir.mkdirs();
        if (this.packageName == null || this.packageName.length() == 0) {
            this.packageName = String.valueOf(this.groupId) + "." + this.artifactId;
        }
        String packageDir = this.packageName.replace('.', '/');
        this.info("Creating archetype using Maven groupId: " + this.groupId + ", artifactId: " + this.artifactId + ", version: " + this.version + " in directory: " + this.outputDir);
        HashMap<String, String> replaceProperties = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zip = new ZipInputStream(this.archetypeIn);){
                boolean bl;
                boolean bl2 = true;
                while (bl) {
                    block44: {
                        ZipEntry entry = zip.getNextEntry();
                        if (entry == null) {
                            bl = false;
                            continue;
                        }
                        if (!entry.isDirectory()) {
                            String fullName = entry.getName();
                            if (fullName != null && fullName.startsWith(this.zipEntryPrefix)) {
                                String dirName;
                                String name = this.replaceFileProperties(fullName.substring(this.zipEntryPrefix.length()), replaceProperties);
                                this.debug("Processing resource: " + name);
                                int idx = name.lastIndexOf(47);
                                Matcher matcher = this.sourcePathRegexPattern.matcher(name);
                                if (this.packageName.length() > 0 && idx > 0 && matcher.matches()) {
                                    String prefix = matcher.group(1);
                                    dirName = String.valueOf(prefix) + packageDir + "/" + name.substring(prefix.length());
                                } else {
                                    dirName = this.packageName.length() > 0 && name.startsWith(this.webInfResources) ? "src/main/webapp/WEB-INF/" + packageDir + "/resources" + name.substring(this.webInfResources.length()) : name;
                                }
                                File file = new File(this.outputDir, dirName);
                                file.getParentFile().mkdirs();
                                stringArray = null;
                                Object object = null;
                                try (FileOutputStream out = new FileOutputStream(file);){
                                    boolean isBinary = false;
                                    for (String suffix : this.binarySuffixes) {
                                        if (!name.endsWith(suffix)) continue;
                                        isBinary = true;
                                        break;
                                    }
                                    if (isBinary) {
                                        ArchetypeHelper.copy(zip, out);
                                        break block44;
                                    }
                                    Throwable throwable2 = null;
                                    Iterator<String> throwable3 = null;
                                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                                        ArchetypeHelper.copy(zip, bos);
                                        String text = new String(bos.toByteArray(), StandardCharsets.UTF_8);
                                        out.write(this.transformContents(text, replaceProperties).getBytes(StandardCharsets.UTF_8));
                                        break block44;
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable4;
                                        } else if (throwable2 != throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (Throwable object2) {
                                    if (stringArray == null) {
                                        stringArray = object2;
                                    } else if (stringArray != object2) {
                                        stringArray.addSuppressed((Throwable)object2);
                                    }
                                    throw stringArray;
                                }
                            }
                            if (fullName != null && fullName.equals("META-INF/maven/archetype-metadata.xml")) {
                                this.parseReplaceProperties(zip, replaceProperties);
                                replaceProperties.putAll(this.overrideProperties);
                            }
                        }
                    }
                    zip.closeEntry();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.info("Using replace properties: " + replaceProperties);
        if (!replaceProperties.isEmpty()) {
            File pom = new File(this.outputDir, "pom.xml");
            FileReader reader = new FileReader(pom);
            String text = IOUtils.toString((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            for (Map.Entry entry : replaceProperties.entrySet()) {
                text = this.replaceVariable(text, (String)entry.getKey(), (String)entry.getValue());
            }
            FileWriter fileWriter = new FileWriter(pom);
            IOUtils.write((String)text, (Writer)fileWriter);
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        if (this.createDefaultDirectories.booleanValue()) {
            File srcDir = new File(this.outputDir, "src");
            File mainDir = new File(srcDir, "main");
            File testDir = new File(srcDir, "test");
            String string = "java";
            File[] fileArray = new File[]{mainDir, testDir};
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                stringArray = new String[]{String.valueOf(string) + "/" + packageDir, "resources"};
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    new File(dir, name).mkdirs();
                    ++n4;
                }
                ++n2;
            }
        }
        return 0;
    }

    public Map<String, String> parseProperties() throws IOException {
        HashMap<String, String> replaceProperties = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipInputStream zip = new ZipInputStream(this.archetypeIn);){
                boolean ok = true;
                while (ok) {
                    String fullName;
                    ZipEntry entry = zip.getNextEntry();
                    if (entry == null) {
                        ok = false;
                        continue;
                    }
                    if (!entry.isDirectory() && (fullName = entry.getName()) != null && fullName.equals("META-INF/maven/archetype-metadata.xml")) {
                        this.parseReplaceProperties(zip, replaceProperties);
                    }
                    zip.closeEntry();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        return replaceProperties;
    }

    protected void parseReplaceProperties(ZipInputStream zip, Map<String, String> replaceProperties) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ArchetypeHelper.copy(zip, bos);
        Map<String, String> requiredPropertiesFromOriginal = ArchetypeHelper.getArchetypeRequiredProperties(bos, false, false);
        replaceProperties.putAll(requiredPropertiesFromOriginal);
    }

    protected String transformContents(String fileContents, Map<String, String> replaceProperties) {
        String answer = this.removeInvalidHeaderCommentsAndProcessVelocityMacros(fileContents);
        answer = this.replaceVariable(answer, "package", this.packageName);
        answer = this.replaceVariable(answer, "packageName", this.packageName);
        answer = this.replaceAllVariable(answer, "groupId", this.groupId);
        answer = this.replaceAllVariable(answer, "artifactId", this.artifactId);
        answer = this.replaceAllVariable(answer, "version", this.version);
        for (Map.Entry<String, String> e : replaceProperties.entrySet()) {
            answer = this.replaceVariable(answer, e.getKey(), e.getValue());
        }
        return answer;
    }

    protected String removeInvalidHeaderCommentsAndProcessVelocityMacros(String text) {
        String[] lines;
        String answer = "";
        String[] stringArray = lines = text.split("\r?\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String l = line.trim();
            if (!l.startsWith("##") && !l.startsWith("#set(")) {
                if (line.contains("${D}")) {
                    line = line.replaceAll("\\$\\{D\\}", "\\$");
                }
                answer = answer.concat(line);
                answer = answer.concat("\n");
            }
            ++n2;
        }
        return answer;
    }

    protected String replaceFileProperties(String fileName, Map<String, String> replaceProperties) {
        String answer = fileName;
        for (Map.Entry<String, String> e : replaceProperties.entrySet()) {
            answer = answer.replace("__" + e.getKey() + "__", e.getValue());
        }
        return answer;
    }

    protected String replaceVariable(String text, String name, String value) {
        if (value.contains("}")) {
            System.out.println("Ignoring dodgy value '" + value + "'");
            return text;
        }
        return text.replaceAll(Pattern.quote("${" + name + "}"), value);
    }

    protected String replaceAllVariable(String text, String name, String value) {
        String answer = text.replaceAll(Pattern.quote("${" + name + "}"), value);
        answer = answer.replaceAll(Pattern.quote("$" + name), value);
        return answer;
    }

    private static long copy(InputStream in, OutputStream out) throws IOException {
        long bytesCopied = 0L;
        byte[] buffer = new byte[16384];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return bytesCopied;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getArchetypeRequiredProperties(URL jarURL) throws IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Map<String, String> map;
            ZipInputStream zis = new ZipInputStream(jarURL.openStream());
            try {
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    try {
                        if (entry.isDirectory() || !"META-INF/maven/archetype-metadata.xml".equals(entry.getName())) continue;
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ArchetypeHelper.copy(zis, bos);
                        bos.flush();
                        map = ArchetypeHelper.getArchetypeRequiredProperties(bos, true, true);
                        return map;
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
                return Collections.EMPTY_MAP;
            }
            finally {
                if (zis == null) return map;
                zis.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static Map<String, String> getArchetypeRequiredProperties(ByteArrayOutputStream copyOfArchetypeJar, boolean excludeDepVersionProperties, boolean defaultAllProperties) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(copyOfArchetypeJar.toByteArray()));
        Document document = db.parse(inputSource);
        XPath xpath = XPathFactory.newInstance().newXPath();
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.registerMapping("ad", archetypeDescriptorUri);
        xpath.setNamespaceContext(nsContext);
        NodeList properties = (NodeList)xpath.evaluate(requiredPropertyXPath, document, XPathConstants.NODESET);
        int p = 0;
        while (p < properties.getLength()) {
            Element requiredProperty = (Element)properties.item(p);
            String key = requiredProperty.getAttribute("key");
            if (!excludeDepVersionProperties || !key.startsWith("version") && !key.endsWith("version")) {
                NodeList children = requiredProperty.getElementsByTagNameNS(archetypeDescriptorUri, "defaultValue");
                String value = "";
                if (children.getLength() == 1 && children.item(0).hasChildNodes()) {
                    value = children.item(0).getTextContent();
                } else if (("name".equals(key) || defaultAllProperties) && value.isEmpty()) {
                    value = "HelloWorld";
                }
                propertiesMap.put(key, value);
            }
            ++p;
        }
        return propertiesMap;
    }
}

