/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.fusesource.ide.foundation.ui.form.Forms;
import org.fusesource.ide.foundation.ui.form.MandatoryComboValidator;
import org.fusesource.ide.foundation.ui.form.MandatoryValidator;
import org.fusesource.ide.foundation.ui.util.ICanValidate;

public abstract class FormSupport
implements PropertyChangeListener {
    private ICanValidate validator;
    private FontMetrics fontMetrics;
    private FormToolkit toolkit;
    private IMessageManager messageManager;
    private ScrolledForm form;
    private DataBindingContext dataBindingContext = new DataBindingContext();
    private Set<String> mandatoryPropertyNames = new HashSet<String>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public FormSupport() {
    }

    public FormSupport(ICanValidate validator) {
        this.validator = validator;
    }

    public abstract void setFocus();

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.propertyChangeSupport.firePropertyChange(e);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    public DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    public IMessageManager getMessageManager() {
        return this.messageManager;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected void addMandatoryPropertyNames(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            this.mandatoryPropertyNames.add(n3);
            ++n2;
        }
    }

    protected void initializeFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public Control getControl() {
        return this.form.getContent();
    }

    public void createForm(Composite parent) {
        this.initializeFontMetrics((Control)parent);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.messageManager = this.form.getMessageManager();
        Form formChild = this.form.getForm();
        String header = this.getFormHeader();
        if (header != null) {
            formChild.setText(header);
        }
        this.toolkit.decorateFormHeading(formChild);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)layout);
    }

    protected String getFormHeader() {
        return null;
    }

    public Composite createSectionComposite(String text, GridData gridData) {
        int sectionStyle = 384;
        if (text != null) {
            sectionStyle |= 0x42;
        }
        Section section = this.toolkit.createSection(this.form.getBody(), sectionStyle);
        if (text != null) {
            section.setText(text);
        }
        section.setLayoutData((Object)gridData);
        Composite inner = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)inner);
        inner.setLayoutData((Object)gridData);
        return inner;
    }

    protected Label createLabel(Composite inner, String text) {
        return this.toolkit.createLabel(inner, text);
    }

    protected Label createLabel(Composite inner, String text, int flags) {
        return this.toolkit.createLabel(inner, text, flags);
    }

    protected Text createText(Composite inner) {
        return this.createText(inner, 2048);
    }

    protected Text createText(Composite inner, int flags) {
        Text answer = this.toolkit.createText(inner, "", flags);
        GridData gdata = new GridData(768);
        answer.setLayoutData((Object)gdata);
        answer.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                FormSupport.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                FormSupport.this.validate();
            }
        });
        return answer;
    }

    protected Text createTextArea(Composite inner) {
        return this.createTextArea(inner, 2882);
    }

    protected Text createTextArea(Composite inner, int flags) {
        Text answer = this.toolkit.createText(inner, "", flags);
        GridData gdata = new GridData(4, 4, true, true);
        answer.setLayoutData((Object)gdata);
        answer.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                FormSupport.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                FormSupport.this.validate();
            }
        });
        return answer;
    }

    protected Text createBeanPropertyPasswordField(Composite parent, Object bean, String propertyName, String labelText, String tooltip) {
        return this.createBeanPropertyTextField(parent, bean, propertyName, labelText, tooltip, 0x400800);
    }

    protected Text createBeanPropertyTextField(Composite parent, Object bean, String propertyName, String labelText, String tooltip) {
        return this.createBeanPropertyTextField(parent, bean, propertyName, labelText, tooltip, 2048);
    }

    protected Text createBeanPropertyTextField(Composite parent, Object bean, String propertyName, String labelText, String tooltip, int flags) {
        this.createLabel(parent, labelText);
        Text text = this.createText(parent, flags);
        text.setToolTipText(tooltip);
        ISWTObservableValue textValue = Forms.observe(text);
        Forms.bindBeanProperty(this.getDataBindingContext(), this.getMessageManager(), bean, propertyName, this.isMandatory(bean, propertyName), labelText, (IObservableValue)textValue, (Control)text);
        return text;
    }

    protected ComboViewer createBeanPropertyCombo(Composite parent, Object bean, String propertyName, String labelText, String tooltip, int flags) {
        this.createLabel(parent, labelText);
        ComboViewer combo = new ComboViewer(parent, flags);
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IViewerObservableValue comboValue = ViewersObservables.observeSingleSelection((Viewer)combo);
        Control control = combo.getControl();
        GridData gdata = new GridData(4, 0x1000000, true, false);
        gdata.widthHint = 400;
        control.setLayoutData((Object)gdata);
        MandatoryValidator validator = null;
        if (this.isMandatory(bean, propertyName)) {
            validator = control instanceof Combo ? new MandatoryComboValidator(labelText, (Combo)control) : new MandatoryValidator(labelText);
        }
        Forms.bindBeanProperty(this.getDataBindingContext(), this.getMessageManager(), bean, propertyName, validator, (IObservableValue)comboValue, control);
        this.toolkit.adapt(control, true, true);
        return combo;
    }

    protected ListViewer createBeanPropertyList(Composite parent, Object bean, String propertyName, String labelText, String tooltip, int flags) {
        this.createLabel(parent, labelText);
        ListViewer combo = new ListViewer(parent, flags);
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IViewerObservableValue comboValue = ViewersObservables.observeSingleSelection((Viewer)combo);
        Control control = combo.getControl();
        GridData gdata = new GridData(1808);
        control.setLayoutData((Object)gdata);
        Forms.bindBeanProperty(this.getDataBindingContext(), this.getMessageManager(), bean, propertyName, this.isMandatory(bean, propertyName), labelText, (IObservableValue)comboValue, control);
        this.toolkit.adapt(control, true, true);
        combo.refresh();
        return combo;
    }

    public boolean isValid() {
        return Forms.isValid(this.getDataBindingContext());
    }

    protected boolean isMandatory(Object bean, String propertyName) {
        return this.mandatoryPropertyNames.contains(propertyName);
    }

    protected void validate() {
        if (this.validator != null) {
            this.validator.validate();
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)dlus);
    }

    public Control createDialogArea(Composite parent) {
        this.createForm(parent);
        this.createTextFields(parent);
        return parent;
    }

    protected abstract void createTextFields(Composite var1);

    public abstract void okPressed();
}

