/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.editor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.fusesource.ide.foundation.core.util.IOUtils;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;

public class CamelContextNodeEditorInput
extends CamelXMLEditorInput {
    private final CamelContextNode contextNode;
    private String contextId;

    public CamelContextNodeEditorInput(CamelContextNode contextNode, IFile camelContextTempFile) {
        super(camelContextTempFile, null);
        this.contextNode = contextNode;
        this.contextId = contextNode.getContextId();
        this.setSelectedContainerId(this.contextId);
    }

    public String getName() {
        String name = "Remote CamelContext: " + this.contextId;
        if (this.contextNode.isConnectionAvailable()) {
            return "<connected>" + name;
        }
        return "<disconnected>" + name;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public void onEditorInputSave() {
        super.onEditorInputSave();
        if (this.contextNode.isConnectionAvailable()) {
            try {
                this.getCamelContextFile().getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                String xml = IOUtils.loadText((InputStream)this.getCamelContextFile().getContents(), (String)StandardCharsets.UTF_8.name());
                this.contextNode.updateXml(xml);
            }
            catch (IOException | CoreException ex) {
                CamelJMXPlugin.getLogger().error("Error saving changes to remote camel context " + this.contextId, ex);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.contextNode.dispose();
    }
}

