/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelRouteMBean;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.Messages;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.jmx.camel.navigator.RoutesNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class RouteNode
extends ProcessorNodeSupport
implements ImageProvider {
    private final RoutesNode routesNode;
    private final CamelRouteElement route;
    private CamelRouteMBean routeMBean;

    public RouteNode(RoutesNode routesNode, CamelRouteElement route) {
        super((Node)routesNode, route);
        this.routesNode = routesNode;
        this.route = route;
    }

    public RoutesNode getRoutesNode() {
        return this.routesNode;
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.getRoutesNode().getCamelContextNode();
    }

    public String toString() {
        return Strings.getOrElse((Object)this.getRouteId(), (String)"Route");
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage(this.route.getIconName().replaceAll(".png", "16.png"));
    }

    protected void loadChildren() {
        List children = this.route.getChildElements();
        for (AbstractCamelModelElement node : children) {
            if (node.getInputElement() != null) continue;
            this.addChild((Node)new ProcessorNode(this, (Node)this, node));
        }
    }

    public CamelRouteMBean getRouteMBean() {
        return this.routeMBean;
    }

    public void setRouteMBean(CamelRouteMBean mbean) {
        this.routeMBean = mbean;
        this.setPropertyBean(this.routeMBean);
    }

    public void provideContextMenu(IMenuManager menu) {
        Function1<IMenuManager, Void> fn = new Function1<IMenuManager, Void>(){

            public Void apply(IMenuManager mm) {
                if (RouteNode.this.isMBeanStarted()) {
                    Action stopRouteAction = new Action(Messages.StopRouteAction, 32){

                        public void run() {
                            RouteNode.this.stopMBean();
                        }
                    };
                    stopRouteAction.setToolTipText(Messages.StopRouteActionToolTip);
                    stopRouteAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("stop_task.gif"));
                    mm.add((IAction)stopRouteAction);
                } else {
                    Action startRouteAction = new Action(Messages.StartRouteAction, 32){

                        public void run() {
                            RouteNode.this.startMBean();
                        }
                    };
                    startRouteAction.setToolTipText(Messages.StartRouteActionToolTip);
                    startRouteAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("start_task.gif"));
                    mm.add((IAction)startRouteAction);
                }
                return null;
            }
        };
        this.getCamelContextNode().provideContextMenu(menu, fn);
    }

    protected void startMBean() {
        this.routeMBean.start();
    }

    protected void stopMBean() {
        this.routeMBean.stop();
    }

    public boolean isMBeanStarted() {
        String state = this.routeMBean.getState();
        return org.fusesource.ide.foundation.core.util.Objects.equal((Object)"Started", (Object)state);
    }

    @Override
    public String getNodeId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof RouteNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getConnection(), this.routeMBean, this.route.getId());
    }
}

