/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.messages;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.jmx.commons.messages.TypeConverters;

@XmlRootElement(name="header")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Header {
    @XmlAttribute(name="key", required=true)
    private String name;
    @XmlAttribute(required=false)
    private String type;
    @XmlValue
    private String text;
    @XmlTransient
    private Object value;

    public Header() {
    }

    public Header(String name, Object value) {
        this.name = name;
        this.value = value;
        if (value != null) {
            this.type = value.getClass().getCanonicalName();
        }
        this.getText();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        if (this.text == null) {
            this.text = Strings.getOrElse((Object)this.value, (String)"");
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.value = null;
    }

    public Object getValue() {
        if (this.value == null) {
            this.value = TypeConverters.stringToType(this.text, this.type);
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.text = null;
        this.value = value;
    }
}

