/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.diagram.view;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.graph.GraphLabelProviderSupport;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNode;
import org.fusesource.ide.jmx.commons.messages.INodeStatistics;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;
import org.fusesource.ide.jmx.diagram.view.DiagramView;
import org.fusesource.ide.jmx.diagram.view.JMXDiagramViewActivator;
import org.jboss.tools.jmx.core.HasName;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class DiagramGraphLabelProvider
extends GraphLabelProviderSupport
implements ILabelProvider,
IEntityStyleProvider,
IConnectionStyleProvider,
ISelectionChangedListener {
    private final DiagramView view;
    private Set<AbstractCamelModelElement> selectedConnections;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private boolean useNodeIdForLabel;

    public DiagramGraphLabelProvider(DiagramView view) {
        super(view.getViewer());
        this.view = view;
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        GraphViewer viewer = this.getViewer();
        if (this.selectedConnections != null) {
            for (AbstractCamelModelElement node : this.selectedConnections) {
                viewer.unReveal((Object)node);
            }
            this.selectedConnections = null;
        }
        if (!(selection = event.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            this.selectedConnections = new HashSet<AbstractCamelModelElement>();
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof AbstractCamelModelElement)) continue;
                AbstractCamelModelElement node = (AbstractCamelModelElement)o;
                viewer.reveal((Object)node);
                this.selectedConnections.add(node);
            }
        }
        Object[] connections = viewer.getConnectionElements();
        int i = 0;
        while (i < connections.length) {
            viewer.update(connections[i], null);
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (this.isShowIcon()) {
            if (this.isRouteNode(element)) {
                AbstractCamelModelElement node = (AbstractCamelModelElement)element;
                return JMXDiagramViewActivator.getDefault().getImage(node.getIconName().replaceAll(".png", "16.png"));
            }
            if (element instanceof ImageProvider) {
                ImageProvider node = (ImageProvider)element;
                return node.getImage();
            }
        }
        return null;
    }

    protected boolean isRouteNode(Object element) {
        return element instanceof AbstractCamelModelElement && !(element instanceof CamelElementConnection);
    }

    public String getText(Object element) {
        try {
            if (this.isRouteNode(element)) {
                AbstractCamelModelElement node = (AbstractCamelModelElement)element;
                return node.getDisplayText(this.useNodeIdForLabel);
            }
            if (element instanceof HasName) {
                HasName h = (HasName)element;
                return h.getName();
            }
            if (element instanceof CamelElementConnection) {
                return this.getText((CamelElementConnection)element);
            }
            if (element instanceof Node) {
                return Strings.getOrElse((Object)element, null);
            }
            if (element instanceof EntityConnectionData) {
                return this.getText((EntityConnectionData)element);
            }
            return null;
        }
        catch (Exception e) {
            JMXDiagramViewActivator.getLogger().warning("Caught exception trying to get label: " + e, (Throwable)e);
            return null;
        }
    }

    private String getText(EntityConnectionData element) {
        INodeStatistics stats;
        String nodeId = this.getNodeId(element);
        if (nodeId != null && (stats = this.getStatsFor(nodeId)) != null) {
            return this.statsLabel(stats);
        }
        return null;
    }

    private String getNodeId(EntityConnectionData element) {
        Object dest = element.dest;
        if (dest instanceof ProcessorNode) {
            return ((ProcessorNode)dest).getNodeId();
        }
        return null;
    }

    private String getText(CamelElementConnection flow) {
        INodeStatistics stats = this.getStatsFor(flow.getId());
        if (stats != null) {
            return this.statsLabel(stats);
        }
        return null;
    }

    public IFigure getTooltip(Object entity) {
        if (this.isRouteNode(entity)) {
            AbstractCamelModelElement node = (AbstractCamelModelElement)entity;
            String label = node.getDescription();
            String id = node.getId();
            if (id != null) {
                label = "[" + id + "] " + label;
            }
            return new Label(label);
        }
        if (entity instanceof CamelElementConnection) {
            INodeStatistics stats;
            CamelElementConnection flow = (CamelElementConnection)entity;
            if (flow.getTarget() != null && (stats = this.getStatsFor(flow.getTarget().getId())) != null) {
                return this.statsToolTip(stats);
            }
        } else {
            if (entity instanceof EntityConnectionData) {
                return this.getTooltip((EntityConnectionData)entity);
            }
            boolean cfr_ignored_0 = entity instanceof Node;
        }
        return null;
    }

    private IFigure getTooltip(EntityConnectionData entity) {
        INodeStatistics stats = this.getStatsFor(this.getNodeId(entity));
        if (stats != null) {
            return this.statsToolTip(stats);
        }
        return null;
    }

    protected INodeStatistics getStatsFor(String nodeId) {
        NodeStatisticsContainer traceExchangeList = this.view.getNodeStatisticsContainer();
        if (traceExchangeList != null) {
            return traceExchangeList.getNodeStats(nodeId);
        }
        return null;
    }

    protected String statsLabel(INodeStatistics stats) {
        long counter = stats.getCounter();
        if (counter > 0L) {
            return "Total: " + counter;
        }
        return "";
    }

    protected IFigure statsToolTip(INodeStatistics stats) {
        long counter = stats.getCounter();
        if (counter > 0L) {
            return new Label("Exchanges total: " + counter + " / mean time: " + this.numberFormat.format(stats.getMeanElapsedTime()) + " / max time: " + this.numberFormat.format(stats.getMaxElapsedTime()) + " / min time: " + this.numberFormat.format(stats.getMinElapsedTime()));
        }
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public int getBorderWidth(Object entity) {
        return 1;
    }

    public Color getBorderColor(Object entity) {
        return Display.getDefault().getSystemColor(16);
    }

    public Color getBorderHighlightColor(Object entity) {
        return Display.getDefault().getSystemColor(16);
    }

    public Color getForegroundColour(Object entity) {
        return Display.getDefault().getSystemColor(2);
    }

    public Color getBackgroundColour(Object entity) {
        return null;
    }

    public Color getNodeHighlightColor(Object entity) {
        return null;
    }

    public int getLineWidth(Object rel) {
        int lineWidth = 1;
        if (this.isRouteNode(rel) && this.selectedConnections != null && this.selectedConnections.contains(rel)) {
            return lineWidth;
        }
        return 0;
    }

    public Color getHighlightColor(Object rel) {
        return null;
    }

    public Color getColor(Object rel) {
        return Display.getDefault().getSystemColor(2);
    }

    public int getConnectionStyle(Object rel) {
        return 18;
    }
}

