/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.diagram.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.jmx.commons.tree.ConnectedNode;
import org.fusesource.ide.jmx.commons.tree.GraphableNode;
import org.fusesource.ide.jmx.commons.tree.GraphableNodeConnected;
import org.jboss.tools.jmx.core.tree.Node;

public class NodeGraphContentProvider
implements IStructuredContentProvider,
IGraphEntityContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object input) {
        if (input instanceof AbstractCamelModelElement) {
            CamelRouteElement parent;
            AbstractCamelModelElement node = (AbstractCamelModelElement)input;
            HashSet<AbstractCamelModelElement> set = new HashSet<AbstractCamelModelElement>();
            if (node instanceof CamelRouteElement) {
                parent = (CamelRouteElement)node;
            } else {
                parent = this.getRoute(node);
                set.add(node);
            }
            if (parent == null) {
                set.add(node.getOutputElement());
            } else {
                this.getAllChildren(parent.getChildElements(), set);
            }
            return set.toArray();
        }
        ArrayList answer = new ArrayList();
        if (!(input instanceof GraphableNode)) {
            if (input instanceof Node) {
                return this.getAllNodeChildren((Node)input, new HashSet<Node>()).toArray();
            }
            return null;
        }
        GraphableNode node = (GraphableNode)input;
        answer.addAll(node.getChildrenGraph());
        return answer.toArray();
    }

    private Set<Node> getAllNodeChildren(Node node, Set<Node> handledNodes) {
        HashSet<Node> res = new HashSet<Node>();
        res.add(node);
        handledNodes.add(node);
        for (Node child : node.getChildrenList()) {
            if (handledNodes.contains(child)) continue;
            res.addAll(this.getAllNodeChildren(child, handledNodes));
        }
        return res;
    }

    private CamelRouteElement getRoute(AbstractCamelModelElement e) {
        AbstractCamelModelElement cme = e;
        while (cme != null && !(cme instanceof CamelRouteElement)) {
            cme = cme.getParent();
        }
        if (cme != null && cme instanceof CamelRouteElement) {
            return (CamelRouteElement)cme;
        }
        return null;
    }

    private void getAllOutputs(AbstractCamelModelElement elem, Set<AbstractCamelModelElement> set) {
        AbstractCamelModelElement outputElement = elem.getOutputElement();
        if (outputElement != null) {
            set.add(outputElement);
        }
    }

    private void getAllChildren(List<AbstractCamelModelElement> elems, Set<AbstractCamelModelElement> set) {
        for (AbstractCamelModelElement e : elems) {
            set.add(e);
            this.getAllOutputs(e, set);
            if (e.getChildElements().isEmpty()) continue;
            this.getAllChildren(e.getChildElements(), set);
        }
    }

    public Object[] getConnectedTo(Object entity) {
        if (entity instanceof GraphableNodeConnected) {
            GraphableNodeConnected gn = (GraphableNodeConnected)entity;
            return gn.getGraphConnectedTo().toArray();
        }
        if (entity instanceof CamelRouteElement) {
            CamelRouteElement route = (CamelRouteElement)entity;
            return route.getInputs().toArray();
        }
        if (entity instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement node = (AbstractCamelModelElement)entity;
            return new Object[]{node.getOutputElement()};
        }
        if (entity instanceof ConnectedNode) {
            ConnectedNode node = (ConnectedNode)entity;
            return node.getConnectedTo().toArray();
        }
        if (entity instanceof Node) {
            Node aNode = (Node)entity;
            return aNode.getChildren();
        }
        return EMPTY;
    }
}

