/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.diagram.view;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class RouteGraphContentProvider
implements IGraphContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getSource(Object rel) {
        if (rel instanceof CamelElementConnection) {
            CamelElementConnection flow = (CamelElementConnection)rel;
            return flow.getSource();
        }
        return null;
    }

    public Object getDestination(Object rel) {
        if (rel instanceof CamelElementConnection) {
            CamelElementConnection flow = (CamelElementConnection)rel;
            return flow.getTarget();
        }
        return null;
    }

    public Object[] getElements(Object input) {
        if (input instanceof Object[]) {
            return (Object[])input;
        }
        if (input instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement node = (AbstractCamelModelElement)input;
            HashSet set = new HashSet();
            CamelRouteElement parent = node instanceof CamelRouteElement ? (CamelRouteElement)node : this.getRoute(node);
            HashSet<AbstractCamelModelElement> descendents = new HashSet<AbstractCamelModelElement>();
            if (parent == null) {
                this.getAllChildren(node.getChildElements(), descendents);
            } else {
                this.getAllChildren(parent.getChildElements(), descendents);
            }
            return set.toArray();
        }
        return null;
    }

    private void getAllOutputs(AbstractCamelModelElement elem, Set<AbstractCamelModelElement> set) {
        if (elem.getOutputElement() != null) {
            set.add(elem.getOutputElement());
        }
    }

    private void getAllChildren(List<AbstractCamelModelElement> elems, Set<AbstractCamelModelElement> set) {
        for (AbstractCamelModelElement e : elems) {
            set.add(e);
            this.getAllOutputs(e, set);
            if (e.getChildElements().isEmpty()) continue;
            this.getAllChildren(e.getChildElements(), set);
        }
    }

    private CamelRouteElement getRoute(AbstractCamelModelElement e) {
        AbstractCamelModelElement cme = e;
        while (cme != null && !(cme instanceof CamelRouteElement)) {
            cme = cme.getParent();
        }
        if (cme != null && cme instanceof CamelRouteElement) {
            return (CamelRouteElement)cme;
        }
        return null;
    }
}

