/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.connection;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.fusesource.ide.jmx.karaf.connection.AbstractKarafJMXConnectionProvider;
import org.fusesource.ide.jmx.karaf.connection.KarafActiveJvm;
import org.fusesource.ide.jmx.karaf.connection.KarafJVMFacadeUtility;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.ErrorRoot;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmFacade;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;

public class KarafServerConnection
implements IConnectionWrapper,
IServerListener,
IConnectionProviderListener,
IJvmFacade,
IAdaptable {
    private IServer server;
    private Root root;
    private boolean isConnected;
    private boolean isLoading;
    private JMXConnector jmxc;
    private MBeanServerConnection activeConnection;
    private KarafActiveJvm customJvm;

    public KarafServerConnection(IServer server) {
        this.server = server;
        this.isConnected = false;
        this.isLoading = false;
        this.connectViaJmxIfRequired(server);
        ((AbstractKarafJMXConnectionProvider)this.getProvider()).addListener(this);
        server.addServerListener((IServerListener)this);
    }

    public void connect() throws IOException {
        this.connectToStartedServer();
    }

    public void disconnect() throws IOException {
        if (this.activeConnection != null) {
            this.cleanupConnection(this.server, this.activeConnection);
        }
        if (this.customJvm != null) {
            this.customJvm.disconnect();
            this.customJvm = null;
        }
        this.activeConnection = null;
        this.root = null;
        this.isConnected = false;
        ((AbstractKarafJMXConnectionProvider)this.getProvider()).fireChanged(this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.fusesource.ide.jmx.karaf.connection.KarafConnectionProvider");
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot(IProgressMonitor monitor) {
        if (this.isConnected() && !this.isLoading) {
            this.isLoading = true;
            try {
                try {
                    if (this.root == null) {
                        this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException ce) {
                    Status status = new Status(4, "org.fusesource.ide.jmx.karaf", ce.getMessage(), (Throwable)ce);
                    KarafJMXPlugin.getDefault().getLog().log((IStatus)status);
                    this.root = new ErrorRoot();
                    this.isLoading = false;
                }
            }
            finally {
                this.isLoading = false;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected boolean shouldUseDefaultCredentials() {
        return true;
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        this.run(runnable, new HashMap<String, String>());
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        this.run(runnable, prefs, false);
    }

    public void run(IJMXRunnable runnable, Map<String, String> prefs, boolean saveActiveConnection) throws JMXException {
        if (this.getServer().getAdapter(IKarafServerDelegate.class) != null) {
            IKarafServerDelegate kserver = (IKarafServerDelegate)this.getServer().getAdapter(IKarafServerDelegate.class);
            String user = kserver.getUserName();
            String pass = kserver.getPassword();
            this.run(this.server, runnable, user, pass, saveActiveConnection);
        }
    }

    protected void run(IServer s, IJMXRunnable r, String user, String pass) throws JMXException {
        this.run(s, r, user, pass, false);
    }

    protected void run(IServer s, IJMXRunnable r, String user, String pass, boolean saveActiveConnection) throws JMXException {
        try {
            MBeanServerConnection c = null;
            if (this.activeConnection == null) {
                c = this.createConnection(s, user, pass);
                if (saveActiveConnection) {
                    this.activeConnection = c;
                }
            } else {
                c = this.activeConnection;
            }
            r.run(c);
        }
        catch (Exception e) {
            KarafJMXPlugin.getLogger().error((Throwable)e);
        }
    }

    protected MBeanServerConnection createConnection(IServer s, String user, String pass) throws IOException {
        HashMap<String, String[]> envMap = new HashMap<String, String[]>();
        envMap.put("jmx.remote.credentials", new String[]{user, pass});
        String conUrl = KarafUtils.getJMXConnectionURL((IServer)s);
        JMXServiceURL url = new JMXServiceURL(conUrl);
        this.jmxc = JMXConnectorFactory.connect(url, envMap);
        return this.jmxc.getMBeanServerConnection();
    }

    protected void cleanupConnection(IServer server, MBeanServerConnection connection) {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
            }
        }
        catch (Exception ex) {
            KarafJMXPlugin.getLogger().error((Throwable)ex);
        }
    }

    public String getName() {
        return this.server.getName();
    }

    public void serverChanged(ServerEvent event) {
        int eventKind = event.getKind();
        if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0) {
            this.connectViaJmxIfRequired(event.getServer());
        }
    }

    protected void connectViaJmxIfRequired(IServer server) {
        if (!this.shouldConnect(server)) {
            try {
                this.disconnect();
            }
            catch (IOException ioe) {
                KarafJMXPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.fusesource.ide.jmx.karaf", "Unable to cleanly disconnect jmx connection", (Throwable)ioe));
            }
        }
    }

    protected boolean shouldConnect(IServer server) {
        boolean hasRuntime;
        boolean started = server.getServerState() == 2;
        boolean bl = hasRuntime = server.getRuntime() != null;
        return started && hasRuntime;
    }

    protected void launchConnectionJob(final IServer server) {
        new Job("Connecting to " + server.getName() + " via JMX"){

            protected IStatus run(IProgressMonitor monitor) {
                if (server.getServerState() == 2) {
                    KarafServerConnection.this.connectToStartedServer();
                }
                return Status.OK_STATUS;
            }
        }.schedule(5000L);
    }

    protected void connectToStartedServer() {
        block3: {
            try {
                IJMXRunnable run = new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws Exception {
                    }
                };
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("force", Boolean.toString(true));
                this.run(run, map, true);
                if (!this.isConnected) {
                    this.isConnected = true;
                    ((AbstractKarafJMXConnectionProvider)this.getProvider()).fireChanged(this);
                }
            }
            catch (Exception jmxe) {
                Status status = new Status(4, "org.fusesource.ide.jmx.karaf", "Error connecting to jmx for server " + this.server.getName(), (Throwable)jmxe);
                KarafJMXPlugin.getDefault().getLog().log((IStatus)status);
                if (!this.isConnected) break block3;
                this.isConnected = false;
                ((AbstractKarafJMXConnectionProvider)this.getProvider()).fireChanged(this);
            }
        }
    }

    public void connectionAdded(IConnectionWrapper connection) {
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        if (connection == this) {
            this.server.removeServerListener((IServerListener)this);
        }
    }

    public boolean canControl() {
        return this.server.getServerState() == 2 && this.server.getRuntime() != null;
    }

    public IActiveJvm getActiveJvm() {
        if (this.server.getServerState() == 2 && this.isConnected) {
            if (this.customJvm == null) {
                IActiveJvm active = KarafJVMFacadeUtility.findJvmForServer(this.server);
                try {
                    this.customJvm = new KarafActiveJvm(this, active);
                }
                catch (JvmCoreException jvmce) {
                    KarafJMXPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.fusesource.ide.jmx.karaf", jvmce.getMessage(), (Throwable)jvmce));
                }
            }
            return this.customJvm;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.jboss.tools.jmx.jvmmonitor.ui.JvmExplorer";
            }
        };
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(contributor);
        }
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return contributor;
        }
        return null;
    }

    public MBeanServerConnection getActiveConnection() {
        return this.activeConnection;
    }

    public IServer getServer() {
        return this.server;
    }
}

