/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.navigator.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.ui.jobs.Jobs;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.fusesource.ide.jmx.karaf.Messages;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundleStateFacade;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesNode;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesTableSheetPage;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesTableView;

public class BundlesTabSection
extends BundlesTableView {
    private BundlesNode current;
    private Action startBundleAction = new Action(Messages.StartBundleAction, 32){

        public void run() {
            BundlesTabSection.this.startBundles();
        }
    };
    private Action stopBundleAction;
    private Action uninstallBundleAction;
    private NotificationListener notificationListener;

    public BundlesTabSection() {
        super(BundlesTableSheetPage.VIEW_ID, null);
        this.startBundleAction.setToolTipText(Messages.StartBundleActionToolTip);
        this.startBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("start_task.gif"));
        this.startBundleAction.setId(String.valueOf(BundlesTabSection.class.getName()) + ".Start");
        this.stopBundleAction = new Action(Messages.StopBundleAction, 32){

            public void run() {
                BundlesTabSection.this.stopBundles();
            }
        };
        this.stopBundleAction.setToolTipText(Messages.StopBundleActionToolTip);
        this.stopBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("stop_task.gif"));
        this.stopBundleAction.setId(String.valueOf(BundlesTabSection.class.getName()) + ".Stop");
        this.uninstallBundleAction = new Action(Messages.UninstallBundleAction, 32){

            public void run() {
                BundlesTabSection.this.uninstallBundles();
            }
        };
        this.uninstallBundleAction.setToolTipText(Messages.UninstallBundleActionToolTip);
        this.uninstallBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("delete.gif"));
        this.uninstallBundleAction.setId(String.valueOf(BundlesTabSection.class.getName()) + ".Uninstall");
        this.startBundleAction.setEnabled(false);
        this.stopBundleAction.setEnabled(false);
        this.uninstallBundleAction.setEnabled(false);
        this.notificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                BundlesTabSection.this.refresh();
            }
        };
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HashSet<String> states = new HashSet<String>(BundlesTabSection.this.getSelectedBundleIDStates().values());
                BundlesTabSection.this.startBundleAction.setEnabled(!states.isEmpty() && !states.contains("ACTIVE"));
                BundlesTabSection.this.stopBundleAction.setEnabled(!states.isEmpty() && states.contains("ACTIVE"));
                BundlesTabSection.this.uninstallBundleAction.setEnabled(!states.isEmpty() && !states.contains("ACTIVE"));
            }
        });
        this.addToolBarActions(new Object[]{this.startBundleAction, this.stopBundleAction, this.uninstallBundleAction});
        this.addLocalMenuActions(new Object[]{this.startBundleAction, this.stopBundleAction, this.uninstallBundleAction});
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        BundlesNode bundles = (BundlesNode)((Object)Selections.getFirstSelection((ISelection)selection));
        if (bundles == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.getFacade().removeBundleStateNotificationListener(this.notificationListener, null, null);
        }
        this.current = bundles;
        List<Object> propertySources = bundles == null ? Collections.emptyList() : bundles.getPropertySourceList();
        this.setPropertySources(propertySources);
        this.getViewer().setInput(propertySources);
        this.recreateColumns();
        this.getSearchText().setText(this.getInitialSearchText());
        this.getViewer().refresh(true);
    }

    @Override
    protected String getInitialSearchText() {
        String searchText = this.current == null ? null : this.current.getBundlefilterText();
        return searchText == null ? "" : searchText;
    }

    protected void recreateColumns() {
        if (this.current != null) {
            super.recreateColumns();
        }
    }

    public void aboutToBeShown() {
        if (this.current != null) {
            this.current.getFacade().addBundleStateNotificationListener(this.notificationListener, null, null);
        }
        super.aboutToBeShown();
    }

    public void aboutToBeHidden() {
        if (this.current != null) {
            this.current.getFacade().removeBundleStateNotificationListener(this.notificationListener, null, null);
        }
        super.aboutToBeHidden();
    }

    protected void startBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Start bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTabSection.this.current.getFacade().startBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void stopBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Stop bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTabSection.this.current.getFacade().stopBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void uninstallBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Uninstall bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTabSection.this.current.getFacade().uninstallBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void doUpdate(String message, final Callable<Boolean> callable) {
        Jobs.schedule((String)message, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Boolean answer = (Boolean)callable.call();
                if (answer != null && answer.booleanValue()) {
                    BundlesTabSection.this.refresh();
                }
                return answer;
            }
        });
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                Set<Long> selectedBundleIds = BundlesTabSection.this.getSelectedBundleIDStates().keySet();
                BundlesTabSection.this.setPropertySources(BundlesTabSection.this.current.getPropertySourceList());
                BundlesTabSection.super.refresh();
                BundlesTabSection.this.setSelectedBundleIds(selectedBundleIds);
            }
        });
    }

    protected void setSelectedBundleIds(Set<Long> selectedBundleIds) {
        TableViewer viewer = this.getViewer();
        if (viewer != null) {
            List propertySources = this.getPropertySources();
            ArrayList selected = new ArrayList();
            for (Object object : propertySources) {
                BundleStateFacade bundleState;
                Long id;
                if (!(object instanceof IPropertySource) || (id = (bundleState = new BundleStateFacade((IPropertySource)object)).getId()) == null || !selectedBundleIds.contains(id)) continue;
                selected.add(object);
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
            if (selected.size() == 1) {
                Object first = selected.get(0);
                viewer.reveal(first);
            }
        }
    }

    protected long[] getSelectedBundleIds() {
        Set<Long> ids = this.getSelectedBundleIDStates().keySet();
        long[] answer = new long[ids.size()];
        int idx = 0;
        for (Long n : ids) {
            if (n == null) continue;
            answer[idx++] = n;
        }
        return answer;
    }

    protected Map<Long, String> getSelectedBundleIDStates() {
        HashMap<Long, String> answer = new HashMap<Long, String>();
        IStructuredSelection selection = Selections.getStructuredSelection((Viewer)this.getViewer());
        if (selection != null) {
            for (Object value : selection) {
                if (!(value instanceof IPropertySource)) continue;
                BundleStateFacade bundleState = new BundleStateFacade((IPropertySource)value);
                Long id = bundleState.getId();
                String state = bundleState.getState();
                if (id == null || state == null) continue;
                answer.put(id, state);
            }
        }
        return answer;
    }

    public BundlesNode getCurrent() {
        return this.current;
    }
}

