/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class MarkerNodeRemovalEventHandler
implements EventHandler {
    public void handleEvent(Event event) {
        Object cme = event.getProperty("org.eclipse.e4.data");
        if (cme instanceof AbstractCamelModelElement) {
            for (AbstractCamelModelElement child : ((AbstractCamelModelElement)cme).getChildElements()) {
                this.clearBreakpoints(child);
            }
            this.clearBreakpoints((AbstractCamelModelElement)cme);
        }
    }

    private void clearBreakpoints(AbstractCamelModelElement cme) {
        IResource resource = cme.getCamelFile().getResource();
        IBreakpoint breakpoint = CamelDebugUtils.getBreakpointForSelection(cme.getId(), resource.getName(), resource.getProject().getName());
        if (breakpoint != null) {
            try {
                breakpoint.delete();
            }
            catch (CoreException e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
    }
}

